/*
 * Decompiled with CFR 0.152.
 */
package com.zegome.utils.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.TextView;
import com.zegome.utils.R;
import com.zegome.utils.font.FontHelper;

public class ZTextView
extends TextView {
    private boolean mIsStroke = false;
    private int mStrokeWidth = 0;
    private int mStrokeColor;
    private boolean mIsCustomFont = false;
    private String mFontName = null;
    private Context mContext = null;

    public ZTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public ZTextView(Context context) {
        this(context, null);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mIsStroke) {
            ColorStateList states = this.getTextColors();
            this.getPaint().setStyle(Paint.Style.STROKE);
            this.getPaint().setStrokeWidth((float)this.mStrokeWidth);
            this.setTextColor(this.mStrokeColor);
            super.onDraw(canvas);
            this.getPaint().setStyle(Paint.Style.FILL);
            this.setTextColor(states);
        }
        super.onDraw(canvas);
    }

    private void initView(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ZTextView);
        this.mIsStroke = a.getBoolean(R.styleable.ZTextView_useStroke, false);
        this.mStrokeWidth = a.getDimensionPixelSize(R.styleable.ZTextView_strokeWidth, 0);
        this.mStrokeColor = a.getColor(R.styleable.ZTextView_strokeColor, -1);
        this.mIsCustomFont = a.getBoolean(R.styleable.ZTextView_useFont, false);
        this.mFontName = a.getString(R.styleable.ZTextView_fontName);
        if (this.mIsCustomFont && this.mFontName != null && !"".equals(this.mFontName)) {
            FontHelper.setCustomFont(this, this.mFontName, context);
        }
        a.recycle();
    }
}

