/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk.api;

import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.api.YunpianApiResult;
import com.yunpian.sdk.constant.Code;
import com.yunpian.sdk.constant.YunpianConstant;
import com.yunpian.sdk.model.Result;
import com.yunpian.sdk.util.ApiUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YunpianApi
implements YunpianConstant,
YunpianApiResult {
    static final Logger LOG = LoggerFactory.getLogger(YunpianApi.class);
    private YunpianClient client;
    private String host;
    private String version;
    private String path;
    private String apikey;
    private String charset;

    public YunpianClient client() {
        return this.client;
    }

    public synchronized void init(YunpianClient clnt) {
        if (clnt == null) {
            return;
        }
        this.client = clnt;
        this.apikey(clnt.getConf().getApikey()).version(clnt.getConf().getConf("yp.version", "v2")).charset(clnt.getConf().getConf("http.charset", "utf-8"));
    }

    public String charset() {
        return this.charset;
    }

    public YunpianApi charset(String charset) {
        this.charset = charset;
        return this;
    }

    public String uri() {
        StringBuilder buf = new StringBuilder(this.host().length() + this.version().length() + this.name().length() + this.path().length() + 3);
        buf.append(this.host()).append("/").append(this.version()).append("/").append(this.name()).append("/").append(this.path());
        return buf.toString();
    }

    public abstract String name();

    public String host() {
        return this.host;
    }

    public YunpianApi host(String host) {
        this.host = host;
        return this;
    }

    public String version() {
        return this.version;
    }

    public YunpianApi version(String v) {
        this.version = v;
        return this;
    }

    public String path() {
        return this.path;
    }

    public YunpianApi path(String path) {
        this.path = path;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof YunpianApi) {
            return ((YunpianApi)obj).name().equals(this.name());
        }
        return false;
    }

    public String toString() {
        return "YunpianApi-" + this.name();
    }

    public String apikey() {
        return this.apikey;
    }

    public YunpianApi apikey(String apikey) {
        this.apikey = apikey;
        return this;
    }

    public String post(String uri, String data) throws Exception {
        Future<HttpResponse> rsp = this.client().post(uri, data, this.charset());
        return EntityUtils.toString((HttpEntity)rsp.get(this.client().getConf().getConfLong("http.so.timeout", "10000"), TimeUnit.MILLISECONDS).getEntity(), (String)this.charset());
    }

    public String post(String uri, HttpEntity entity) throws Exception {
        Future<HttpResponse> rsp = this.client().post(uri, entity, null);
        return EntityUtils.toString((HttpEntity)rsp.get(this.client().getConf().getConfLong("http.so.timeout", "10000"), TimeUnit.MILLISECONDS).getEntity(), (String)this.charset());
    }

    public <R, T> Result<T> post(String data, YunpianApiResult.ResultHandler<R, T> h) {
        return this.post(this.uri(), data, h, new Result());
    }

    public <R, T> Result<T> post(String data, YunpianApiResult.ResultHandler<R, T> h, Result<T> r) {
        return this.post(this.uri(), data, h, r);
    }

    public <R, T> Result<T> post(String uri, String data, YunpianApiResult.ResultHandler<R, T> h, Result<T> r) {
        LOG.debug("post uri-{} data-{}", (Object)uri, (Object)data);
        try {
            String rsp = this.post(uri, data);
            return this.result(rsp, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public <R, T> Result<T> post(HttpEntity data, YunpianApiResult.ResultHandler<R, T> h, Result<T> r) {
        return this.post(this.uri(), data, h, r);
    }

    public <R, T> Result<T> post(String uri, HttpEntity data, YunpianApiResult.ResultHandler<R, T> h, Result<T> r) {
        LOG.debug("post uri-{} data-{}", (Object)uri, (Object)data);
        try {
            String rsp = this.post(uri, data);
            return this.result(rsp, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public static Integer code(Map<String, String> rsp, String version) {
        Integer code = -50;
        if (version == null) {
            version = "v2";
        }
        if (rsp != null) {
            switch (version) {
                case "v1": {
                    code = rsp.containsKey("code") ? (int)Double.parseDouble(rsp.get("code")) : -50;
                    break;
                }
                case "v2": {
                    code = rsp.containsKey("code") ? (int)Double.parseDouble(rsp.get("code")) : 0;
                }
            }
        }
        return code;
    }

    @Override
    public <R, T> Result<T> result(String rspContent, YunpianApiResult.ResultHandler<R, T> h, Result<T> r) {
        try {
            R rsp = h.response(rspContent);
            Integer code = h.code(rsp);
            return code == 0 ? h.succ(code, rsp, r) : h.fail(code, rsp, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    protected <T> List<NameValuePair> param2pair(Map<String, String> param, Result<T> r, String ... must) {
        LOG.debug("param2pair param-{} must-{}", param, (Object)must);
        if (param == null) {
            param = Collections.emptyMap();
        }
        if (r == null) {
            r = new Result();
        }
        LinkedList<NameValuePair> pair = new LinkedList<NameValuePair>();
        if (!param.containsKey("apikey")) {
            if (null == this.apikey()) {
                LOG.error("apikey is null");
                r.setCode(1).setMsg(Code.getErrorMsg(1) + "-" + "apikey");
                return pair;
            }
            pair.add((NameValuePair)new BasicNameValuePair("apikey", this.apikey()));
        }
        for (String m : must) {
            if (m.equals("apikey") || param.get(m) != null) continue;
            LOG.error("miss must-{} in param-{}", (Object)m, param);
            r.setCode(1).setMsg(Code.getErrorMsg(1) + "-" + m);
            return pair;
        }
        for (Map.Entry entry : param.entrySet()) {
            pair.add((NameValuePair)new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
        }
        return pair;
    }

    protected String urlEncode(List<NameValuePair> param) {
        if (param == null) {
            return "";
        }
        return URLEncodedUtils.format(param, (String)this.charset());
    }

    public String urlEncode(String text) {
        return ApiUtil.urlEncode(text, this.charset());
    }
}

