package com.qipeng.captcha.utils;

import android.content.Context;

import java.io.File;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * OnePiece
 * Created by xukq on 6/6/19.
 */
public class LogUtils {

    public static final String LOG_TYPE_ERROR = "error";
    public static final String LOG_TYPE_SUCCESS = "success";
    public static final String LOG_TYPE_OTHER = "other";

    public static void writeLogToSD(Context context, String interfaceName, String content) {
        try {
            File logFileDir = context.getExternalFilesDir("qipeng_log");
            if (logFileDir != null) {
                if (!logFileDir.exists()) {
                    logFileDir.mkdirs();
                }
                if (!logFileDir.exists()) {
                    return;
                }
                File logFile = new File(logFileDir, interfaceName + "-" + getNowTime());
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                RandomAccessFile rf = new RandomAccessFile(logFile,"rwd");
                rf.seek(logFile.length());
                rf.write(content.getBytes());
                rf.close();
            }
        } catch (Exception e) {
            // 避免错误导致宿主 App 崩溃
        }
    }

    private static String getNowTime() {
        Date currentTime = new Date(System.currentTimeMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(currentTime);
    }


}
