/*
 * Decompiled with CFR 0.152.
 */
package com.androidquery.callback;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;
import com.androidquery.callback.AbstractAjaxCallback;
import com.androidquery.callback.AjaxStatus;
import com.androidquery.util.AQUtility;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class LocationAjaxCallback
extends AbstractAjaxCallback<Location, LocationAjaxCallback> {
    private LocationManager lm;
    private long timeout = 30000L;
    private long interval = 1000L;
    private float tolerance = 10.0f;
    private float accuracy = 1000.0f;
    private int iteration = 3;
    private int n = 0;
    private boolean networkEnabled = false;
    private boolean gpsEnabled = false;
    private Listener networkListener;
    private Listener gpsListener;
    private long initTime;

    public LocationAjaxCallback() {
        ((LocationAjaxCallback)this.type(Location.class)).url("device");
    }

    @Override
    public void async(Context context) {
        this.lm = (LocationManager)context.getSystemService("location");
        this.gpsEnabled = this.lm.isProviderEnabled("gps");
        this.networkEnabled = this.lm.isProviderEnabled("network");
        this.work();
    }

    public LocationAjaxCallback timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public LocationAjaxCallback accuracy(float accuracy) {
        this.accuracy = accuracy;
        return this;
    }

    public LocationAjaxCallback tolerance(float tolerance) {
        this.tolerance = tolerance;
        return this;
    }

    public LocationAjaxCallback iteration(int iteration) {
        this.iteration = iteration;
        return this;
    }

    private void check(Location loc) {
        if (loc != null && this.isBetter(loc)) {
            ++this.n;
            boolean last = this.n >= this.iteration;
            boolean accurate = this.isAccurate(loc);
            boolean diff = this.isDiff(loc);
            boolean best = !this.gpsEnabled || "gps".equals(loc.getProvider());
            AQUtility.debug(this.n, this.iteration);
            AQUtility.debug("acc", accurate);
            AQUtility.debug("best", best);
            if (diff) {
                if (last) {
                    if (accurate && best) {
                        this.stop();
                        this.callback(loc);
                    }
                } else {
                    if (accurate && best) {
                        this.stop();
                    }
                    this.callback(loc);
                }
            }
        }
    }

    private void callback(Location loc) {
        this.result = loc;
        this.status(loc, 200);
        this.callback();
    }

    private void status(Location loc, int code) {
        if (this.status == null) {
            this.status = new AjaxStatus();
        }
        if (loc != null) {
            this.status.time(new Date(loc.getTime()));
        }
        this.status.code(code).done().source(5);
    }

    private boolean isAccurate(Location loc) {
        return loc.getAccuracy() < this.accuracy;
    }

    private boolean isDiff(Location loc) {
        if (this.result == null) {
            return true;
        }
        float diff = LocationAjaxCallback.distFrom(((Location)this.result).getLatitude(), ((Location)this.result).getLongitude(), loc.getLatitude(), loc.getLongitude());
        if (diff < this.tolerance) {
            AQUtility.debug("duplicate location");
            return false;
        }
        return true;
    }

    private boolean isBetter(Location loc) {
        if (this.result == null) {
            return true;
        }
        if (((Location)this.result).getTime() > this.initTime && ((Location)this.result).getProvider().equals("gps") && loc.getProvider().equals("network")) {
            AQUtility.debug("inferior location");
            return false;
        }
        return true;
    }

    private void failure() {
        if (this.gpsListener == null && this.networkListener == null) {
            return;
        }
        AQUtility.debug("fail");
        this.result = null;
        this.status(null, -103);
        this.stop();
        this.callback();
    }

    public void stop() {
        Listener nListener;
        AQUtility.debug("stop");
        Listener gListener = this.gpsListener;
        if (gListener != null) {
            this.lm.removeUpdates((LocationListener)gListener);
            gListener.cancel();
        }
        if ((nListener = this.networkListener) != null) {
            this.lm.removeUpdates((LocationListener)nListener);
            nListener.cancel();
        }
        this.gpsListener = null;
        this.networkListener = null;
    }

    private void work() {
        Location loc = this.getBestLocation();
        Timer timer = new Timer(false);
        if (this.networkEnabled) {
            AQUtility.debug("register net");
            this.networkListener = new Listener();
            this.lm.requestLocationUpdates("network", this.interval, 0.0f, (LocationListener)this.networkListener, Looper.getMainLooper());
            timer.schedule((TimerTask)this.networkListener, this.timeout);
        }
        if (this.gpsEnabled) {
            AQUtility.debug("register gps");
            this.gpsListener = new Listener();
            this.lm.requestLocationUpdates("gps", this.interval, 0.0f, (LocationListener)this.gpsListener, Looper.getMainLooper());
            timer.schedule((TimerTask)this.gpsListener, this.timeout);
        }
        if (this.iteration > 1 && loc != null) {
            ++this.n;
            this.callback(loc);
        }
        this.initTime = System.currentTimeMillis();
    }

    private Location getBestLocation() {
        Location loc1 = this.lm.getLastKnownLocation("gps");
        Location loc2 = this.lm.getLastKnownLocation("network");
        if (loc2 == null) {
            return loc1;
        }
        if (loc1 == null) {
            return loc2;
        }
        if (loc1.getTime() > loc2.getTime()) {
            return loc1;
        }
        return loc2;
    }

    private static float distFrom(double lat1, double lng1, double lat2, double lng2) {
        double earthRadius = 3958.75;
        double dLat = Math.toRadians(lat2 - lat1);
        double dLng = Math.toRadians(lng2 - lng1);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(dLng / 2.0) * Math.sin(dLng / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double dist = earthRadius * c;
        int meterConversion = 1609;
        return (float)dist * (float)meterConversion;
    }

    private class Listener
    extends TimerTask
    implements LocationListener {
        private Listener() {
        }

        public void onLocationChanged(Location location) {
            AQUtility.debug("changed", location);
            LocationAjaxCallback.this.check(location);
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            AQUtility.debug("onStatusChanged");
        }

        public void onProviderEnabled(String provider) {
            AQUtility.debug("onProviderEnabled");
            LocationAjaxCallback.this.check(LocationAjaxCallback.this.getBestLocation());
            LocationAjaxCallback.this.lm.removeUpdates((LocationListener)this);
        }

        public void onProviderDisabled(String provider) {
            AQUtility.debug("onProviderDisabled");
        }

        @Override
        public void run() {
            LocationAjaxCallback.this.failure();
        }
    }
}

