/*
 * Decompiled with CFR 0.152.
 */
package com.androidquery.auth;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Bundle;
import android.preference.PreferenceManager;
import com.androidquery.AQuery;
import com.androidquery.auth.AccountHandle;
import com.androidquery.callback.AbstractAjaxCallback;
import com.androidquery.callback.AjaxStatus;
import com.androidquery.util.AQUtility;
import org.apache.http.HttpRequest;

public class GoogleHandle
extends AccountHandle
implements DialogInterface.OnClickListener,
DialogInterface.OnCancelListener {
    private AccountManager am;
    private Account acc;
    private String type;
    private Activity act;
    private String email;
    private Account[] accs;
    private String token;

    public GoogleHandle(Activity act, String type, String email) {
        if ("aq.account".equals(email)) {
            email = GoogleHandle.getActiveAccount((Context)act);
        }
        this.act = act;
        this.type = type.substring(2);
        this.email = email;
        this.am = AccountManager.get((Context)act);
    }

    @Override
    protected void auth() {
        if (this.email == null) {
            this.accountDialog();
        } else {
            Account[] accounts = this.am.getAccountsByType("com.google");
            int i = 0;
            while (i < accounts.length) {
                Account account = accounts[i];
                if (this.email.equals(account.name)) {
                    this.auth(account);
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean reauth(AbstractAjaxCallback<?, ?> cb) {
        this.am.invalidateAuthToken(this.acc.type, this.token);
        try {
            this.token = this.am.blockingGetAuthToken(this.acc, this.type, true);
            AQUtility.debug("re token", this.token);
        }
        catch (Exception e) {
            AQUtility.debug(e);
            this.token = null;
        }
        return this.token != null;
    }

    public String getType() {
        return this.type;
    }

    private void accountDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.act);
        this.accs = this.am.getAccountsByType("com.google");
        int size = this.accs.length;
        if (size == 1) {
            this.auth(this.accs[0]);
        } else {
            CharSequence[] names = new String[size];
            int i = 0;
            while (i < size) {
                names[i] = this.accs[i].name;
                ++i;
            }
            builder.setItems(names, (DialogInterface.OnClickListener)this);
            builder.setOnCancelListener((DialogInterface.OnCancelListener)this);
            AlertDialog dialog = builder.create();
            new AQuery(this.act).show((Dialog)dialog);
        }
    }

    public void onClick(DialogInterface dialog, int which) {
        Account acc = this.accs[which];
        AQUtility.debug("acc", acc.name);
        GoogleHandle.setActiveAccount((Context)this.act, acc.name);
        this.auth(acc);
    }

    public static void setActiveAccount(Context context, String account) {
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putString("aq.account", account).commit();
    }

    public static String getActiveAccount(Context context) {
        return PreferenceManager.getDefaultSharedPreferences((Context)context).getString("aq.account", null);
    }

    private void auth(Account account) {
        this.acc = account;
        Task task = new Task();
        task.execute(new String[0]);
    }

    public void onCancel(DialogInterface dialog) {
        this.failure((Context)this.act, -102, "cancel");
    }

    @Override
    public boolean expired(AbstractAjaxCallback<?, ?> cb, AjaxStatus status) {
        int code = status.getCode();
        return code == 401 || code == 403;
    }

    @Override
    public void applyToken(AbstractAjaxCallback<?, ?> cb, HttpRequest request) {
        request.addHeader("Authorization", "GoogleLogin auth=" + this.token);
    }

    @Override
    public String getCacheUrl(String url) {
        return String.valueOf(url) + "#" + this.token;
    }

    @Override
    public boolean authenticated() {
        return this.token != null;
    }

    private class Task
    extends AsyncTask<String, String, Bundle> {
        private Task() {
        }

        protected Bundle doInBackground(String ... params) {
            Bundle bundle = null;
            try {
                AccountManagerFuture future = GoogleHandle.this.am.getAuthToken(GoogleHandle.this.acc, GoogleHandle.this.type, null, GoogleHandle.this.act, null, null);
                bundle = (Bundle)future.getResult();
            }
            catch (OperationCanceledException future) {
            }
            catch (AuthenticatorException e) {
                AQUtility.debug(e);
            }
            catch (Exception e) {
                AQUtility.debug(e);
            }
            return bundle;
        }

        protected void onPostExecute(Bundle bundle) {
            if (bundle != null && bundle.containsKey("authtoken")) {
                GoogleHandle.this.token = bundle.getString("authtoken");
                GoogleHandle.this.success((Context)GoogleHandle.this.act);
            } else {
                GoogleHandle.this.failure((Context)GoogleHandle.this.act, -102, "rejected");
            }
        }
    }
}

