/*
 * Decompiled with CFR 0.152.
 */
package com.youngfeng.snake.compiler;

import com.google.auto.common.SuperficialValidation;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.youngfeng.snake.annotations.EnableDragToClose;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public class SnakeProcessor
extends AbstractProcessor {
    private static final String FRAGMENT_TYPE = "android.app.Fragment";
    private static final String SUPPORT_FRAGMENT_TYPE = "androidx.fragment.app.Fragment";
    private static final String SNAKE_FRAGMENT_TYPE = "com.youngfeng.snake.app.Fragment";
    private static final String SUPPORT_SNAKE_FRAGMENT_TYPE = "com.youngfeng.snake.androidx.app.Fragment";
    private static final String ACTIVITY_TYPE = "android.app.Activity";
    private static final String LAYOUT_INFLATER_TYPE = "android.view.LayoutInflater";
    private static final String VIEWGROUP_TYPE = "android.view.ViewGroup";
    private static final String BUNDLE_TYPE = "android.os.Bundle";
    private Filer mFiler;
    private Elements mElementUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.mFiler = processingEnvironment.getFiler();
        this.mElementUtils = processingEnvironment.getElementUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment env) {
        for (Element element : env.getElementsAnnotatedWith(EnableDragToClose.class)) {
            if (!SuperficialValidation.validateElement((Element)element)) continue;
            this.parseEnableDragToClose(element);
        }
        return false;
    }

    private void parseEnableDragToClose(Element element) {
        boolean hasError = this.isBindingInWrongClass(element, EnableDragToClose.class);
        if (hasError) {
            return;
        }
        TypeMirror elementType = element.asType();
        if (!this.isSubtypeOfFragment(elementType) || this.isSubtypeOfSnakeFragment(elementType)) {
            return;
        }
        if (this.isFinalClass(element)) {
            this.error(element, "%s can't be used in a final class, %s", EnableDragToClose.class.getSimpleName(), element.getSimpleName().toString());
            return;
        }
        if (elementType.toString().endsWith("_SnakeProxy")) {
            return;
        }
        TypeElement typeElement = (TypeElement)element;
        String packageName = this.getPackageName(typeElement);
        String simpleName = element.getSimpleName().toString();
        TypeName typeName = TypeName.get((TypeMirror)elementType);
        MethodSpec.Builder bindMethodBuilder = null;
        List<? extends Element> members = this.mElementUtils.getAllMembers(typeElement);
        for (Element element2 : members) {
            if (!(element2 instanceof ExecutableElement) || !this.isOnCreateView((ExecutableElement)element2)) continue;
            ExecutableElement executableElement = (ExecutableElement)element2;
            bindMethodBuilder = MethodSpec.overriding((ExecutableElement)executableElement);
            List<? extends VariableElement> parameters = executableElement.getParameters();
            if (null == parameters || parameters.isEmpty()) break;
            String callSuper = "View view = super.onCreateView(%s, %s, %s)";
            for (VariableElement variableElement : parameters) {
                String variableTypeName = variableElement.getSimpleName().toString();
                callSuper = callSuper.replaceFirst("%s", variableTypeName);
            }
            bindMethodBuilder.addStatement(callSuper, new Object[0]).addCode("\n", new Object[0]);
            break;
        }
        if (null != bindMethodBuilder && null != this.mFiler) {
            ClassName snakeHackLayoutClass = ClassName.get((String)"com.youngfeng.snake.view", (String)"SnakeHackLayout", (String[])new String[0]);
            TypeElement typeElement2 = this.mElementUtils.getTypeElement(snakeHackLayoutClass.toString());
            ClassName snakeClass = ClassName.get((String)"com.youngfeng.snake", (String)"Snake", (String[])new String[0]);
            TypeElement snakeTypeElement = this.mElementUtils.getTypeElement(snakeClass.toString());
            MethodSpec method = bindMethodBuilder.addStatement("$T enableDragToClose = getClass().getAnnotation($T.class)", new Object[]{EnableDragToClose.class, EnableDragToClose.class}).addStatement("if(null != enableDragToClose && !enableDragToClose.value()) return view", new Object[0]).addCode("\n", new Object[0]).addStatement("mSnakeLayout = $T.getLayout(getActivity(), view, true)", new Object[]{typeElement2.asType()}).addStatement("$T.openDragToCloseForFragment(mSnakeLayout, this)", new Object[]{snakeTypeElement.asType()}).addCode("\n", new Object[0]).addStatement("return mSnakeLayout", new Object[0]).build();
            FieldSpec field = FieldSpec.builder((TypeName)TypeName.get((TypeMirror)typeElement2.asType()), (String)"mSnakeLayout", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
            FieldSpec fieldSpec = FieldSpec.builder((TypeName)TypeName.get(Boolean.class).unbox(), (String)"mDisableAnimation", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
            ClassName snakeAnimationController = ClassName.get((String)"com.youngfeng.snake.animation", (String)"SnakeAnimationController", (String[])new String[0]);
            TypeMirror snakeAnimationControllerType = this.mElementUtils.getTypeElement(snakeAnimationController.toString()).asType();
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss", Locale.CHINA);
            String dateStr = dateFormat.format(new Date());
            TypeSpec typeSpec = TypeSpec.classBuilder((String)(simpleName + "_SnakeProxy")).addJavadoc("Use this class to implement drag to close current fragment\n", new Object[0]).addJavadoc("\n", new Object[0]).addJavadoc("@author Snake $L\n", new Object[]{dateStr}).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(typeName).addSuperinterface(TypeName.get((TypeMirror)snakeAnimationControllerType)).addMethod(method).addMethod(this.buildMethodEnableDragToClose()).addMethod(this.buildMethodAddOnDragListener()).addMethod(this.buildMethodSetCustomTouchInterceptor()).addMethod(this.buildMethodEnableSwipeUpToHome()).addMethod(this.buildMethodOnCreateAnimation()).addMethod(this.buildMethodOnCreateAnimator()).addMethod(this.buildMethodDisableAnimation()).addMethod(this.buildMethodAnimationDisabled()).addField(field).addField(fieldSpec).build();
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).addFileComment("Generated code from Snake. Do not edit!", new Object[0]).build();
            try {
                javaFile.writeTo(this.mFiler);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private MethodSpec buildMethodOnCreateAnimation() {
        ParameterSpec p1 = ParameterSpec.builder((TypeName)TypeName.get(Integer.class).unbox(), (String)"transit", (Modifier[])new Modifier[0]).build();
        ParameterSpec p2 = ParameterSpec.builder((TypeName)TypeName.get(Boolean.class).unbox(), (String)"enter", (Modifier[])new Modifier[0]).build();
        ParameterSpec p3 = ParameterSpec.builder((TypeName)TypeName.get(Integer.class).unbox(), (String)"nextAnim", (Modifier[])new Modifier[0]).build();
        ClassName snakeClass = ClassName.get((String)"com.youngfeng.snake", (String)"Snake", (String[])new String[0]);
        TypeElement snakeTypeElement = this.mElementUtils.getTypeElement(snakeClass.toString());
        ClassName animationClass = ClassName.get((String)"android.view.animation", (String)"Animation", (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"onCreateAnimation").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(p1).addParameter(p2).addParameter(p3).addAnnotation(Override.class).addStatement("return $T.wrap(super.onCreateAnimation(transit, enter, nextAnim), this)", new Object[]{snakeTypeElement.asType()}).returns((TypeName)animationClass).build();
    }

    private MethodSpec buildMethodOnCreateAnimator() {
        ParameterSpec p1 = ParameterSpec.builder((TypeName)TypeName.get(Integer.class).unbox(), (String)"transit", (Modifier[])new Modifier[0]).build();
        ParameterSpec p2 = ParameterSpec.builder((TypeName)TypeName.get(Boolean.class).unbox(), (String)"enter", (Modifier[])new Modifier[0]).build();
        ParameterSpec p3 = ParameterSpec.builder((TypeName)TypeName.get(Integer.class).unbox(), (String)"nextAnim", (Modifier[])new Modifier[0]).build();
        ClassName snakeClass = ClassName.get((String)"com.youngfeng.snake", (String)"Snake", (String[])new String[0]);
        TypeElement snakeTypeElement = this.mElementUtils.getTypeElement(snakeClass.toString());
        ClassName animationClass = ClassName.get((String)"android.animation", (String)"Animator", (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"onCreateAnimator").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(p1).addParameter(p2).addParameter(p3).addAnnotation(Override.class).addStatement("return $T.wrap(super.onCreateAnimator(transit, enter, nextAnim), this)", new Object[]{snakeTypeElement.asType()}).returns((TypeName)animationClass).build();
    }

    private MethodSpec buildMethodDisableAnimation() {
        ParameterSpec p = ParameterSpec.builder((TypeName)TypeName.get(Boolean.class).unbox(), (String)"disable", (Modifier[])new Modifier[0]).build();
        return MethodSpec.methodBuilder((String)"disableAnimation").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(p).addAnnotation(Override.class).addStatement("mDisableAnimation = disable", new Object[0]).returns(TypeName.VOID).build();
    }

    private MethodSpec buildMethodAnimationDisabled() {
        return MethodSpec.methodBuilder((String)"animationDisabled").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return mDisableAnimation", new Object[0]).returns(TypeName.get(Boolean.class).unbox()).build();
    }

    private MethodSpec buildMethodEnableDragToClose() {
        ParameterSpec parameter = ParameterSpec.builder(Boolean.class, (String)"enable", (Modifier[])new Modifier[0]).build();
        ClassName snakeConfigExceptionClass = ClassName.get((String)"com.youngfeng.snake.config", (String)"SnakeConfigException", (String[])new String[0]);
        TypeElement snakeConfigExceptionTypeElement = this.mElementUtils.getTypeElement(snakeConfigExceptionClass.toString());
        return MethodSpec.methodBuilder((String)"enableDragToClose").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameter).addStatement("$T enableDragToClose = getClass().getAnnotation($T.class)", new Object[]{EnableDragToClose.class, EnableDragToClose.class}).addCode("if(enable) {\n", new Object[0]).addCode("\tif(null == enableDragToClose || !enableDragToClose.value()) {\n", new Object[0]).addStatement("\t\tthrow new $T($S + getClass().getName() + $S)", new Object[]{snakeConfigExceptionTypeElement.asType(), "If you want to dynamically turn the slide-off feature on\n or off, add the EnableDragToClose annotation to ", " and set to true"}).addCode("\t}\n", new Object[0]).addCode("}\n\n", new Object[0]).addCode("if(null != mSnakeLayout) { \n", new Object[0]).addCode("\tmSnakeLayout.ignoreDragEvent(!enable);\n", new Object[0]).addCode("}\n", new Object[0]).returns(TypeName.VOID).build();
    }

    private MethodSpec buildMethodAddOnDragListener() {
        ClassName onDragListenerClassName = ClassName.get((String)"com.youngfeng.snake", (String)"Snake.OnDragListener", (String[])new String[0]);
        TypeElement onDragListenerTypeElement = this.mElementUtils.getTypeElement(onDragListenerClassName.toString());
        ParameterSpec parameter = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)onDragListenerTypeElement.asType()), (String)"onDragListener", (Modifier[])new Modifier[0]).build();
        return MethodSpec.methodBuilder((String)"addOnDragListener").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameter).returns(TypeName.VOID).addCode("if(null != mSnakeLayout && null != onDragListener) {\n", new Object[0]).addStatement("\tmSnakeLayout.addOnDragListener(onDragListener)", new Object[0]).addCode("}\n", new Object[0]).build();
    }

    private MethodSpec buildMethodSetCustomTouchInterceptor() {
        ClassName onDragListenerClassName = ClassName.get((String)"com.youngfeng.snake.view", (String)"SnakeTouchInterceptor", (String[])new String[0]);
        TypeElement onDragListenerTypeElement = this.mElementUtils.getTypeElement(onDragListenerClassName.toString());
        ParameterSpec parameter = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)onDragListenerTypeElement.asType()), (String)"interceptor", (Modifier[])new Modifier[0]).build();
        return MethodSpec.methodBuilder((String)"setCustomTouchInterceptor").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameter).returns(TypeName.VOID).addCode("if(null != mSnakeLayout && null != interceptor) {\n", new Object[0]).addStatement("\tmSnakeLayout.setCustomTouchInterceptor(interceptor)", new Object[0]).addCode("}\n", new Object[0]).build();
    }

    private MethodSpec buildMethodEnableSwipeUpToHome() {
        ParameterSpec parameter = ParameterSpec.builder(Boolean.class, (String)"enable", (Modifier[])new Modifier[0]).build();
        return MethodSpec.methodBuilder((String)"enableSwipeUpToHome").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameter).addCode("if(null != mSnakeLayout) { \n", new Object[0]).addCode("\tmSnakeLayout.enableSwipeUpToHome(enable);\n", new Object[0]).addCode("}\n", new Object[0]).returns(TypeName.VOID).build();
    }

    private boolean isOnCreateView(ExecutableElement element) {
        if (!"onCreateView".equals(element.getSimpleName().toString())) {
            return false;
        }
        List<? extends VariableElement> parameters = element.getParameters();
        if (null == parameters || parameters.size() != 3) {
            return false;
        }
        for (VariableElement variableElement : parameters) {
            if (SnakeProcessor.isTypeEqual(variableElement.asType(), LAYOUT_INFLATER_TYPE) || SnakeProcessor.isTypeEqual(variableElement.asType(), VIEWGROUP_TYPE) || SnakeProcessor.isTypeEqual(variableElement.asType(), BUNDLE_TYPE)) continue;
            return false;
        }
        return true;
    }

    private boolean isSubtypeOfFragment(TypeMirror typeMirror) {
        return this.isSubtypeOfType(typeMirror, FRAGMENT_TYPE) || this.isSubtypeOfType(typeMirror, SUPPORT_FRAGMENT_TYPE);
    }

    private boolean isSubtypeOfSnakeFragment(TypeMirror typeMirror) {
        return this.isSubtypeOfType(typeMirror, SNAKE_FRAGMENT_TYPE) || this.isSubtypeOfType(typeMirror, SUPPORT_SNAKE_FRAGMENT_TYPE);
    }

    private boolean isFinalClass(Element element) {
        Set<Modifier> modifiers = element.getModifiers();
        if (null == modifiers || modifiers.isEmpty()) {
            return false;
        }
        for (Modifier modifier : modifiers) {
            if (Modifier.FINAL != modifier) continue;
            return true;
        }
        return false;
    }

    private String getPackageName(TypeElement typeElement) {
        return this.mElementUtils.getPackageOf(typeElement).getQualifiedName().toString();
    }

    private boolean isBindingInWrongClass(Element element, Class<? extends Annotation> annotationClass) {
        boolean hasError = false;
        TypeMirror elementType = element.asType();
        if (!(this.isSubtypeOfType(elementType, FRAGMENT_TYPE) || this.isSubtypeOfType(elementType, SUPPORT_FRAGMENT_TYPE) || this.isSubtypeOfType(elementType, ACTIVITY_TYPE))) {
            this.error(element, "%s only can be used in %s or %s or their child class ", EnableDragToClose.class.getName(), "Activity", "Fragment");
            hasError = true;
        }
        return hasError;
    }

    private boolean isSubtypeOfType(TypeMirror typeMirror, String otherType) {
        Element element;
        if (SnakeProcessor.isTypeEqual(typeMirror, otherType)) {
            return true;
        }
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return false;
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.size() > 0) {
            StringBuilder typeString = new StringBuilder(declaredType.asElement().toString());
            typeString.append('<');
            for (int i = 0; i < typeArguments.size(); ++i) {
                if (i > 0) {
                    typeString.append(',');
                }
                typeString.append('?');
            }
            typeString.append('>');
            if (typeString.toString().equals(otherType)) {
                return true;
            }
        }
        if (!((element = declaredType.asElement()) instanceof TypeElement)) {
            return false;
        }
        TypeElement typeElement = (TypeElement)element;
        TypeMirror superType = typeElement.getSuperclass();
        if (this.isSubtypeOfType(superType, otherType)) {
            return true;
        }
        for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
            if (!this.isSubtypeOfType(typeMirror2, otherType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTypeEqual(TypeMirror typeMirror, String otherType) {
        return otherType.equals(typeMirror.toString());
    }

    private Set<Class<? extends Annotation>> getSupportAnnotations() {
        LinkedHashSet<Class<? extends Annotation>> annotations = new LinkedHashSet<Class<? extends Annotation>>();
        annotations.add(EnableDragToClose.class);
        return annotations;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        for (Class<? extends Annotation> annotation : this.getSupportAnnotations()) {
            types.add(annotation.getCanonicalName());
        }
        return types;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return super.getSupportedOptions();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void error(Element element, String message, Object ... args) {
        this.printMessage(Diagnostic.Kind.ERROR, element, message, args);
    }

    private void note(Element element, String message, Object ... args) {
        this.printMessage(Diagnostic.Kind.NOTE, element, message, args);
    }

    private void printMessage(Diagnostic.Kind kind, Element element, String message, Object[] args) {
        if (args.length > 0) {
            message = String.format(message, args);
        }
        this.processingEnv.getMessager().printMessage(kind, message, element);
    }
}

