/*
 * Decompiled with CFR 0.152.
 */
package com.youngfeng.snake.util;

import android.app.Activity;
import android.app.Fragment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.NonNull;

public class SoftKeyboardHelper {
    private static final int MESSAGE_WHAT_HIDE_KEYBOARD = 1;
    private static Handler mMainHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 1: {
                    if (msg.obj instanceof Fragment) {
                        SoftKeyboardHelper.hideKeyboard((Fragment)msg.obj);
                    }
                    if (!(msg.obj instanceof Activity)) break;
                    SoftKeyboardHelper.hideKeyboard((Activity)msg.obj);
                }
            }
        }
    };

    public static boolean hideKeyboard(@NonNull Fragment fragment) {
        View focusedChild;
        if (fragment.isDetached() || fragment.isRemoving() || null == fragment.getActivity()) {
            return true;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)fragment.getActivity().getSystemService("input_method");
        View rootView = fragment.getView();
        if (rootView instanceof ViewGroup && null != (focusedChild = ((ViewGroup)rootView).getFocusedChild())) {
            return inputMethodManager.hideSoftInputFromWindow(focusedChild.getWindowToken(), 0);
        }
        return true;
    }

    public static boolean hideKeyboard(@NonNull androidx.fragment.app.Fragment fragment) {
        View focusedChild;
        if (fragment.isDetached() || fragment.isRemoving() || null == fragment.getActivity()) {
            return true;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)fragment.getActivity().getSystemService("input_method");
        View rootView = fragment.getView();
        if (rootView instanceof ViewGroup && null != (focusedChild = ((ViewGroup)rootView).getFocusedChild())) {
            return inputMethodManager.hideSoftInputFromWindow(focusedChild.getWindowToken(), 0);
        }
        return true;
    }

    public static void hideKeyboardDelayed(@NonNull Fragment fragment, int delayMillis) {
        Message message = mMainHandler.obtainMessage(1, (Object)fragment);
        mMainHandler.sendMessageDelayed(message, (long)delayMillis);
    }

    public static boolean hideKeyboard(@NonNull Activity activity) {
        InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
        View focusedChild = activity.getCurrentFocus();
        if (null != focusedChild) {
            return inputMethodManager.hideSoftInputFromWindow(focusedChild.getWindowToken(), 0);
        }
        return true;
    }

    public static void hideKeyboardDelayed(@NonNull Activity activity, int delayMillis) {
        Message message = mMainHandler.obtainMessage(1, (Object)activity);
        mMainHandler.sendMessageDelayed(message, (long)delayMillis);
    }
}

