/*
 * Decompiled with CFR 0.152.
 */
package com.youngfeng.snake.util;

import android.app.Fragment;
import android.app.FragmentManager;
import android.view.View;
import androidx.fragment.app.FragmentManager;

public class FragmentManagerHelper {
    private android.app.FragmentManager mFragmentManager;
    private FragmentManager mAndroidXFragmentManager;

    private FragmentManagerHelper(android.app.FragmentManager fragmentManager) {
        this.mFragmentManager = fragmentManager;
    }

    private FragmentManagerHelper(FragmentManager fragmentManager) {
        this.mAndroidXFragmentManager = fragmentManager;
    }

    public static FragmentManagerHelper get(android.app.FragmentManager fragmentManager) {
        return new FragmentManagerHelper(fragmentManager);
    }

    public static FragmentManagerHelper get(FragmentManager fragmentManager) {
        return new FragmentManagerHelper(fragmentManager);
    }

    public Fragment getLastFragment() {
        int backStackCount = this.mFragmentManager.getBackStackEntryCount();
        if (backStackCount <= 0) {
            return null;
        }
        FragmentManager.BackStackEntry backStackEntry = this.mFragmentManager.getBackStackEntryAt(backStackCount - 1);
        String fragmentTag = backStackEntry.getName();
        return this.mFragmentManager.findFragmentByTag(fragmentTag);
    }

    public androidx.fragment.app.Fragment getLastAndroidXFragment(FragmentManager fragmentManager) {
        if (null == fragmentManager) {
            return null;
        }
        int backStackCount = fragmentManager.getBackStackEntryCount();
        if (backStackCount <= 0) {
            return null;
        }
        FragmentManager.BackStackEntry backStackEntry = fragmentManager.getBackStackEntryAt(backStackCount - 1);
        String fragmentTag = backStackEntry.getName();
        return fragmentManager.findFragmentByTag(fragmentTag);
    }

    public androidx.fragment.app.Fragment getLastAndroidXFragment(androidx.fragment.app.Fragment fragment) {
        FragmentManager fragmentManager = this.mAndroidXFragmentManager;
        return this.getLastAndroidXFragment(fragmentManager);
    }

    public View getViewOfLastFragment() {
        if (null == this.getLastFragment()) {
            return null;
        }
        return this.getLastFragment().getView();
    }

    public View getViewOfLastAndroidXFragment(androidx.fragment.app.Fragment fragment) {
        if (null == this.getLastAndroidXFragment(fragment)) {
            return null;
        }
        return this.getLastAndroidXFragment(fragment).getView();
    }

    public boolean backToLastFragment() {
        return this.mFragmentManager.popBackStackImmediate();
    }

    public boolean backToAndroidXFragment() {
        return this.mAndroidXFragmentManager.popBackStackImmediate();
    }

    public boolean backStackEmpty() {
        return this.mFragmentManager.getBackStackEntryCount() <= 0;
    }

    public boolean androidXBackStackEmpty() {
        return this.mAndroidXFragmentManager.getBackStackEntryCount() <= 0;
    }
}

