/*
 * Decompiled with CFR 0.152.
 */
package com.youngfeng.snake.util;

import android.app.Activity;
import android.app.ActivityOptions;
import android.content.res.TypedArray;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.youngfeng.snake.util.ConversionInvocationHandler;
import com.youngfeng.snake.util.Logger;
import com.youngfeng.snake.util.TranslucentConversionListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ActivityHelper {
    public static void convertFromTranslucent(Activity activity) {
        try {
            Method method = Activity.class.getDeclaredMethod("convertFromTranslucent", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)activity, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void convertToTranslucent(@NonNull Activity activity, TranslucentConversionListener listener) {
        if (activity.isFinishing()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            ActivityHelper.convertToTranslucentAfterLollipop(activity, listener);
        } else if (null != listener) {
            listener.onTranslucentConversionComplete(true);
        }
    }

    public static void convertToTranslucent(@NonNull Activity activity) {
        ActivityHelper.convertToTranslucent(activity, null);
    }

    @RequiresApi(api=16)
    private static void convertToTranslucentAfterLollipop(@NonNull Activity activity, TranslucentConversionListener conversionListener) {
        try {
            Method getActivityOptions = Activity.class.getDeclaredMethod("getActivityOptions", new Class[0]);
            getActivityOptions.setAccessible(true);
            Object options = getActivityOptions.invoke((Object)activity, new Object[0]);
            Class<?>[] classes = Activity.class.getDeclaredClasses();
            Class<?> translucentConversionListenerClazz = null;
            for (Class<?> clazz : classes) {
                if (!clazz.getSimpleName().contains("TranslucentConversionListener")) continue;
                translucentConversionListenerClazz = clazz;
                break;
            }
            ConversionInvocationHandler invocationHandler = new ConversionInvocationHandler(new WeakReference<TranslucentConversionListener>(conversionListener));
            Object newProxy = Proxy.newProxyInstance(Activity.class.getClassLoader(), new Class[]{translucentConversionListenerClazz}, (InvocationHandler)invocationHandler);
            Method convertToTranslucent = Activity.class.getDeclaredMethod("convertToTranslucent", translucentConversionListenerClazz, ActivityOptions.class);
            convertToTranslucent.setAccessible(true);
            long start = System.currentTimeMillis();
            convertToTranslucent.invoke((Object)activity, newProxy, options);
            long end = System.currentTimeMillis();
            Logger.d("convertToTranslucentAfterLollipop, time = " + (end - start));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static int getWindowBackgroundResourceId(@NonNull Activity activity) {
        TypedArray a = activity.getTheme().obtainStyledAttributes(new int[]{16842836});
        int backgroundResourceId = a.getResourceId(0, 0);
        a.recycle();
        return backgroundResourceId;
    }

    public static boolean isTranslucent(@NonNull Activity activity) {
        try {
            TypedArray a = activity.getTheme().obtainStyledAttributes(new int[]{16842840});
            boolean isTranslucent = a.getBoolean(0, false);
            a.recycle();
            return isTranslucent;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

