/*
 * Decompiled with CFR 0.152.
 */
package com.youngfeng.snake.androidx.app;

import android.animation.Animator;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import androidx.annotation.Nullable;
import com.youngfeng.snake.Snake;
import com.youngfeng.snake.animation.SnakeAnimationController;
import com.youngfeng.snake.annotations.EnableDragToClose;
import com.youngfeng.snake.config.SnakeConfigException;
import com.youngfeng.snake.util.FragmentManagerHelper;
import com.youngfeng.snake.view.SnakeHackLayout;
import com.youngfeng.snake.view.SnakeTouchInterceptor;
import java.lang.reflect.Field;

public class Fragment
extends androidx.fragment.app.Fragment
implements SnakeAnimationController {
    private SnakeHackLayout mSnakeLayout;
    private boolean mDisableAnimation;

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        this.replaceWithSnakeLayout(view);
    }

    private void replaceWithSnakeLayout(View view) {
        FragmentManagerHelper fragmentManagerHelper = FragmentManagerHelper.get(this.requireActivity().getSupportFragmentManager());
        if (null == view || fragmentManagerHelper.androidXBackStackEmpty()) {
            return;
        }
        EnableDragToClose enableDragToClose = this.getClass().getAnnotation(EnableDragToClose.class);
        if (null != enableDragToClose && !enableDragToClose.value()) {
            return;
        }
        this.mSnakeLayout = SnakeHackLayout.getLayout((Context)this.getActivity());
        if (view.getParent() instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view.getParent();
            parent.removeView(view);
            this.mSnakeLayout.addView(view);
            parent.addView((View)this.mSnakeLayout);
        }
        try {
            Field mView = androidx.fragment.app.Fragment.class.getDeclaredField("mView");
            mView.setAccessible(true);
            mView.set(this, (Object)this.mSnakeLayout);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Snake.openDragToCloseForFragment(this.mSnakeLayout, this);
    }

    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        return Snake.wrap(super.onCreateAnimation(transit, enter, nextAnim), (SnakeAnimationController)this);
    }

    public Animator onCreateAnimator(int transit, boolean enter, int nextAnim) {
        return Snake.wrap(super.onCreateAnimator(transit, enter, nextAnim), (SnakeAnimationController)this);
    }

    public void enableDragToClose(Boolean enable) {
        EnableDragToClose enableDragToClose = this.getClass().getAnnotation(EnableDragToClose.class);
        if (enable.booleanValue() && (null == enableDragToClose || !enableDragToClose.value())) {
            throw new SnakeConfigException("If you want to dynamically turn the slide-off feature on or off, add the EnableDragToClose annotation to " + this.getClass().getName() + " and set to true");
        }
        if (null != this.mSnakeLayout) {
            this.mSnakeLayout.ignoreDragEvent(enable == false);
        }
    }

    public void addOnDragListener(Snake.OnDragListener onDragListener) {
        if (null != this.mSnakeLayout && null != onDragListener) {
            this.mSnakeLayout.addOnDragListener(onDragListener);
        }
    }

    public void setCustomTouchInterceptor(SnakeTouchInterceptor interceptor) {
        if (null != this.mSnakeLayout && null != interceptor) {
            this.mSnakeLayout.setCustomTouchInterceptor(interceptor);
        }
    }

    public void enableSwipeUpToHome(Boolean enable) {
        if (null != this.mSnakeLayout) {
            this.mSnakeLayout.enableSwipeUpToHome(enable);
        }
    }

    @Override
    public void disableAnimation(boolean disable) {
        this.mDisableAnimation = disable;
    }

    @Override
    public boolean animationDisabled() {
        return this.mDisableAnimation;
    }
}

