/*
 * Decompiled with CFR 0.152.
 */
package com.youngfeng.snake;

import android.animation.Animator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.youngfeng.snake.androidx.app.Fragment;
import com.youngfeng.snake.animation.AnimationFactory;
import com.youngfeng.snake.animation.SnakeAnimationController;
import com.youngfeng.snake.annotations.EnableDragToClose;
import com.youngfeng.snake.annotations.PrimaryConstructor;
import com.youngfeng.snake.annotations.SetDragParameter;
import com.youngfeng.snake.config.SnakeConfigException;
import com.youngfeng.snake.config.SnakeConfigReader;
import com.youngfeng.snake.util.ActivityDragInterceptor;
import com.youngfeng.snake.util.ActivityManager;
import com.youngfeng.snake.util.FragmentManagerHelper;
import com.youngfeng.snake.util.GlobalActivityLifecycleDelegate;
import com.youngfeng.snake.util.Logger;
import com.youngfeng.snake.util.SoftKeyboardHelper;
import com.youngfeng.snake.util.Utils;
import com.youngfeng.snake.view.SnakeHackLayout;
import com.youngfeng.snake.view.SnakeTouchInterceptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class Snake {
    private static Application mContext;

    public static void init(Application application) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new GlobalActivityLifecycleDelegate(){

            @Override
            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                ActivityManager.get().put(activity);
                Snake.openDragToCloseForActivity(activity);
                Logger.d(activity.getClass() + " onCreate completed...");
            }

            @Override
            public void onActivityDestroyed(Activity activity) {
                ActivityManager.get().remove(activity);
                Logger.d(activity.getClass() + " destoryed completed...");
            }
        });
        SnakeConfigReader.get().init(application);
        mContext = application;
    }

    public static <T extends android.app.Fragment> T newProxy(Class<? extends T> fragment, Object ... args) {
        Snake.checkAnnotationNotEmpty(fragment);
        try {
            String className = fragment.getName() + "_SnakeProxy";
            if (com.youngfeng.snake.app.Fragment.class.isAssignableFrom(fragment)) {
                className = fragment.getName();
            }
            Class<?> snakeProxyClass = Class.forName(className);
            Constructor<?>[] constructors = snakeProxyClass.getConstructors();
            Constructor<?> primaryConstructor = null;
            for (Constructor<?> constructor : constructors) {
                PrimaryConstructor primaryConstructorAnno = constructor.getAnnotation(PrimaryConstructor.class);
                if (null == primaryConstructorAnno) continue;
                primaryConstructor = constructor;
                break;
            }
            android.app.Fragment result = null;
            result = null != primaryConstructor ? (android.app.Fragment)primaryConstructor.newInstance(args) : (android.app.Fragment)snakeProxyClass.newInstance();
            return (T)result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends androidx.fragment.app.Fragment> T newProxySupport(Class<? extends T> fragment, Object ... args) {
        Snake.checkAnnotationNotEmpty(fragment);
        try {
            String className = fragment.getName() + "_SnakeProxy";
            if (Fragment.class.isAssignableFrom(fragment)) {
                className = fragment.getName();
            }
            Class<?> snakeProxyClass = Class.forName(className);
            Constructor<?>[] constructors = snakeProxyClass.getConstructors();
            Constructor<?> primaryConstructor = null;
            for (Constructor<?> constructor : constructors) {
                PrimaryConstructor primaryConstructorAnno = constructor.getAnnotation(PrimaryConstructor.class);
                if (null == primaryConstructorAnno) continue;
                primaryConstructor = constructor;
                break;
            }
            androidx.fragment.app.Fragment result = null;
            result = null != primaryConstructor ? (androidx.fragment.app.Fragment)primaryConstructor.newInstance(args) : (androidx.fragment.app.Fragment)snakeProxyClass.newInstance();
            return (T)result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void checkAnnotationNotEmpty(Class<?> clazz) {
        if (clazz.getAnnotation(EnableDragToClose.class) == null) {
            throw new IllegalStateException(String.format("Please add %s annotation to class %s first,  eg: @%s.", EnableDragToClose.class.getName(), clazz.getName(), EnableDragToClose.class.getSimpleName()));
        }
    }

    public static void openDragToCloseForFragment(@NonNull SnakeHackLayout snakeHackLayout, final @NonNull android.app.Fragment fragment) {
        Snake.assertFragmentActive(fragment);
        Snake.setDragParameter(fragment.getClass().getAnnotation(SetDragParameter.class), snakeHackLayout);
        final FragmentManagerHelper fragmentManagerHelper = FragmentManagerHelper.get(fragment.getFragmentManager());
        snakeHackLayout.setOnEdgeDragListener(new SnakeHackLayout.OnEdgeDragListener(){
            private int mVisibility = -1;

            @Override
            public void onDragStart(SnakeHackLayout parent) {
                SoftKeyboardHelper.hideKeyboard(fragment);
            }

            @Override
            @SuppressLint(value={"WrongConstant"})
            public void onDrag(SnakeHackLayout parent, View view, int left) {
                View viewOfLastFragment = fragmentManagerHelper.getViewOfLastFragment();
                if (null != viewOfLastFragment) {
                    if (0 != viewOfLastFragment.getVisibility()) {
                        this.mVisibility = viewOfLastFragment.getVisibility();
                        viewOfLastFragment.setVisibility(0);
                        viewOfLastFragment.setX(0.0f);
                    }
                    if (parent.getUIConfig().allowPageLinkage) {
                        float ratio = (float)left * 1.0f / (float)parent.getWidth();
                        viewOfLastFragment.setX((ratio - 1.0f) * Utils.dp2px((Context)fragment.getActivity(), 100.0f));
                    }
                }
            }

            @Override
            public void onRelease(SnakeHackLayout parent, View view, int left, boolean shouldClose, int interceptScene) {
                if (shouldClose) {
                    parent.smoothScrollToLeave(view, new SnakeHackLayout.OnReleaseStateListener(){

                        @Override
                        public void onReleaseCompleted(SnakeHackLayout parent, View view) {
                            View viewOfLastFragment = fragmentManagerHelper.getViewOfLastFragment();
                            if (null != viewOfLastFragment) {
                                viewOfLastFragment.setX(0.0f);
                            }
                            android.app.Fragment lastFragment = fragmentManagerHelper.getLastFragment();
                            Snake.disableAnimation(lastFragment, true);
                            if (fragmentManagerHelper.backToLastFragment()) {
                                Snake.disableAnimation(lastFragment, false);
                            } else {
                                Snake.disableAnimation(lastFragment, false);
                            }
                        }
                    });
                } else {
                    parent.smoothScrollToStart(view, new SnakeHackLayout.OnReleaseStateListener(){

                        @Override
                        @SuppressLint(value={"WrongConstant"})
                        public void onReleaseCompleted(SnakeHackLayout parent, View view) {
                            View viewOfLastFragment = fragmentManagerHelper.getViewOfLastFragment();
                            if (null != viewOfLastFragment) {
                                if (mVisibility >= 0) {
                                    viewOfLastFragment.setVisibility(mVisibility);
                                }
                                viewOfLastFragment.setX(0.0f);
                            }
                        }
                    });
                }
            }
        });
    }

    public static void openDragToCloseForFragment(@NonNull SnakeHackLayout snakeHackLayout, final @NonNull androidx.fragment.app.Fragment fragment) {
        Snake.assertFragmentActive(fragment);
        Snake.setDragParameter(fragment.getClass().getAnnotation(SetDragParameter.class), snakeHackLayout);
        final FragmentManagerHelper fragmentManagerHelper = FragmentManagerHelper.get(fragment.getFragmentManager());
        snakeHackLayout.setOnEdgeDragListener(new SnakeHackLayout.OnEdgeDragListener(){
            private androidx.fragment.app.Fragment lastFragment;

            @Override
            public void onDragStart(SnakeHackLayout parent) {
                SoftKeyboardHelper.hideKeyboard(fragment);
            }

            @Override
            public void onDrag(SnakeHackLayout parent, View view, int left) {
                if (null == this.lastFragment) {
                    this.lastFragment = fragmentManagerHelper.getLastAndroidXFragment(fragment);
                }
                if (null == this.lastFragment) {
                    return;
                }
                if (this.lastFragment.isDetached() || this.lastFragment.isRemoving()) {
                    return;
                }
                View viewOfLastFragment = this.lastFragment.getView();
                if (null != viewOfLastFragment) {
                    if (0 != viewOfLastFragment.getVisibility()) {
                        viewOfLastFragment.setVisibility(0);
                    }
                    View contentView = viewOfLastFragment;
                    if (viewOfLastFragment instanceof SnakeHackLayout) {
                        contentView = ((SnakeHackLayout)viewOfLastFragment).getContentView();
                    }
                    if (parent.getUIConfig().allowPageLinkage) {
                        float ratio = (float)left * 1.0f / (float)parent.getWidth();
                        float offsetLeft = (ratio - 1.0f) * Utils.dp2px((Context)fragment.requireActivity(), 100.0f);
                        contentView.setLeft((int)offsetLeft);
                    }
                }
            }

            @Override
            public void onRelease(SnakeHackLayout parent, View view, int left, boolean shouldClose, int interceptScene) {
                if (shouldClose) {
                    Snake.disableAnimation(this.lastFragment, true);
                    parent.smoothScrollToLeave(view, new SnakeHackLayout.OnReleaseStateListener(){

                        @Override
                        public void onReleaseCompleted(SnakeHackLayout parent, View view) {
                            if (null == lastFragment) {
                                lastFragment = fragmentManagerHelper.getLastAndroidXFragment(fragment);
                            }
                            if (null == lastFragment) {
                                return;
                            }
                            View viewOfLastFragment = lastFragment.getView();
                            Snake.resetContentViewForFragment(viewOfLastFragment);
                            fragmentManagerHelper.backToAndroidXFragment();
                            Snake.disableAnimation(lastFragment, false);
                        }
                    });
                } else {
                    parent.smoothScrollToStart(view, new SnakeHackLayout.OnReleaseStateListener(){

                        @Override
                        @SuppressLint(value={"WrongConstant"})
                        public void onReleaseCompleted(SnakeHackLayout parent, View view) {
                            if (null == lastFragment) {
                                lastFragment = fragmentManagerHelper.getLastAndroidXFragment(fragment);
                            }
                            if (null == lastFragment) {
                                return;
                            }
                            View viewOfLastFragment = lastFragment.getView();
                            if (null != viewOfLastFragment) {
                                Snake.resetContentViewForFragment(viewOfLastFragment);
                            }
                        }
                    });
                }
            }
        });
    }

    private static void resetContentViewForFragment(View root) {
        View contentView = root;
        if (root instanceof SnakeHackLayout) {
            contentView = ((SnakeHackLayout)root).getContentView();
        }
        if (null != contentView) {
            contentView.setLeft(0);
            if (root instanceof SnakeHackLayout) {
                ((SnakeHackLayout)root).resetUI();
            }
        }
    }

    private static void assertFragmentActive(android.app.Fragment fragment) {
        if (fragment.isDetached() || fragment.isRemoving()) {
            throw new IllegalStateException("You can't add this feature to a detached or removing fragment");
        }
    }

    private static void assertFragmentActive(androidx.fragment.app.Fragment fragment) {
        if (fragment.isDetached() || fragment.isRemoving()) {
            throw new IllegalStateException("You can't add this feature to a detached or removing fragment");
        }
    }

    private static void setDragParameter(@Nullable SetDragParameter dragParameter, SnakeHackLayout snakeHackLayout) {
        if (null != dragParameter) {
            snakeHackLayout.hideShadowOfEdge(dragParameter.hideShadowOfEdge());
            snakeHackLayout.setMinVelocity(dragParameter.minVelocity());
            snakeHackLayout.setOnlyListenToFastSwipe(dragParameter.onlyListenToFastSwipe());
            snakeHackLayout.enableSwipeUpToHome(dragParameter.enableSwipeUpToHome());
            snakeHackLayout.setAllowPageLinkageOfUIConfig(dragParameter.allowPageLinkage());
            if (!dragParameter.hideShadowOfEdge()) {
                try {
                    snakeHackLayout.setShadowStartColor(Color.parseColor((String)dragParameter.shadowStartColor()));
                }
                catch (IllegalArgumentException e) {
                    throw new SnakeConfigException(String.format("The shadow start color string of  %s annotation is set error, eg: #ff0000, current value: %s", SetDragParameter.class.getSimpleName(), dragParameter.shadowStartColor()));
                }
                try {
                    snakeHackLayout.setShadowEndColor(Color.parseColor((String)dragParameter.shadowEndColor()));
                }
                catch (IllegalArgumentException e) {
                    throw new SnakeConfigException(String.format("The shadow end color string of  %s annotation is set error, eg: #ff0000, current value: %s", SetDragParameter.class.getSimpleName(), dragParameter.shadowEndColor()));
                }
            }
        } else {
            snakeHackLayout.hideShadowOfEdge(SnakeConfigReader.get().hideShadowOfEdge());
            snakeHackLayout.setMinVelocity(SnakeConfigReader.get().minVelocity());
            snakeHackLayout.setOnlyListenToFastSwipe(SnakeConfigReader.get().onlyListenToFastSwipe());
            snakeHackLayout.setShadowStartColor(SnakeConfigReader.get().shadowStartColor());
            snakeHackLayout.setShadowEndColor(SnakeConfigReader.get().shadowEndColor());
            snakeHackLayout.enableSwipeUpToHome(SnakeConfigReader.get().swipeUpToHomeEnabled());
            snakeHackLayout.setAllowPageLinkageOfUIConfig(SnakeConfigReader.get().allowPageLinkage());
        }
    }

    private static void openDragToCloseForActivity(@NonNull Activity activity) {
        Snake.assertActivityDestroyed(activity);
        EnableDragToClose enableDragToClose = activity.getClass().getAnnotation(EnableDragToClose.class);
        if (null == enableDragToClose || !enableDragToClose.value()) {
            return;
        }
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        View topWindowView = decorView.getChildAt(0);
        if (topWindowView instanceof SnakeHackLayout) {
            return;
        }
        activity.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        activity.getWindow().getDecorView().setBackgroundDrawable(null);
        TypedArray a = activity.getTheme().obtainStyledAttributes(new int[]{16842836});
        int background = a.getResourceId(0, 0);
        a.recycle();
        topWindowView.setBackgroundResource(background);
        decorView.removeView(topWindowView);
        SnakeHackLayout snakeHackLayout = SnakeHackLayout.getLayout((Context)activity, topWindowView, true);
        decorView.addView((View)snakeHackLayout);
        SetDragParameter dragParameter = activity.getClass().getAnnotation(SetDragParameter.class);
        Snake.setDragParameter(dragParameter, snakeHackLayout);
        if (Build.VERSION.SDK_INT < 21) {
            snakeHackLayout.setOnlyListenToFastSwipe(true);
        }
        ActivityDragInterceptor.get(activity).attachToLayout(snakeHackLayout);
    }

    private static void assertActivityDestroyed(Activity activity) {
        if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
            throw new IllegalStateException("You cannot add this feature to a destroyed activity");
        }
    }

    public static void enableDragToClose(@NonNull Activity activity, boolean enable) {
        if (activity.isFinishing()) {
            return;
        }
        EnableDragToClose enableDragToClose = activity.getClass().getAnnotation(EnableDragToClose.class);
        if (null == enableDragToClose) {
            throw new SnakeConfigException("If you want to dynamically turn the slide-off feature on or off, add the EnableDragToClose annotation to " + activity.getClass().getName() + " and set to true");
        }
        boolean isEnabled = Snake.dragToCloseEnabled(activity);
        if (enable == isEnabled) {
            return;
        }
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        View topWindowView = decorView.getChildAt(0);
        if (!(topWindowView instanceof SnakeHackLayout)) {
            throw new SnakeConfigException("Did you enable the keep activities option in the settings? if not, commit issue please");
        }
        ((SnakeHackLayout)topWindowView).ignoreDragEvent(!enable);
    }

    public static void enableDragToClose(@NonNull android.app.Fragment fragment, boolean enable) {
        if (fragment instanceof com.youngfeng.snake.app.Fragment) {
            ((com.youngfeng.snake.app.Fragment)fragment).enableDragToClose(enable);
        } else {
            try {
                Method method = fragment.getClass().getMethod("enableDragToClose", Boolean.class);
                method.invoke((Object)fragment, enable);
            }
            catch (Throwable e) {
                if (e instanceof NoSuchMethodException) {
                    throw new SnakeConfigException("Plase use Snake.newProxy create a Fragment instance");
                }
                e.printStackTrace();
            }
        }
    }

    public static void enableDragToClose(@NonNull androidx.fragment.app.Fragment fragment, boolean enable) {
        if (fragment instanceof Fragment) {
            ((Fragment)fragment).enableDragToClose(enable);
        } else {
            try {
                Method method = fragment.getClass().getMethod("enableDragToClose", Boolean.class);
                method.invoke((Object)fragment, enable);
            }
            catch (Throwable e) {
                if (e instanceof NoSuchMethodException) {
                    throw new SnakeConfigException("Plase use Snake.newProxySupport create a Fragment instance");
                }
                e.printStackTrace();
            }
        }
    }

    public static void addDragListener(@NonNull Activity activity, OnDragListener onDragListener) {
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        if (!(decorView.getChildAt(0) instanceof SnakeHackLayout) || null == onDragListener) {
            return;
        }
        ((SnakeHackLayout)decorView.getChildAt(0)).addOnDragListener(onDragListener);
    }

    public static void addDragListener(@NonNull android.app.Fragment fragment, OnDragListener onDragListener) {
        if (fragment instanceof com.youngfeng.snake.app.Fragment) {
            ((com.youngfeng.snake.app.Fragment)fragment).addOnDragListener(onDragListener);
        } else {
            try {
                Method method = fragment.getClass().getMethod("addOnDragListener", OnDragListener.class);
                method.invoke((Object)fragment, onDragListener);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void addDragListener(@NonNull androidx.fragment.app.Fragment fragment, OnDragListener onDragListener) {
        if (fragment instanceof Fragment) {
            ((Fragment)fragment).addOnDragListener(onDragListener);
        } else {
            try {
                Method method = fragment.getClass().getMethod("addOnDragListener", OnDragListener.class);
                method.invoke((Object)fragment, onDragListener);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void setCustomTouchInterceptor(@NonNull Activity activity, SnakeTouchInterceptor interceptor) {
        if (activity.isFinishing() || null == interceptor) {
            return;
        }
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        if (!(decorView.getChildAt(0) instanceof SnakeHackLayout)) {
            return;
        }
        SnakeHackLayout snakeHackLayout = (SnakeHackLayout)decorView.getChildAt(0);
        snakeHackLayout.setCustomTouchInterceptor(interceptor);
    }

    public static void setCustomTouchInterceptor(@NonNull android.app.Fragment fragment, SnakeTouchInterceptor interceptor) {
        if (fragment instanceof com.youngfeng.snake.app.Fragment) {
            ((com.youngfeng.snake.app.Fragment)fragment).setCustomTouchInterceptor(interceptor);
        } else {
            try {
                Method method = fragment.getClass().getMethod("setCustomTouchInterceptor", SnakeTouchInterceptor.class);
                method.invoke((Object)fragment, interceptor);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void setCustomTouchInterceptor(@NonNull androidx.fragment.app.Fragment fragment, SnakeTouchInterceptor interceptor) {
        if (fragment instanceof Fragment) {
            ((Fragment)fragment).setCustomTouchInterceptor(interceptor);
        } else {
            try {
                Method method = fragment.getClass().getMethod("setCustomTouchInterceptor", SnakeTouchInterceptor.class);
                method.invoke((Object)fragment, interceptor);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static Animator wrap(@Nullable Animator superAnimator, @NonNull SnakeAnimationController animationController) {
        if (animationController.animationDisabled()) {
            return AnimationFactory.emptyAnimator();
        }
        return superAnimator;
    }

    public static Animation wrap(@Nullable Animation superAnimation, @NonNull SnakeAnimationController animationController) {
        if (animationController.animationDisabled()) {
            return AnimationFactory.emptyAmiation();
        }
        return superAnimation;
    }

    public static void disableAnimation(androidx.fragment.app.Fragment fragment, boolean disable) {
        if (fragment instanceof SnakeAnimationController) {
            ((SnakeAnimationController)fragment).disableAnimation(disable);
        }
    }

    public static void disableAnimation(android.app.Fragment fragment, boolean disable) {
        if (fragment instanceof SnakeAnimationController) {
            ((SnakeAnimationController)fragment).disableAnimation(disable);
        }
    }

    public static boolean dragToCloseEnabled(@NonNull Activity activity) {
        Snake.assertActivityDestroyed(activity);
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        View topWindowView = decorView.getChildAt(0);
        if (topWindowView instanceof SnakeHackLayout) {
            return !((SnakeHackLayout)topWindowView).ignoredDragEvent();
        }
        return false;
    }

    public static boolean dragToCloseEnabled(@NonNull android.app.Fragment fragment) {
        View contentView = fragment.getView();
        if (contentView instanceof SnakeHackLayout) {
            return !((SnakeHackLayout)contentView).ignoredDragEvent();
        }
        return false;
    }

    public static boolean dragToCloseEnabled(@NonNull androidx.fragment.app.Fragment fragment) {
        View contentView = fragment.getView();
        if (contentView instanceof SnakeHackLayout) {
            return !((SnakeHackLayout)contentView).ignoredDragEvent();
        }
        return false;
    }

    public static void enableSwipeUpToHome(@NonNull Activity activity, boolean enable) {
        EnableDragToClose enableDragToClose;
        if (activity.isFinishing()) {
            return;
        }
        if (enable && (null == (enableDragToClose = activity.getClass().getAnnotation(EnableDragToClose.class)) || !enableDragToClose.value())) {
            throw new SnakeConfigException("If you want to dynamically turn the swipe up to home feature on or off, add the EnableDragToClose annotation to " + activity.getClass().getName() + " and set true.");
        }
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        View topWindowView = decorView.getChildAt(0);
        if (!(topWindowView instanceof SnakeHackLayout)) {
            throw new SnakeConfigException("Did you enable the keep activities option in the settings? if not, commit issue please");
        }
        ((SnakeHackLayout)topWindowView).enableSwipeUpToHome(enable);
    }

    @Deprecated
    public static void enableSwipeUpToHome(@NonNull android.app.Fragment fragment, boolean enable) {
        if (fragment instanceof com.youngfeng.snake.app.Fragment) {
            ((com.youngfeng.snake.app.Fragment)fragment).enableSwipeUpToHome(enable);
        } else {
            try {
                Method method = fragment.getClass().getMethod("enableSwipeUpToHome", Boolean.class);
                method.invoke((Object)fragment, enable);
            }
            catch (Throwable e) {
                if (e instanceof NoSuchMethodException) {
                    throw new SnakeConfigException("Please use Snake.newProxy create a Fragment instance");
                }
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public static void enableSwipeUpToHome(@NonNull androidx.fragment.app.Fragment fragment, boolean enable) {
        if (fragment instanceof Fragment) {
            ((Fragment)fragment).enableSwipeUpToHome(enable);
        } else {
            try {
                Method method = fragment.getClass().getMethod("enableSwipeUpToHome", Boolean.class);
                method.invoke((Object)fragment, enable);
            }
            catch (Throwable e) {
                if (e instanceof NoSuchMethodException) {
                    throw new SnakeConfigException("Please use Snake.newProxySupport create a Fragment instance");
                }
                e.printStackTrace();
            }
        }
    }

    public static boolean swipeUpToHomeEnabled(@NonNull Activity activity) {
        Snake.assertActivityDestroyed(activity);
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        View topWindowView = decorView.getChildAt(0);
        if (topWindowView instanceof SnakeHackLayout) {
            return ((SnakeHackLayout)topWindowView).swipeUpToHomeEnabled();
        }
        return false;
    }

    @Deprecated
    public static boolean swipeUpToHomeEnabled(@NonNull android.app.Fragment fragment) {
        View contentView = fragment.getView();
        if (contentView instanceof SnakeHackLayout) {
            return ((SnakeHackLayout)contentView).swipeUpToHomeEnabled();
        }
        return false;
    }

    @Deprecated
    public static boolean swipeUpToHomeEnabled(@NonNull androidx.fragment.app.Fragment fragment) {
        View contentView = fragment.getView();
        if (contentView instanceof SnakeHackLayout) {
            return ((SnakeHackLayout)contentView).swipeUpToHomeEnabled();
        }
        return false;
    }

    public static void setDebug(boolean debug) {
        Logger.debug = debug;
    }

    public static Context getContext() {
        return mContext;
    }

    public static String versionName() {
        return "0.4.1";
    }

    public static int versionCode() {
        return 41;
    }

    public static boolean isSupportedForActivity() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static abstract class OnDragListener {
        public void onDragStart(View view) {
        }

        public void onDrag(View view, int left, boolean isSetlling) {
        }

        public void onRelease(View view, float xVelocity) {
        }

        public void onBackToStartCompleted(View view) {
        }
    }
}

