/*
 * Decompiled with CFR 0.152.
 */
package com.yonghui.zxing.camera;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Point;
import android.hardware.Camera;
import android.preference.PreferenceManager;
import android.view.Display;
import android.view.WindowManager;
import com.yonghui.zxing.camera.CameraConfigurationUtils;
import com.yonghui.zxing.camera.FrontLightMode;
import com.yonghui.zxing.camera.open.CameraFacing;
import com.yonghui.zxing.camera.open.OpenCamera;
import com.yonghui.zxing.util.LogUtils;

final class CameraConfigurationManager {
    private final Context context;
    private int cwNeededRotation;
    private int cwRotationFromDisplayToCamera;
    private Point screenResolution;
    private Point cameraResolution;
    private Point bestPreviewSize;
    private Point previewSizeOnScreen;

    CameraConfigurationManager(Context context) {
        this.context = context;
    }

    void initFromCameraParameters(OpenCamera camera) {
        int cwRotationFromNaturalToDisplay;
        Camera.Parameters parameters = camera.getCamera().getParameters();
        WindowManager manager = (WindowManager)this.context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        int displayRotation = display.getRotation();
        switch (displayRotation) {
            case 0: {
                cwRotationFromNaturalToDisplay = 0;
                break;
            }
            case 1: {
                cwRotationFromNaturalToDisplay = 90;
                break;
            }
            case 2: {
                cwRotationFromNaturalToDisplay = 180;
                break;
            }
            case 3: {
                cwRotationFromNaturalToDisplay = 270;
                break;
            }
            default: {
                if (displayRotation % 90 == 0) {
                    cwRotationFromNaturalToDisplay = (360 + displayRotation) % 360;
                    break;
                }
                throw new IllegalArgumentException("Bad rotation: " + displayRotation);
            }
        }
        LogUtils.i("Display at: " + cwRotationFromNaturalToDisplay);
        int cwRotationFromNaturalToCamera = camera.getOrientation();
        LogUtils.i("Camera at: " + cwRotationFromNaturalToCamera);
        if (camera.getFacing() == CameraFacing.FRONT) {
            cwRotationFromNaturalToCamera = (360 - cwRotationFromNaturalToCamera) % 360;
            LogUtils.i("Front camera overriden to: " + cwRotationFromNaturalToCamera);
        }
        this.cwRotationFromDisplayToCamera = (360 + cwRotationFromNaturalToCamera - cwRotationFromNaturalToDisplay) % 360;
        LogUtils.i("Final display orientation: " + this.cwRotationFromDisplayToCamera);
        if (camera.getFacing() == CameraFacing.FRONT) {
            LogUtils.i("Compensating rotation for front camera");
            this.cwNeededRotation = (360 - this.cwRotationFromDisplayToCamera) % 360;
        } else {
            this.cwNeededRotation = this.cwRotationFromDisplayToCamera;
        }
        LogUtils.i("Clockwise rotation from display to camera: " + this.cwNeededRotation);
        Point theScreenResolution = new Point();
        display.getSize(theScreenResolution);
        this.screenResolution = theScreenResolution;
        LogUtils.i("Screen resolution in current orientation: " + this.screenResolution);
        this.cameraResolution = CameraConfigurationUtils.findBestPreviewSizeValue(parameters, this.screenResolution);
        LogUtils.i("Camera resolution: " + this.cameraResolution);
        this.bestPreviewSize = CameraConfigurationUtils.findBestPreviewSizeValue(parameters, this.screenResolution);
        LogUtils.i("Best available preview size: " + this.bestPreviewSize);
        boolean isScreenPortrait = this.screenResolution.x < this.screenResolution.y;
        boolean isPreviewSizePortrait = this.bestPreviewSize.x < this.bestPreviewSize.y;
        this.previewSizeOnScreen = isScreenPortrait == isPreviewSizePortrait ? this.bestPreviewSize : new Point(this.bestPreviewSize.y, this.bestPreviewSize.x);
        LogUtils.i("Preview size on screen: " + this.previewSizeOnScreen);
    }

    void setDesiredCameraParameters(OpenCamera camera, boolean safeMode) {
        Camera theCamera = camera.getCamera();
        Camera.Parameters parameters = theCamera.getParameters();
        if (parameters == null) {
            LogUtils.w("Device error: no camera parameters are available. Proceeding without configuration.");
            return;
        }
        LogUtils.i("Initial camera parameters: " + parameters.flatten());
        if (safeMode) {
            LogUtils.w("In camera config safe mode -- most settings will not be honored");
        }
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        if (parameters.isZoomSupported()) {
            parameters.setZoom(parameters.getMaxZoom() / 10);
        }
        this.initializeTorch(parameters, prefs, safeMode);
        CameraConfigurationUtils.setFocus(parameters, prefs.getBoolean("preferences_auto_focus", true), prefs.getBoolean("preferences_disable_continuous_focus", true), safeMode);
        if (!safeMode) {
            if (prefs.getBoolean("preferences_invert_scan", false)) {
                CameraConfigurationUtils.setInvertColor(parameters);
            }
            if (!prefs.getBoolean("preferences_disable_barcode_scene_mode", true)) {
                CameraConfigurationUtils.setBarcodeSceneMode(parameters);
            }
            if (!prefs.getBoolean("preferences_disable_metering", true)) {
                CameraConfigurationUtils.setVideoStabilization(parameters);
                CameraConfigurationUtils.setFocusArea(parameters);
                CameraConfigurationUtils.setMetering(parameters);
            }
            parameters.setRecordingHint(true);
        }
        parameters.setPreviewSize(this.bestPreviewSize.x, this.bestPreviewSize.y);
        theCamera.setParameters(parameters);
        theCamera.setDisplayOrientation(this.cwRotationFromDisplayToCamera);
        Camera.Parameters afterParameters = theCamera.getParameters();
        Camera.Size afterSize = afterParameters.getPreviewSize();
        if (afterSize != null && (this.bestPreviewSize.x != afterSize.width || this.bestPreviewSize.y != afterSize.height)) {
            LogUtils.w("Camera said it supported preview size " + this.bestPreviewSize.x + 'x' + this.bestPreviewSize.y + ", but after setting it, preview size is " + afterSize.width + 'x' + afterSize.height);
            this.bestPreviewSize.x = afterSize.width;
            this.bestPreviewSize.y = afterSize.height;
        }
    }

    Point getBestPreviewSize() {
        return this.bestPreviewSize;
    }

    Point getPreviewSizeOnScreen() {
        return this.previewSizeOnScreen;
    }

    Point getCameraResolution() {
        return this.cameraResolution;
    }

    Point getScreenResolution() {
        return this.screenResolution;
    }

    int getCWNeededRotation() {
        return this.cwNeededRotation;
    }

    boolean getTorchState(Camera camera) {
        Camera.Parameters parameters;
        if (camera != null && (parameters = camera.getParameters()) != null) {
            String flashMode = parameters.getFlashMode();
            return "on".equals(flashMode) || "torch".equals(flashMode);
        }
        return false;
    }

    void setTorch(Camera camera, boolean newSetting) {
        Camera.Parameters parameters = camera.getParameters();
        this.doSetTorch(parameters, newSetting, false);
        camera.setParameters(parameters);
    }

    private void initializeTorch(Camera.Parameters parameters, SharedPreferences prefs, boolean safeMode) {
        boolean currentSetting = FrontLightMode.readPref(prefs) == FrontLightMode.ON;
        this.doSetTorch(parameters, currentSetting, safeMode);
    }

    private void doSetTorch(Camera.Parameters parameters, boolean newSetting, boolean safeMode) {
        CameraConfigurationUtils.setTorch(parameters, newSetting);
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        if (!safeMode && !prefs.getBoolean("preferences_disable_exposure", true)) {
            CameraConfigurationUtils.setBestExposure(parameters, newSetting);
        }
    }
}

