/*
 * Decompiled with CFR 0.152.
 */
package com.yonghui.zxing.camera;

import android.content.Context;
import android.content.SharedPreferences;
import android.hardware.Camera;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import com.yonghui.zxing.util.LogUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.RejectedExecutionException;

final class AutoFocusManager
implements Camera.AutoFocusCallback {
    private static final long AUTO_FOCUS_INTERVAL_MS = 1200L;
    private static final Collection<String> FOCUS_MODES_CALLING_AF = new ArrayList<String>(2);
    private boolean stopped;
    private boolean focusing;
    private final boolean useAutoFocus;
    private final Camera camera;
    private AsyncTask<?, ?, ?> outstandingTask;

    AutoFocusManager(Context context, Camera camera) {
        this.camera = camera;
        SharedPreferences sharedPrefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String currentFocusMode = camera.getParameters().getFocusMode();
        this.useAutoFocus = sharedPrefs.getBoolean("preferences_auto_focus", true) && FOCUS_MODES_CALLING_AF.contains(currentFocusMode);
        LogUtils.i("Current focus mode '" + currentFocusMode + "'; use auto focus? " + this.useAutoFocus);
        this.start();
    }

    public synchronized void onAutoFocus(boolean success, Camera theCamera) {
        this.focusing = false;
        this.autoFocusAgainLater();
    }

    private synchronized void autoFocusAgainLater() {
        if (!this.stopped && this.outstandingTask == null) {
            AutoFocusTask newTask = new AutoFocusTask(this);
            try {
                newTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Object[0]);
                this.outstandingTask = newTask;
            }
            catch (RejectedExecutionException ree) {
                LogUtils.w("Could not request auto focus", ree);
            }
        }
    }

    synchronized void start() {
        if (this.useAutoFocus) {
            this.outstandingTask = null;
            if (!this.stopped && !this.focusing) {
                try {
                    this.camera.autoFocus((Camera.AutoFocusCallback)this);
                    this.focusing = true;
                }
                catch (RuntimeException re) {
                    LogUtils.w("Unexpected exception while focusing", re);
                    this.autoFocusAgainLater();
                }
            }
        }
    }

    private synchronized void cancelOutstandingTask() {
        if (this.outstandingTask != null) {
            if (this.outstandingTask.getStatus() != AsyncTask.Status.FINISHED) {
                this.outstandingTask.cancel(true);
            }
            this.outstandingTask = null;
        }
    }

    synchronized void stop() {
        this.stopped = true;
        if (this.useAutoFocus) {
            this.cancelOutstandingTask();
            try {
                this.camera.cancelAutoFocus();
            }
            catch (RuntimeException re) {
                LogUtils.w("Unexpected exception while cancelling focusing", re);
            }
        }
    }

    static {
        FOCUS_MODES_CALLING_AF.add("auto");
        FOCUS_MODES_CALLING_AF.add("macro");
    }

    private static class AutoFocusTask
    extends AsyncTask<Object, Object, Object> {
        private WeakReference<AutoFocusManager> weakReference;

        public AutoFocusTask(AutoFocusManager manager) {
            this.weakReference = new WeakReference<AutoFocusManager>(manager);
        }

        protected Object doInBackground(Object ... voids) {
            try {
                Thread.sleep(1200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            AutoFocusManager manager = (AutoFocusManager)this.weakReference.get();
            if (manager != null) {
                manager.start();
            }
            return null;
        }
    }
}

