/*
 * Decompiled with CFR 0.152.
 */
package com.yonghui.zxing;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.google.zxing.ResultPoint;
import com.yonghui.zxing.R;
import java.util.ArrayList;
import java.util.List;

public final class ViewfinderView
extends View {
    private static final int CURRENT_POINT_OPACITY = 160;
    private static final int MAX_RESULT_POINTS = 20;
    private static final int POINT_SIZE = 20;
    private Paint paint;
    private TextPaint textPaint;
    private int maskColor;
    private int frameColor;
    private int laserColor;
    private int cornerColor;
    private int resultPointColor;
    private float labelTextPadding;
    private TextLocation labelTextLocation;
    private String labelText;
    private int labelTextColor;
    private float labelTextSize;
    public int scannerStart = 0;
    public int scannerEnd = 0;
    private boolean isShowResultPoint;
    private int screenWidth;
    private int screenHeight;
    private int frameWidth;
    private int frameHeight;
    private LaserStyle laserStyle;
    private int gridColumn;
    private int gridHeight;
    private Rect frame;
    private int cornerRectWidth;
    private int cornerRectHeight;
    private int scannerLineMoveDistance;
    private int scannerLineHeight;
    private int frameLineWidth;
    private int scannerAnimationDelay;
    private float frameRatio;
    private List<ResultPoint> possibleResultPoints;
    private List<ResultPoint> lastPossibleResultPoints;

    public ViewfinderView(Context context) {
        this(context, null);
    }

    public ViewfinderView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ViewfinderView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.ViewfinderView);
        this.maskColor = array.getColor(R.styleable.ViewfinderView_maskColor, ContextCompat.getColor((Context)context, (int)R.color.viewfinder_mask));
        this.frameColor = array.getColor(R.styleable.ViewfinderView_frameColor, ContextCompat.getColor((Context)context, (int)R.color.viewfinder_frame));
        this.cornerColor = array.getColor(R.styleable.ViewfinderView_cornerColor, ContextCompat.getColor((Context)context, (int)R.color.viewfinder_corner));
        this.laserColor = array.getColor(R.styleable.ViewfinderView_laserColor, ContextCompat.getColor((Context)context, (int)R.color.viewfinder_laser));
        this.resultPointColor = array.getColor(R.styleable.ViewfinderView_resultPointColor, ContextCompat.getColor((Context)context, (int)R.color.viewfinder_result_point_color));
        this.labelText = array.getString(R.styleable.ViewfinderView_labelText);
        this.labelTextColor = array.getColor(R.styleable.ViewfinderView_labelTextColor, ContextCompat.getColor((Context)context, (int)R.color.viewfinder_text_color));
        this.labelTextSize = array.getDimension(R.styleable.ViewfinderView_labelTextSize, TypedValue.applyDimension((int)2, (float)14.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.labelTextPadding = array.getDimension(R.styleable.ViewfinderView_labelTextPadding, TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.labelTextLocation = TextLocation.getFromInt(array.getInt(R.styleable.ViewfinderView_labelTextLocation, 0));
        this.isShowResultPoint = array.getBoolean(R.styleable.ViewfinderView_showResultPoint, false);
        this.frameWidth = array.getDimensionPixelSize(R.styleable.ViewfinderView_frameWidth, 0);
        this.frameHeight = array.getDimensionPixelSize(R.styleable.ViewfinderView_frameHeight, 0);
        this.laserStyle = LaserStyle.getFromInt(array.getInt(R.styleable.ViewfinderView_laserStyle, LaserStyle.LINE.mValue));
        this.gridColumn = array.getInt(R.styleable.ViewfinderView_gridColumn, 20);
        this.gridHeight = (int)array.getDimension(R.styleable.ViewfinderView_gridHeight, TypedValue.applyDimension((int)1, (float)40.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.cornerRectWidth = (int)array.getDimension(R.styleable.ViewfinderView_cornerRectWidth, TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.cornerRectHeight = (int)array.getDimension(R.styleable.ViewfinderView_cornerRectHeight, TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.scannerLineMoveDistance = (int)array.getDimension(R.styleable.ViewfinderView_scannerLineMoveDistance, TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.scannerLineHeight = (int)array.getDimension(R.styleable.ViewfinderView_scannerLineHeight, TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.frameLineWidth = (int)array.getDimension(R.styleable.ViewfinderView_frameLineWidth, TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.scannerAnimationDelay = array.getInteger(R.styleable.ViewfinderView_scannerAnimationDelay, 15);
        this.frameRatio = array.getFloat(R.styleable.ViewfinderView_frameRatio, 0.625f);
        array.recycle();
        this.paint = new Paint(1);
        this.textPaint = new TextPaint(1);
        this.possibleResultPoints = new ArrayList<ResultPoint>(5);
        this.lastPossibleResultPoints = null;
        this.screenWidth = this.getDisplayMetrics().widthPixels;
        this.screenHeight = this.getDisplayMetrics().heightPixels;
        int size = (int)((float)Math.min(this.screenWidth, this.screenHeight) * this.frameRatio);
        if (this.frameWidth <= 0 || this.frameWidth > this.screenWidth) {
            this.frameWidth = size;
        }
        if (this.frameHeight <= 0 || this.frameHeight > this.screenHeight) {
            this.frameHeight = size;
        }
    }

    private DisplayMetrics getDisplayMetrics() {
        return this.getResources().getDisplayMetrics();
    }

    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    public void setLabelTextColor(@ColorInt int color2) {
        this.labelTextColor = color2;
    }

    public void setLabelTextColorResource(@ColorRes int id2) {
        this.labelTextColor = ContextCompat.getColor((Context)this.getContext(), (int)id2);
    }

    public void setLabelTextSize(float textSize) {
        this.labelTextSize = textSize;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int leftOffset = (this.screenWidth - this.frameWidth) / 2 + this.getPaddingLeft() - this.getPaddingRight();
        int topOffset = (this.screenHeight - this.frameHeight) / 2 + this.getPaddingTop() - this.getPaddingBottom();
        this.frame = new Rect(leftOffset, topOffset, leftOffset + this.frameWidth, topOffset + this.frameHeight);
    }

    public void onDraw(Canvas canvas) {
        if (this.frame == null) {
            return;
        }
        if (this.scannerStart == 0 || this.scannerEnd == 0) {
            this.scannerStart = this.frame.top;
            this.scannerEnd = this.frame.bottom - this.scannerLineHeight;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        this.drawExterior(canvas, this.frame, width, height);
        this.drawLaserScanner(canvas, this.frame);
        this.drawFrame(canvas, this.frame);
        this.drawCorner(canvas, this.frame);
        this.drawTextInfo(canvas, this.frame);
        this.drawResultPoint(canvas, this.frame);
        this.postInvalidateDelayed(this.scannerAnimationDelay, this.frame.left - 20, this.frame.top - 20, this.frame.right + 20, this.frame.bottom + 20);
    }

    private void drawTextInfo(Canvas canvas, Rect frame) {
        if (!TextUtils.isEmpty((CharSequence)this.labelText)) {
            this.textPaint.setColor(this.labelTextColor);
            this.textPaint.setTextSize(this.labelTextSize);
            this.textPaint.setTextAlign(Paint.Align.CENTER);
            StaticLayout staticLayout = new StaticLayout((CharSequence)this.labelText, this.textPaint, canvas.getWidth(), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
            if (this.labelTextLocation == TextLocation.BOTTOM) {
                canvas.translate((float)(frame.left + frame.width() / 2), (float)frame.bottom + this.labelTextPadding);
                staticLayout.draw(canvas);
            } else {
                canvas.translate((float)(frame.left + frame.width() / 2), (float)frame.top - this.labelTextPadding - (float)staticLayout.getHeight());
                staticLayout.draw(canvas);
            }
        }
    }

    private void drawCorner(Canvas canvas, Rect frame) {
        this.paint.setColor(this.cornerColor);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + this.cornerRectWidth), (float)(frame.top + this.cornerRectHeight), this.paint);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + this.cornerRectHeight), (float)(frame.top + this.cornerRectWidth), this.paint);
        canvas.drawRect((float)(frame.right - this.cornerRectWidth), (float)frame.top, (float)frame.right, (float)(frame.top + this.cornerRectHeight), this.paint);
        canvas.drawRect((float)(frame.right - this.cornerRectHeight), (float)frame.top, (float)frame.right, (float)(frame.top + this.cornerRectWidth), this.paint);
        canvas.drawRect((float)frame.left, (float)(frame.bottom - this.cornerRectWidth), (float)(frame.left + this.cornerRectHeight), (float)frame.bottom, this.paint);
        canvas.drawRect((float)frame.left, (float)(frame.bottom - this.cornerRectHeight), (float)(frame.left + this.cornerRectWidth), (float)frame.bottom, this.paint);
        canvas.drawRect((float)(frame.right - this.cornerRectWidth), (float)(frame.bottom - this.cornerRectHeight), (float)frame.right, (float)frame.bottom, this.paint);
        canvas.drawRect((float)(frame.right - this.cornerRectHeight), (float)(frame.bottom - this.cornerRectWidth), (float)frame.right, (float)frame.bottom, this.paint);
    }

    private void drawLaserScanner(Canvas canvas, Rect frame) {
        if (this.laserStyle != null) {
            this.paint.setColor(this.laserColor);
            switch (this.laserStyle) {
                case LINE: {
                    this.drawLineScanner(canvas, frame);
                    break;
                }
                case GRID: {
                    this.drawGridScanner(canvas, frame);
                }
            }
            this.paint.setShader(null);
        }
    }

    private void drawLineScanner(Canvas canvas, Rect frame) {
        LinearGradient linearGradient = new LinearGradient((float)frame.left, (float)this.scannerStart, (float)frame.left, (float)(this.scannerStart + this.scannerLineHeight), this.shadeColor(this.laserColor), this.laserColor, Shader.TileMode.MIRROR);
        this.paint.setShader((Shader)linearGradient);
        if (this.scannerStart <= this.scannerEnd) {
            RectF rectF = new RectF((float)(frame.left + 2 * this.scannerLineHeight), (float)this.scannerStart, (float)(frame.right - 2 * this.scannerLineHeight), (float)(this.scannerStart + this.scannerLineHeight));
            canvas.drawOval(rectF, this.paint);
            this.scannerStart += this.scannerLineMoveDistance;
        } else {
            this.scannerStart = frame.top;
        }
    }

    private void drawGridScanner(Canvas canvas, Rect frame) {
        float wUnit;
        int stroke = 2;
        this.paint.setStrokeWidth((float)stroke);
        int startY = this.gridHeight > 0 && this.scannerStart - frame.top > this.gridHeight ? this.scannerStart - this.gridHeight : frame.top;
        LinearGradient linearGradient = new LinearGradient((float)(frame.left + frame.width() / 2), (float)startY, (float)(frame.left + frame.width() / 2), (float)this.scannerStart, new int[]{this.shadeColor(this.laserColor), this.laserColor}, new float[]{0.0f, 1.0f}, Shader.TileMode.CLAMP);
        this.paint.setShader((Shader)linearGradient);
        float hUnit = wUnit = (float)frame.width() * 1.0f / (float)this.gridColumn;
        for (int i = 1; i < this.gridColumn; ++i) {
            canvas.drawLine((float)frame.left + (float)i * wUnit, (float)startY, (float)frame.left + (float)i * wUnit, (float)this.scannerStart, this.paint);
        }
        int height = this.gridHeight > 0 && this.scannerStart - frame.top > this.gridHeight ? this.gridHeight : this.scannerStart - frame.top;
        int i = 0;
        while ((float)i <= (float)height / hUnit) {
            canvas.drawLine((float)frame.left, (float)this.scannerStart - (float)i * hUnit, (float)frame.right, (float)this.scannerStart - (float)i * hUnit, this.paint);
            ++i;
        }
        this.scannerStart = this.scannerStart < this.scannerEnd ? (this.scannerStart += this.scannerLineMoveDistance) : frame.top;
    }

    public int shadeColor(int color2) {
        String hax = Integer.toHexString(color2);
        String result = "01" + hax.substring(2);
        return Integer.valueOf(result, 16);
    }

    private void drawFrame(Canvas canvas, Rect frame) {
        this.paint.setColor(this.frameColor);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)frame.right, (float)(frame.top + this.frameLineWidth), this.paint);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + this.frameLineWidth), (float)frame.bottom, this.paint);
        canvas.drawRect((float)(frame.right - this.frameLineWidth), (float)frame.top, (float)frame.right, (float)frame.bottom, this.paint);
        canvas.drawRect((float)frame.left, (float)(frame.bottom - this.frameLineWidth), (float)frame.right, (float)frame.bottom, this.paint);
    }

    private void drawExterior(Canvas canvas, Rect frame, int width, int height) {
        this.paint.setColor(this.maskColor);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)frame.top, this.paint);
        canvas.drawRect(0.0f, (float)frame.top, (float)frame.left, (float)frame.bottom, this.paint);
        canvas.drawRect((float)frame.right, (float)frame.top, (float)width, (float)frame.bottom, this.paint);
        canvas.drawRect(0.0f, (float)frame.bottom, (float)width, (float)height, this.paint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawResultPoint(Canvas canvas, Rect frame) {
        float radius;
        List<ResultPoint> list;
        if (!this.isShowResultPoint) {
            return;
        }
        List<ResultPoint> currentPossible = this.possibleResultPoints;
        List<ResultPoint> currentLast = this.lastPossibleResultPoints;
        if (currentPossible.isEmpty()) {
            this.lastPossibleResultPoints = null;
        } else {
            this.possibleResultPoints = new ArrayList<ResultPoint>(5);
            this.lastPossibleResultPoints = currentPossible;
            this.paint.setAlpha(160);
            this.paint.setColor(this.resultPointColor);
            list = currentPossible;
            synchronized (list) {
                radius = 10.0f;
                for (ResultPoint point : currentPossible) {
                    canvas.drawCircle(point.getX(), point.getY(), radius, this.paint);
                }
            }
        }
        if (currentLast != null) {
            this.paint.setAlpha(80);
            this.paint.setColor(this.resultPointColor);
            list = currentLast;
            synchronized (list) {
                radius = 10.0f;
                for (ResultPoint point : currentLast) {
                    canvas.drawCircle(point.getX(), point.getY(), radius, this.paint);
                }
            }
        }
    }

    public void drawViewfinder() {
        this.invalidate();
    }

    public boolean isShowResultPoint() {
        return this.isShowResultPoint;
    }

    public void setLaserStyle(LaserStyle laserStyle) {
        this.laserStyle = laserStyle;
    }

    public void setShowResultPoint(boolean showResultPoint) {
        this.isShowResultPoint = showResultPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPossibleResultPoint(ResultPoint point) {
        if (this.isShowResultPoint) {
            List<ResultPoint> points;
            List<ResultPoint> list = points = this.possibleResultPoints;
            synchronized (list) {
                points.add(point);
                int size = points.size();
                if (size > 20) {
                    points.subList(0, size - 10).clear();
                }
            }
        }
    }

    public static enum TextLocation {
        TOP(0),
        BOTTOM(1);

        private int mValue;

        private TextLocation(int value) {
            this.mValue = value;
        }

        private static TextLocation getFromInt(int value) {
            for (TextLocation location : TextLocation.values()) {
                if (location.mValue != value) continue;
                return location;
            }
            return TOP;
        }
    }

    public static enum LaserStyle {
        NONE(0),
        LINE(1),
        GRID(2);

        private int mValue;

        private LaserStyle(int value) {
            this.mValue = value;
        }

        private static LaserStyle getFromInt(int value) {
            for (LaserStyle style : LaserStyle.values()) {
                if (style.mValue != value) continue;
                return style;
            }
            return LINE;
        }
    }
}

