/*
 * Decompiled with CFR 0.152.
 */
package com.yonghui.zxing;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.hardware.Camera;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.Display;
import android.view.WindowManager;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import com.yonghui.zxing.CaptureHandler;
import com.yonghui.zxing.R;
import com.yonghui.zxing.camera.CameraManager;
import com.yonghui.zxing.util.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;

final class DecodeHandler
extends Handler {
    private final Context context;
    private final CameraManager cameraManager;
    private final CaptureHandler handler;
    private final MultiFormatReader multiFormatReader = new MultiFormatReader();
    private boolean running = true;
    private long lastZoomTime;

    DecodeHandler(Context context, CameraManager cameraManager, CaptureHandler handler, Map<DecodeHintType, Object> hints) {
        this.multiFormatReader.setHints(hints);
        this.context = context;
        this.cameraManager = cameraManager;
        this.handler = handler;
    }

    public void handleMessage(Message message) {
        if (message == null || !this.running) {
            return;
        }
        if (message.what == R.id.decode) {
            this.decode((byte[])message.obj, message.arg1, message.arg2, this.isScreenPortrait(), this.handler.isSupportVerticalCode());
        } else if (message.what == R.id.quit) {
            this.running = false;
            Looper.myLooper().quit();
        }
    }

    private boolean isScreenPortrait() {
        WindowManager manager = (WindowManager)this.context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        Point screenResolution = new Point();
        display.getSize(screenResolution);
        return screenResolution.x < screenResolution.y;
    }

    private void decode(byte[] data, int width, int height, boolean isScreenPortrait, boolean isSupportVerticalCode) {
        long start = System.currentTimeMillis();
        Result rawResult = null;
        PlanarYUVLuminanceSource source = this.buildPlanarYUVLuminanceSource(data, width, height, isScreenPortrait);
        if (source != null) {
            boolean isReDecode;
            BinaryBitmap bitmap;
            try {
                bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
                rawResult = this.multiFormatReader.decodeWithState(bitmap);
                isReDecode = false;
            }
            catch (Exception e) {
                isReDecode = true;
            }
            if (isReDecode && this.handler.isSupportLuminanceInvert()) {
                try {
                    bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer(source.invert()));
                    rawResult = this.multiFormatReader.decodeWithState(bitmap);
                    isReDecode = false;
                }
                catch (Exception e) {
                    isReDecode = true;
                }
            }
            if (isReDecode) {
                try {
                    bitmap = new BinaryBitmap((Binarizer)new GlobalHistogramBinarizer((LuminanceSource)source));
                    rawResult = this.multiFormatReader.decodeWithState(bitmap);
                    isReDecode = false;
                }
                catch (Exception e) {
                    isReDecode = true;
                }
            }
            if (isReDecode && isSupportVerticalCode && (source = this.buildPlanarYUVLuminanceSource(data, width, height, !isScreenPortrait)) != null) {
                try {
                    bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
                    rawResult = this.multiFormatReader.decodeWithState(bitmap);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.multiFormatReader.reset();
        }
        if (rawResult != null) {
            ResultPoint[] resultPoints;
            long end = System.currentTimeMillis();
            LogUtils.d("Found barcode in " + (end - start) + " ms");
            BarcodeFormat barcodeFormat = rawResult.getBarcodeFormat();
            if (this.handler != null && this.handler.isSupportAutoZoom() && barcodeFormat == BarcodeFormat.QR_CODE && (resultPoints = rawResult.getResultPoints()).length >= 3) {
                float distance1 = ResultPoint.distance((ResultPoint)resultPoints[0], (ResultPoint)resultPoints[1]);
                float distance2 = ResultPoint.distance((ResultPoint)resultPoints[1], (ResultPoint)resultPoints[2]);
                float distance3 = ResultPoint.distance((ResultPoint)resultPoints[0], (ResultPoint)resultPoints[2]);
                int maxDistance = (int)Math.max(Math.max(distance1, distance2), distance3);
                if (this.handleAutoZoom(maxDistance, width)) {
                    Message message = Message.obtain();
                    message.what = R.id.decode_succeeded;
                    message.obj = rawResult;
                    if (this.handler.isReturnBitmap()) {
                        Bundle bundle = new Bundle();
                        DecodeHandler.bundleThumbnail(source, bundle);
                        message.setData(bundle);
                    }
                    this.handler.sendMessageDelayed(message, 300L);
                    return;
                }
            }
            if (this.handler != null) {
                Message message = Message.obtain((Handler)this.handler, (int)R.id.decode_succeeded, (Object)rawResult);
                if (this.handler.isReturnBitmap()) {
                    Bundle bundle = new Bundle();
                    DecodeHandler.bundleThumbnail(source, bundle);
                    message.setData(bundle);
                }
                message.sendToTarget();
            }
        } else if (this.handler != null) {
            Message message = Message.obtain((Handler)this.handler, (int)R.id.decode_failed);
            message.sendToTarget();
        }
    }

    private PlanarYUVLuminanceSource buildPlanarYUVLuminanceSource(byte[] data, int width, int height, boolean isRotate) {
        PlanarYUVLuminanceSource source;
        if (isRotate) {
            byte[] rotatedData = new byte[data.length];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    rotatedData[x * height + height - y - 1] = data[x + y * width];
                }
            }
            int tmp = width;
            width = height;
            height = tmp;
            source = this.cameraManager.buildLuminanceSource(rotatedData, width, height);
        } else {
            source = this.cameraManager.buildLuminanceSource(data, width, height);
        }
        return source;
    }

    private static void bundleThumbnail(PlanarYUVLuminanceSource source, Bundle bundle) {
        int[] pixels = source.renderThumbnail();
        int width = source.getThumbnailWidth();
        int height = source.getThumbnailHeight();
        Bitmap bitmap = Bitmap.createBitmap((int[])pixels, (int)0, (int)width, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)out);
        bundle.putByteArray("barcode_bitmap", out.toByteArray());
        bundle.putFloat("barcode_scaled_factor", (float)width / (float)source.getWidth());
    }

    private boolean handleAutoZoom(int length, int width) {
        Camera camera;
        if (this.lastZoomTime > System.currentTimeMillis() - 1000L) {
            return true;
        }
        if (length < width / 5 && (camera = this.cameraManager.getOpenCamera().getCamera()) != null) {
            Camera.Parameters params = camera.getParameters();
            if (params.isZoomSupported()) {
                int maxZoom = params.getMaxZoom();
                int zoom = params.getZoom();
                params.setZoom(Math.min(zoom + maxZoom / 5, maxZoom));
                camera.setParameters(params);
                this.lastZoomTime = System.currentTimeMillis();
                return true;
            }
            LogUtils.i("Zoom not supported");
        }
        return false;
    }
}

