/*
 * Decompiled with CFR 0.152.
 */
package com.yonghui.zxing;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.Display;
import android.view.WindowManager;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.yonghui.zxing.DecodeThread;
import com.yonghui.zxing.OnCaptureListener;
import com.yonghui.zxing.R;
import com.yonghui.zxing.ViewfinderView;
import com.yonghui.zxing.camera.CameraManager;
import java.util.Collection;
import java.util.Map;

public class CaptureHandler
extends Handler
implements ResultPointCallback {
    private static final String TAG = CaptureHandler.class.getSimpleName();
    private final OnCaptureListener onCaptureListener;
    private final DecodeThread decodeThread;
    private State state;
    private final CameraManager cameraManager;
    private final ViewfinderView viewfinderView;
    private boolean isSupportVerticalCode;
    private boolean isReturnBitmap;
    private boolean isSupportAutoZoom;
    private boolean isSupportLuminanceInvert;

    CaptureHandler(Activity activity, ViewfinderView viewfinderView, OnCaptureListener onCaptureListener, Collection<BarcodeFormat> decodeFormats, Map<DecodeHintType, Object> baseHints, String characterSet, CameraManager cameraManager) {
        this.viewfinderView = viewfinderView;
        this.onCaptureListener = onCaptureListener;
        this.decodeThread = new DecodeThread((Context)activity, cameraManager, this, decodeFormats, baseHints, characterSet, this);
        this.decodeThread.start();
        this.state = State.SUCCESS;
        this.cameraManager = cameraManager;
        cameraManager.startPreview();
        this.restartPreviewAndDecode();
    }

    public void handleMessage(Message message) {
        if (message.what == R.id.restart_preview) {
            this.restartPreviewAndDecode();
        } else if (message.what == R.id.decode_succeeded) {
            this.state = State.SUCCESS;
            Bundle bundle = message.getData();
            Bitmap barcode = null;
            float scaleFactor = 1.0f;
            if (bundle != null) {
                byte[] compressedBitmap = bundle.getByteArray("barcode_bitmap");
                if (compressedBitmap != null) {
                    barcode = BitmapFactory.decodeByteArray((byte[])compressedBitmap, (int)0, (int)compressedBitmap.length, null);
                    barcode = barcode.copy(Bitmap.Config.ARGB_8888, true);
                }
                scaleFactor = bundle.getFloat("barcode_scaled_factor");
            }
            this.onCaptureListener.onHandleDecode((Result)message.obj, barcode, scaleFactor);
        } else if (message.what == R.id.decode_failed) {
            this.state = State.PREVIEW;
            this.cameraManager.requestPreviewFrame(this.decodeThread.getHandler(), R.id.decode);
        }
    }

    public void quitSynchronously() {
        this.state = State.DONE;
        this.cameraManager.stopPreview();
        Message quit = Message.obtain((Handler)this.decodeThread.getHandler(), (int)R.id.quit);
        quit.sendToTarget();
        try {
            this.decodeThread.join(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.removeMessages(R.id.decode_succeeded);
        this.removeMessages(R.id.decode_failed);
    }

    public void restartPreviewAndDecode() {
        if (this.state == State.SUCCESS) {
            this.state = State.PREVIEW;
            this.cameraManager.requestPreviewFrame(this.decodeThread.getHandler(), R.id.decode);
            if (this.viewfinderView != null) {
                this.viewfinderView.drawViewfinder();
            }
        }
    }

    public void foundPossibleResultPoint(ResultPoint point) {
        if (this.viewfinderView != null) {
            ResultPoint resultPoint = this.transform(point);
            this.viewfinderView.addPossibleResultPoint(resultPoint);
        }
    }

    private boolean isScreenPortrait(Context context) {
        WindowManager manager = (WindowManager)context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        Point screenResolution = new Point();
        display.getSize(screenResolution);
        return screenResolution.x < screenResolution.y;
    }

    private ResultPoint transform(ResultPoint originPoint) {
        float y;
        float x;
        Point screenPoint = this.cameraManager.getScreenResolution();
        Point cameraPoint = this.cameraManager.getCameraResolution();
        if (screenPoint.x < screenPoint.y) {
            float scaleX = 1.0f * (float)screenPoint.x / (float)cameraPoint.y;
            float scaleY = 1.0f * (float)screenPoint.y / (float)cameraPoint.x;
            x = originPoint.getX() * scaleX - (float)(Math.max(screenPoint.x, cameraPoint.y) / 2);
            y = originPoint.getY() * scaleY - (float)(Math.min(screenPoint.y, cameraPoint.x) / 2);
        } else {
            float scaleX = 1.0f * (float)screenPoint.x / (float)cameraPoint.x;
            float scaleY = 1.0f * (float)screenPoint.y / (float)cameraPoint.y;
            x = originPoint.getX() * scaleX - (float)(Math.min(screenPoint.y, cameraPoint.y) / 2);
            y = originPoint.getY() * scaleY - (float)(Math.max(screenPoint.x, cameraPoint.x) / 2);
        }
        return new ResultPoint(x, y);
    }

    public boolean isSupportVerticalCode() {
        return this.isSupportVerticalCode;
    }

    public void setSupportVerticalCode(boolean supportVerticalCode) {
        this.isSupportVerticalCode = supportVerticalCode;
    }

    public boolean isReturnBitmap() {
        return this.isReturnBitmap;
    }

    public void setReturnBitmap(boolean returnBitmap) {
        this.isReturnBitmap = returnBitmap;
    }

    public boolean isSupportAutoZoom() {
        return this.isSupportAutoZoom;
    }

    public void setSupportAutoZoom(boolean supportAutoZoom) {
        this.isSupportAutoZoom = supportAutoZoom;
    }

    public boolean isSupportLuminanceInvert() {
        return this.isSupportLuminanceInvert;
    }

    public void setSupportLuminanceInvert(boolean supportLuminanceInvert) {
        this.isSupportLuminanceInvert = supportLuminanceInvert;
    }

    private static enum State {
        PREVIEW,
        SUCCESS,
        DONE;

    }
}

