/*
 * Decompiled with CFR 0.152.
 */
package com.yonghui.zxing;

import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import com.yonghui.zxing.CaptureHelper;
import com.yonghui.zxing.OnCaptureCallback;
import com.yonghui.zxing.R;
import com.yonghui.zxing.ViewfinderView;
import com.yonghui.zxing.camera.CameraManager;

public class CaptureFragment
extends Fragment
implements OnCaptureCallback {
    public static final String KEY_RESULT = "SCAN_RESULT";
    private View mRootView;
    private SurfaceView surfaceView;
    private ViewfinderView viewfinderView;
    private View ivTorch;
    private CaptureHelper mCaptureHelper;

    public static CaptureFragment newInstance() {
        Bundle args = new Bundle();
        CaptureFragment fragment = new CaptureFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        int layoutId = this.getLayoutId();
        if (this.isContentView(layoutId)) {
            this.mRootView = inflater.inflate(this.getLayoutId(), container, false);
        }
        this.initUI();
        return this.mRootView;
    }

    public void initUI() {
        int ivTorchId;
        this.surfaceView = (SurfaceView)this.mRootView.findViewById(this.getSurfaceViewId());
        int viewfinderViewId = this.getViewfinderViewId();
        if (viewfinderViewId != 0) {
            this.viewfinderView = (ViewfinderView)this.mRootView.findViewById(viewfinderViewId);
        }
        if ((ivTorchId = this.getIvTorchId()) != 0) {
            this.ivTorch = this.mRootView.findViewById(ivTorchId);
            this.ivTorch.setVisibility(4);
        }
        this.initCaptureHelper();
    }

    public void initCaptureHelper() {
        this.mCaptureHelper = new CaptureHelper(this, this.surfaceView, this.viewfinderView, this.ivTorch);
        this.mCaptureHelper.setOnCaptureCallback(this);
    }

    public boolean isContentView(@LayoutRes int layoutId) {
        return true;
    }

    public int getLayoutId() {
        return R.layout.zxl_capture;
    }

    public int getViewfinderViewId() {
        return R.id.viewfinderView;
    }

    public int getSurfaceViewId() {
        return R.id.surfaceView;
    }

    public int getIvTorchId() {
        return R.id.ivTorch;
    }

    public CaptureHelper getCaptureHelper() {
        return this.mCaptureHelper;
    }

    @Deprecated
    public CameraManager getCameraManager() {
        return this.mCaptureHelper.getCameraManager();
    }

    public View getRootView() {
        return this.mRootView;
    }

    public void setRootView(View rootView) {
        this.mRootView = rootView;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mCaptureHelper.onCreate();
    }

    public void onResume() {
        super.onResume();
        this.mCaptureHelper.onResume();
    }

    public void onPause() {
        super.onPause();
        this.mCaptureHelper.onPause();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCaptureHelper.onDestroy();
    }

    @Override
    public boolean onResultCallback(String result) {
        return false;
    }
}

