/*
 * Copyright (C) 2019 Jenly Yu
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.yonghui.zxing;

import android.app.Activity;
import android.os.Bundle;

/**
 * @author fanpeihua
 */
public interface CaptureLifecycle {

    /**
     * {@link Activity#onCreate(Bundle)}
     */
    void onCreate();
    /**
     * {@link Activity#onResume()}
     */
    void onResume();

    /**
     * {@link Activity#onPause()}
     */
    void onPause();

    /**
     * {@link Activity#onDestroy()}
     */
    void onDestroy();

}
