/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.read.impl;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.parser.constant.ReadType;
import com.yomahub.liteflow.parser.sql.exception.ELSQLException;
import com.yomahub.liteflow.parser.sql.read.AbstractSqlRead;
import com.yomahub.liteflow.parser.sql.read.vo.InstanceIdVO;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class InstanceIdRead
extends AbstractSqlRead<InstanceIdVO> {
    public InstanceIdRead(SQLParserVO config) {
        super(config);
    }

    @Override
    protected InstanceIdVO parse(ResultSet rs) throws SQLException {
        InstanceIdVO idVO = new InstanceIdVO();
        idVO.setChainId(this.getStringFromRsWithCheck(rs, this.config.getInstanceChainIdField()));
        idVO.setElDataMd5(this.getStringFromRsWithCheck(rs, this.config.getElDataMd5Field()));
        idVO.setNodeInstanceIdMapJson(this.getStringFromRsWithCheck(rs, this.config.getNodeInstanceIdMapJsonField()));
        return idVO;
    }

    @Override
    public boolean hasEnableFiled() {
        return true;
    }

    @Override
    public boolean getEnableFiledValue(ResultSet rs) {
        return true;
    }

    @Override
    public String buildQuerySql() {
        String tableName = this.config.getInstanceIdTableName();
        String applicationNameField = this.config.getInstanceIdApplicationNameField();
        String applicationName = this.config.getApplicationName();
        return StrUtil.format((CharSequence)"SELECT * FROM {} WHERE {}='{}'", (Object[])new Object[]{tableName, applicationNameField, applicationName});
    }

    @Override
    public String buildQuerySql(String chainId) {
        String tableName = this.config.getInstanceIdTableName();
        String chainNameField = this.config.getInstanceChainIdField();
        String instanceIdApplicationNameField = this.config.getInstanceIdApplicationNameField();
        String applicationName = this.config.getApplicationName();
        if (StringUtils.isEmpty((String)chainId)) {
            throw new IllegalArgumentException("You did not define the chainId");
        }
        return StrUtil.format((CharSequence)"SELECT * FROM {} WHERE {}='{}' and  {}='{}'", (Object[])new Object[]{tableName, instanceIdApplicationNameField, applicationName, chainNameField, chainId});
    }

    @Override
    public void checkConfig() {
        String tableName = this.config.getInstanceIdTableName();
        String chainNameField = this.config.getInstanceChainIdField();
        if (StrUtil.isBlank((CharSequence)tableName)) {
            throw new ELSQLException("You did not define the tableName property");
        }
        if (StrUtil.isBlank((CharSequence)chainNameField)) {
            throw new ELSQLException("You did not define the chainNameField property");
        }
    }

    @Override
    public ReadType type() {
        return null;
    }
}

