/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.yomahub.liteflow.exception.JsonProcessException;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;

public class JsonUtil {
    private static final LFLog LOG = LFLoggerManager.getLogger(JsonUtil.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private JsonUtil() {
    }

    public static String toJsonString(Object object) {
        if (ObjectUtil.isNull((Object)object)) {
            return null;
        }
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            String errMsg = StrUtil.format((CharSequence)"Error while writing value as string[{}],reason: {}", (Object[])new Object[]{object.getClass().getName(), e.getMessage()});
            LOG.error(e.getMessage(), e);
            throw new JsonProcessException(errMsg);
        }
    }

    public static JsonNode parseObject(String text) {
        if (StrUtil.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            return objectMapper.readTree(text);
        }
        catch (IOException e) {
            String errMsg = StrUtil.format((CharSequence)"Error while parsing text [{}],reason: {}", (Object[])new Object[]{text, e.getMessage()});
            LOG.error(e.getMessage(), e);
            throw new JsonProcessException(errMsg);
        }
    }

    public static <T> T parseObject(String json, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            String errMsg = StrUtil.format((CharSequence)"Error while parsing text [{}],reason: {}", (Object[])new Object[]{json, e.getMessage()});
            LOG.error(e.getMessage(), e);
            throw new JsonProcessException(errMsg);
        }
    }

    public static <T> List<T> parseList(String json, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)json)) {
            return Collections.emptyList();
        }
        try {
            CollectionType listType = objectMapper.getTypeFactory().constructCollectionType(ArrayList.class, clazz);
            return (List)objectMapper.readValue(json, (JavaType)listType);
        }
        catch (IOException e) {
            String errMsg = StrUtil.format((CharSequence)"Error while parsing text [{}],reason: {}", (Object[])new Object[]{json, e.getMessage()});
            LOG.error(e.getMessage(), e);
            throw new JsonProcessException(errMsg);
        }
    }

    static {
        objectMapper.setTimeZone(TimeZone.getDefault());
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        objectMapper.registerModule((Module)javaTimeModule);
    }
}

