/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.util;

import com.yomahub.liteflow.exception.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ElRegexUtil {
    private static final String REGEX_COMMENT = "(?<!(:|@))\\/\\/.*|\\/\\*(\\s|.)*?\\*\\/";
    private static final String REGEX_ABSTRACT_HOLDER = "\\{\\{\\s*([a-zA-Z_][a-zA-Z_\\d]*|\\d+)\\s*\\}\\}(?![\\s]*=)";

    public static String replaceAbstractChain(String abstractChain, String implChain) {
        Pattern placeHolder = Pattern.compile(REGEX_ABSTRACT_HOLDER);
        Matcher placeHolderMatcher = placeHolder.matcher(abstractChain);
        while (placeHolderMatcher.find()) {
            String holder = placeHolderMatcher.group(1);
            Pattern placeHolderImpl = Pattern.compile("\\s*\\{\\{" + holder + "\\}\\}\\s*=\\s*(.*?);");
            Matcher implMatcher = placeHolderImpl.matcher(implChain);
            if (implMatcher.find()) {
                String replacement = implMatcher.group(1).trim();
                abstractChain = abstractChain.replace("{{" + holder + "}}", replacement);
                continue;
            }
            throw new ParseException("missing implementation of {{" + holder + "}} in expression \r\n" + implChain);
        }
        return abstractChain;
    }

    public static boolean isAbstractChain(String elStr) {
        return Pattern.compile(REGEX_ABSTRACT_HOLDER).matcher(elStr).find();
    }

    public static String normalize(String elStr) {
        return elStr.replace("'", "\"").replaceAll("\\s", "").replaceFirst(";*$", ";");
    }
}

