/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.slot;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.lang.Tuple;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.yomahub.liteflow.exception.NoSuchContextBeanException;
import com.yomahub.liteflow.exception.NullParamException;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.entity.CmpStep;
import com.yomahub.liteflow.flow.id.IdGeneratorHolder;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Slot {
    private static final LFLog LOG = LFLoggerManager.getLogger(Slot.class);
    private static final String REQUEST = "_request";
    private static final String RESPONSE = "_response";
    private static final String CHAIN_ID = "_chain_id";
    private static final String CHAIN_INSTANCE = "_chain_instance";
    private static final String SWITCH_NODE_PREFIX = "_switch_";
    private static final String IF_NODE_PREFIX = "_if_";
    private static final String AND_OR_PREFIX = "_and_or_";
    private static final String NOT_PREFIX = "_not_";
    private static final String FOR_PREFIX = "_for_";
    private static final String WHILE_PREFIX = "_while_";
    private static final String ITERATOR_PREFIX = "_iterator_";
    private static final String BREAK_PREFIX = "_break_";
    private static final String NODE_INPUT_PREFIX = "_input_";
    private static final String NODE_OUTPUT_PREFIX = "_output_";
    private static final String CHAIN_REQ_PREFIX = "_chain_req_";
    private static final String REQUEST_ID = "_req_id";
    private static final String EXCEPTION = "_exception";
    private static final String SUB_EXCEPTION_PREFIX = "_sub_exception_";
    private static final String PRIVATE_DELIVERY_PREFIX = "_private_d_";
    private final Deque<CmpStep> executeSteps = new ConcurrentLinkedDeque<CmpStep>();
    private String executeStepsStr;
    private final Deque<CmpStep> rollbackSteps = new ConcurrentLinkedDeque<CmpStep>();
    private String rollbackStepsStr;
    protected ConcurrentHashMap<String, Object> metaDataMap = new ConcurrentHashMap();
    private List<Tuple> contextBeanList;
    private static final TransmittableThreadLocal<Deque<Condition>> conditionStack = new TransmittableThreadLocal<Deque<Condition>>(){

        protected Deque<Condition> initialValue() {
            return new ConcurrentLinkedDeque<Condition>();
        }

        public Deque<Condition> copy(Deque<Condition> parentValue) {
            return new ConcurrentLinkedDeque<Condition>(parentValue);
        }

        protected Deque<Condition> childValue(Deque<Condition> parentValue) {
            return this.copy(parentValue);
        }
    };
    private Boolean routeResult;
    private List<String> timeoutItemList;

    public Slot() {
    }

    public Slot(List<Tuple> contextBeanList) {
        this.contextBeanList = contextBeanList;
    }

    private boolean hasMetaData(String key) {
        return this.metaDataMap.containsKey(key);
    }

    private <T> void putThreadMetaDataMap(String key, T t) {
        String threadKey = StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{key, Thread.currentThread().getId()});
        this.putMetaDataMap(threadKey, t);
    }

    private <T> T getThreadMetaData(String key) {
        String threadKey = StrUtil.format((CharSequence)"{}_{}", (Object[])new Object[]{key, Thread.currentThread().getId()});
        return (T)this.metaDataMap.get(threadKey);
    }

    private <T> void putMetaDataMap(String key, T t) {
        if (ObjectUtil.isNull(t)) {
            throw new NullParamException("data slot can't accept null param");
        }
        this.metaDataMap.put(key, t);
    }

    public <T> T getInput(String nodeId) {
        return (T)this.metaDataMap.get(NODE_INPUT_PREFIX + nodeId);
    }

    public <T> T getOutput(String nodeId) {
        return (T)this.metaDataMap.get(NODE_OUTPUT_PREFIX + nodeId);
    }

    public <T> void setInput(String nodeId, T t) {
        this.putMetaDataMap(NODE_INPUT_PREFIX + nodeId, t);
    }

    public <T> void setOutput(String nodeId, T t) {
        this.putMetaDataMap(NODE_OUTPUT_PREFIX + nodeId, t);
    }

    public <T> T getResponseData() {
        return (T)this.metaDataMap.get(RESPONSE);
    }

    public <T> void setResponseData(T t) {
        this.putMetaDataMap(RESPONSE, t);
    }

    public <T> T getChainReqData(String chainId) {
        String key = CHAIN_REQ_PREFIX + chainId;
        if (this.hasMetaData(key)) {
            return (T)this.metaDataMap.get(key);
        }
        return null;
    }

    public synchronized <T> void setChainReqData(String chainId, T t) {
        String key = CHAIN_REQ_PREFIX + chainId;
        this.putMetaDataMap(key, t);
    }

    public <T> T getChainReqDataFromQueue(String chainId) {
        String key = CHAIN_REQ_PREFIX + chainId;
        if (this.hasMetaData(key)) {
            Queue queue = (Queue)this.metaDataMap.get(key);
            return (T)queue.poll();
        }
        return null;
    }

    public synchronized <T> void setChainReqData2Queue(String chainId, T t) {
        String key = CHAIN_REQ_PREFIX + chainId;
        if (this.hasMetaData(key)) {
            Queue queue = (Queue)this.metaDataMap.get(key);
            queue.offer(t);
        } else {
            this.putMetaDataMap(key, new ConcurrentLinkedQueue(ListUtil.toList((Object[])new Object[]{t})));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setPrivateDeliveryData(String nodeId, T t) {
        String privateDKey = PRIVATE_DELIVERY_PREFIX + nodeId;
        Slot slot = this;
        synchronized (slot) {
            if (this.metaDataMap.containsKey(privateDKey)) {
                Queue queue = (Queue)this.metaDataMap.get(privateDKey);
                queue.add(t);
            } else {
                ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue<T>();
                queue.add(t);
                this.putMetaDataMap(privateDKey, queue);
            }
        }
    }

    public <T> Queue<T> getPrivateDeliveryQueue(String nodeId) {
        String privateDKey = PRIVATE_DELIVERY_PREFIX + nodeId;
        if (this.metaDataMap.containsKey(privateDKey)) {
            return (Queue)this.metaDataMap.get(privateDKey);
        }
        return null;
    }

    public <T> T getPrivateDeliveryData(String nodeId) {
        String privateDKey = PRIVATE_DELIVERY_PREFIX + nodeId;
        if (this.metaDataMap.containsKey(privateDKey)) {
            Queue queue = (Queue)this.metaDataMap.get(privateDKey);
            return (T)queue.poll();
        }
        return null;
    }

    public <T> void setSwitchResult(String key, T t) {
        this.putThreadMetaDataMap(SWITCH_NODE_PREFIX + key, t);
    }

    public <T> T getSwitchResult(String key) {
        return this.getThreadMetaData(SWITCH_NODE_PREFIX + key);
    }

    public void setIfResult(String key, boolean result) {
        this.putThreadMetaDataMap(IF_NODE_PREFIX + key, result);
    }

    public Boolean getIfResult(String key) {
        return (Boolean)this.getThreadMetaData(IF_NODE_PREFIX + key);
    }

    public void setAndOrResult(String key, boolean result) {
        this.putThreadMetaDataMap(AND_OR_PREFIX + key, result);
    }

    public Boolean getAndOrResult(String key) {
        return (Boolean)this.getThreadMetaData(AND_OR_PREFIX + key);
    }

    public void setNotResult(String key, boolean result) {
        this.putThreadMetaDataMap(NOT_PREFIX + key, result);
    }

    public Boolean getNotResult(String key) {
        return (Boolean)this.getThreadMetaData(NOT_PREFIX + key);
    }

    public void setForResult(String key, int forCount) {
        this.putThreadMetaDataMap(FOR_PREFIX + key, forCount);
    }

    public Integer getForResult(String key) {
        return (Integer)this.getThreadMetaData(FOR_PREFIX + key);
    }

    public void setWhileResult(String key, boolean whileFlag) {
        this.putThreadMetaDataMap(WHILE_PREFIX + key, whileFlag);
    }

    public Boolean getWhileResult(String key) {
        return (Boolean)this.getThreadMetaData(WHILE_PREFIX + key);
    }

    public void setBreakResult(String key, boolean breakFlag) {
        this.putThreadMetaDataMap(BREAK_PREFIX + key, breakFlag);
    }

    public Boolean getBreakResult(String key) {
        return (Boolean)this.getThreadMetaData(BREAK_PREFIX + key);
    }

    public void setIteratorResult(String key, Iterator<?> it) {
        this.putThreadMetaDataMap(ITERATOR_PREFIX + key, it);
    }

    public Iterator<?> getIteratorResult(String key) {
        return (Iterator)this.getThreadMetaData(ITERATOR_PREFIX + key);
    }

    public Condition getCurrentCondition() {
        return (Condition)((Deque)conditionStack.get()).peek();
    }

    public void pushCondition(Condition condition) {
        ((Deque)conditionStack.get()).push(condition);
    }

    public void popCondition() {
        ((Deque)conditionStack.get()).pop();
    }

    @Deprecated
    public void setChainName(String chainName) {
        this.setChainId(chainName);
    }

    @Deprecated
    public String getChainName() {
        return this.getChainId();
    }

    public void setChainId(String chainId) {
        if (!this.hasMetaData(CHAIN_ID)) {
            this.putMetaDataMap(CHAIN_ID, chainId);
        }
    }

    public String getChainId() {
        return (String)this.metaDataMap.get(CHAIN_ID);
    }

    public void addChainInstance(Chain chain) {
        if (!this.hasMetaData(CHAIN_INSTANCE)) {
            this.putMetaDataMap(CHAIN_INSTANCE, ListUtil.toList((Object[])new Chain[]{chain}));
        } else {
            List list = (List)this.metaDataMap.get(CHAIN_INSTANCE);
            list.add(chain);
        }
    }

    public Chain getCurrentChainInstance(String currentChainId) {
        if (this.hasMetaData(CHAIN_INSTANCE)) {
            List list = (List)this.metaDataMap.get(CHAIN_INSTANCE);
            return list.stream().filter(chain -> chain.getId().equals(currentChainId)).findFirst().orElse(null);
        }
        return null;
    }

    public void addStep(CmpStep step) {
        this.executeSteps.add(step);
    }

    public String getExecuteStepStr(boolean withTimeSpent) {
        StringBuilder str = new StringBuilder();
        Iterator<CmpStep> it = this.executeSteps.iterator();
        while (it.hasNext()) {
            CmpStep cmpStep = it.next();
            if (withTimeSpent) {
                str.append(cmpStep.buildStringWithTime());
            } else {
                str.append(cmpStep.buildString());
            }
            if (!it.hasNext()) continue;
            str.append("==>");
        }
        this.executeStepsStr = str.toString();
        return this.executeStepsStr;
    }

    public String getExecuteStepStrWithInstanceId() {
        StringBuilder str = new StringBuilder();
        Iterator<CmpStep> it = this.executeSteps.iterator();
        while (it.hasNext()) {
            CmpStep cmpStep = it.next();
            str.append(cmpStep.buildStringWithInstanceId());
            if (!it.hasNext()) continue;
            str.append("==>");
        }
        this.executeStepsStr = str.toString();
        return this.executeStepsStr;
    }

    public String getExecuteStepStr() {
        return this.getExecuteStepStr(false);
    }

    public void printStep() {
        if (ObjectUtil.isNull((Object)this.executeStepsStr)) {
            this.executeStepsStr = this.getExecuteStepStr(true);
        }
        LOG.info("CHAIN_NAME[{}]\n{}", (Object)this.getChainName(), (Object)this.executeStepsStr);
    }

    public void addRollbackStep(CmpStep step) {
        this.rollbackSteps.add(step);
    }

    public String getRollbackStepStr(boolean withRollbackTimeSpent) {
        StringBuilder str = new StringBuilder();
        Iterator<CmpStep> it = this.rollbackSteps.iterator();
        while (it.hasNext()) {
            CmpStep cmpStep = it.next();
            if (withRollbackTimeSpent) {
                str.append(cmpStep.buildRollbackStringWithTime());
            } else {
                str.append(cmpStep.buildString());
            }
            if (!it.hasNext()) continue;
            str.append("==>");
        }
        this.rollbackStepsStr = str.toString();
        return this.rollbackStepsStr;
    }

    public String getRollbackStepStr() {
        return this.getRollbackStepStr(false);
    }

    public void printRollbackStep() {
        if (ObjectUtil.isNull((Object)this.rollbackStepsStr)) {
            this.rollbackStepsStr = this.getRollbackStepStr(true);
        }
        LOG.info("ROLLBACK_CHAIN_NAME[{}]\n{}", (Object)this.getChainName(), (Object)this.rollbackStepsStr);
    }

    public void generateRequestId() {
        this.metaDataMap.put(REQUEST_ID, IdGeneratorHolder.getInstance().generate());
    }

    public void putRequestId(String requestId) {
        this.metaDataMap.put(REQUEST_ID, requestId);
    }

    public String getRequestId() {
        return (String)this.metaDataMap.get(REQUEST_ID);
    }

    public Deque<CmpStep> getExecuteSteps() {
        return this.executeSteps;
    }

    public Deque<CmpStep> getRollbackSteps() {
        return this.rollbackSteps;
    }

    public Exception getException() {
        return (Exception)this.metaDataMap.get(EXCEPTION);
    }

    public void setException(Exception e) {
        this.putMetaDataMap(EXCEPTION, e);
    }

    public void removeException() {
        this.metaDataMap.remove(EXCEPTION);
    }

    public Exception getSubException(String chainId) {
        return (Exception)this.metaDataMap.get(SUB_EXCEPTION_PREFIX + chainId);
    }

    public List<Tuple> getContextBeanList() {
        return this.contextBeanList;
    }

    public <T> T getContextBean(Class<T> contextBeanClazz) {
        Tuple contextTuple = this.contextBeanList.stream().filter(tuple -> contextBeanClazz.isAssignableFrom(tuple.get(1).getClass())).findFirst().orElse(null);
        if (contextTuple == null) {
            this.contextBeanList.forEach(o -> LOG.info("ChainId[{}], Context class:{},Request class:{}", this.getChainId(), o.getClass().getName(), contextBeanClazz.getName()));
            throw new NoSuchContextBeanException("this type is not in the context type passed in");
        }
        return (T)contextTuple.get(1);
    }

    public <T> T getContextBean(String contextBeanKey) {
        Tuple contextTuple = this.contextBeanList.stream().filter(tuple -> tuple.get(0).equals(contextBeanKey)).findFirst().orElse(null);
        if (contextTuple == null) {
            this.contextBeanList.forEach(o -> LOG.info("ChainId[{}], Context class:{},Request contextBeanKey:{}", this.getChainId(), o.getClass().getName(), contextBeanKey));
            throw new NoSuchContextBeanException("this context key is not defined");
        }
        return (T)contextTuple.get(1);
    }

    public <T> T getFirstContextBean() {
        Class<?> firstContextBeanClazz = this.getContextBeanList().get(0).get(1).getClass();
        return (T)this.getContextBean(firstContextBeanClazz);
    }

    public Boolean getRouteResult() {
        return this.routeResult;
    }

    public void setRouteResult(Boolean routeResult) {
        this.routeResult = routeResult;
    }

    public void addTimeoutItem(String executorItem) {
        if (CollectionUtil.isEmpty(this.timeoutItemList)) {
            this.timeoutItemList = new ArrayList<String>();
        }
        this.timeoutItemList.add(executorItem);
    }

    public List<String> getTimeoutItemList() {
        return this.timeoutItemList;
    }
}

