/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.script.validator;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.common.entity.ValidationResp;
import com.yomahub.liteflow.enums.ScriptTypeEnum;
import com.yomahub.liteflow.log.LFLog;
import com.yomahub.liteflow.log.LFLoggerManager;
import com.yomahub.liteflow.script.ScriptExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class ScriptValidator {
    private static final LFLog LOG = LFLoggerManager.getLogger(ScriptValidator.class);
    private static Map<ScriptTypeEnum, ScriptExecutor> scriptExecutors;

    private static ValidationResp validateScript(String script, ScriptTypeEnum scriptType) {
        if (scriptExecutors.isEmpty()) {
            String errorMsg = "The loaded script modules not found.";
            return ValidationResp.fail(new RuntimeException(errorMsg));
        }
        if (scriptType != null && !scriptExecutors.containsKey((Object)scriptType)) {
            String errorMsg = StrUtil.format((CharSequence)"Specified script language {} was not found.", (Object[])new Object[]{scriptType});
            return ValidationResp.fail(new RuntimeException(errorMsg));
        }
        if (scriptExecutors.size() > 1 && scriptType == null) {
            String errorMsg = "The loaded script modules more than 1. Please specify the script language.";
            return ValidationResp.fail(new RuntimeException(errorMsg));
        }
        ScriptExecutor scriptExecutor = scriptType != null ? scriptExecutors.get((Object)scriptType) : scriptExecutors.values().iterator().next();
        try {
            scriptExecutor.compile(script);
        }
        catch (Exception e) {
            return ValidationResp.fail(e);
        }
        return ValidationResp.success();
    }

    public static boolean validate(String script) {
        return ScriptValidator.validateScript(script, null).isSuccess();
    }

    public static ValidationResp validateWithEx(String script) {
        return ScriptValidator.validateScript(script, null);
    }

    public static boolean validate(String script, ScriptTypeEnum scriptType) {
        return ScriptValidator.validateScript(script, scriptType).isSuccess();
    }

    public static ValidationResp validateWithEx(String script, ScriptTypeEnum scriptType) {
        return ScriptValidator.validateScript(script, scriptType);
    }

    public static boolean validate(Map<ScriptTypeEnum, String> scripts) {
        for (Map.Entry<ScriptTypeEnum, String> script : scripts.entrySet()) {
            if (ScriptValidator.validate(script.getValue(), script.getKey())) continue;
            return false;
        }
        return true;
    }

    static {
        ArrayList scriptExecutorList = new ArrayList();
        scriptExecutors = new HashMap<ScriptTypeEnum, ScriptExecutor>();
        ServiceLoader.load(ScriptExecutor.class).forEach(scriptExecutorList::add);
        scriptExecutorList.stream().peek(ScriptExecutor::init).forEach(scriptExecutor -> scriptExecutors.put(scriptExecutor.scriptType(), (ScriptExecutor)scriptExecutor));
    }
}

