/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.parallel.LoopFutureObj;
import com.yomahub.liteflow.meta.LiteflowMetaOperator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public abstract class LoopCondition
extends Condition {
    private boolean parallel = false;
    private String threadPoolExecutorClass;

    protected Executable getBreakItem() {
        return this.getExecutableOne("BREAK_KEY");
    }

    public void setBreakItem(Executable breakNode) {
        this.addExecutable("BREAK_KEY", breakNode);
    }

    protected Executable getDoExecutor() {
        return this.getExecutableOne("DO_KEY");
    }

    public void setDoExecutor(Executable executable) {
        this.addExecutable("DO_KEY", executable);
    }

    public String getThreadPoolExecutorClass() {
        return this.threadPoolExecutorClass;
    }

    public void setThreadPoolExecutorClass(String threadPoolExecutorClass) {
        this.threadPoolExecutorClass = threadPoolExecutorClass;
    }

    protected void setLoopIndex(Executable executableItem, int index) {
        LoopCondition thisCondition = this;
        LiteflowMetaOperator.getNodes(executableItem).forEach(node -> node.setLoopIndex(thisCondition, index));
    }

    protected void setCurrLoopObject(Executable executableItem, Object obj) {
        LoopCondition thisCondition = this;
        LiteflowMetaOperator.getNodes(executableItem).forEach(node -> node.setCurrLoopObject(thisCondition, obj));
    }

    protected void removeLoopIndex(Executable executableItem) {
        LiteflowMetaOperator.getNodes(executableItem).forEach(Node::removeLoopIndex);
    }

    protected void removeCurrLoopObject(Executable executableItem) {
        LiteflowMetaOperator.getNodes(executableItem).forEach(Node::removeCurrLoopObject);
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    protected void handleFutureList(List<CompletableFuture<LoopFutureObj>> futureList) throws Exception {
        CompletableFuture<Void> resultCompletableFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
        resultCompletableFuture.get();
        for (CompletableFuture<LoopFutureObj> future : futureList) {
            LoopFutureObj loopFutureObj = future.get();
            if (loopFutureObj.isSuccess()) continue;
            throw loopFutureObj.getEx();
        }
    }

    public class LoopParallelSupplier
    implements Supplier<LoopFutureObj> {
        private final Executable executableItem;
        private final String currChainId;
        private final Integer slotIndex;
        private final Integer loopIndex;
        private final Object itObj;

        public LoopParallelSupplier(Executable executableItem, String currChainId, Integer slotIndex, Integer loopIndex) {
            this.executableItem = executableItem;
            this.currChainId = currChainId;
            this.slotIndex = slotIndex;
            this.loopIndex = loopIndex;
            this.itObj = null;
        }

        public LoopParallelSupplier(Executable executableItem, String currChainId, Integer slotIndex, Integer loopIndex, Object itObj) {
            this.executableItem = executableItem;
            this.currChainId = currChainId;
            this.slotIndex = slotIndex;
            this.loopIndex = loopIndex;
            this.itObj = itObj;
        }

        @Override
        public LoopFutureObj get() {
            try {
                this.executableItem.setCurrChainId(this.currChainId);
                LoopCondition.this.setLoopIndex(this.executableItem, this.loopIndex);
                if (this.itObj != null) {
                    LoopCondition.this.setCurrLoopObject(this.executableItem, this.itObj);
                }
                this.executableItem.execute(this.slotIndex);
                return LoopFutureObj.success(this.executableItem.getId());
            }
            catch (Exception e) {
                return LoopFutureObj.fail(this.executableItem.getId(), e);
            }
        }
    }
}

