package com.yodo1ads.plugin.vungle;


import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

import com.vungle.warren.AdConfig;
import com.vungle.warren.InitCallback;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.Vungle;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.ValidateUtils;
import com.yodo1.sdk.kit.YLog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by yodo1 on 2016/4/21.
 */
public class AdvertCoreVungle {
    private static AdvertCoreVungle instance;



    public boolean isInit = false;
    public boolean validateAdsAdapter = false;

    private AdvertCoreVungle() {
    }

    public static AdvertCoreVungle getInstance() {
        if (instance == null) {
            instance = new AdvertCoreVungle();
        }
        return instance;
    }

    public void init(final Activity activity) {
        if (isInit) {
            YLog.d("Vungle has Init");
            return;
        }
        isInit = true;


        AdConfigVungle.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                AdConfigVungle.CHANNEL_CODE, AdConfigVungle.KEY_VUNGLE_APP_ID);

        if (TextUtils.isEmpty(AdConfigVungle.APP_ID)) {
            AdConfigVungle.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                    AdConfigVungle.CHANNEL_CODE, AdConfigVungle.KEY_VUNGLE_APP_ID);

        }
        AdConfigVungle.PLACEMENTID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                AdConfigVungle.CHANNEL_CODE, AdConfigVungle.VUNGLE_PLACEMENTID);
        AdConfigVungle.INTERSTITIAL_PLACEMENTID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                AdConfigVungle.CHANNEL_CODE, AdConfigVungle.VUNGLE_INTERSTITIAL_PLACEMENTID);

        if (TextUtils.isEmpty(AdConfigVungle.APP_ID)) {
            YLog.i("Vungle  appid  is null");
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Vungle.init( AdConfigVungle.APP_ID, activity.getApplicationContext(), new InitCallback() {
                    @Override
                    public void onSuccess() {
                        YLog.d("Vungle init success");

                    }

                    @Override
                    public void onError(Throwable throwable) {
                        YLog.d("Vugle init onFailure : " + throwable.getCause());
                    }

                    @Override
                    public void onAutoCacheAdAvailable(String s) {
                        YLog.d("Vugle init onAutoCacheAdAvailable : " + s);
                    }
                });

            }
        });

    }

    public void validateAdsAdapter(Activity activity) {
        if (validateAdsAdapter) {
            return;
        }
        validateAdsAdapter = true;
        List<String> vungleActivities = Arrays.asList(new String[]{"com.vungle.warren.ui.VungleActivity"
        ,"com.vungle.warren.ui.VungleWebViewActivity"
        ,"com.vungle.warren.ui.VungleFlexViewActivity"});
        ValidateUtils.validateActivities(activity, vungleActivities);
    }



}
