package com.yodo1ads.plugin.oneway;

import android.app.Activity;
import android.text.TextUtils;

import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.ValidateUtils;
import com.yodo1.sdk.kit.YLog;

import java.util.Arrays;
import java.util.List;

import mobi.oneway.sdk.OnewaySdk;

/**
 * Created by yodo1 on 17/9/1.
 */
public class AdvertCoreOneway {

    private static AdvertCoreOneway instance;

    public static AdvertCoreOneway getInstance(){
        if(instance == null){
            instance = new AdvertCoreOneway();
        }
        return instance;
    }

    private boolean isInit = false;

    public  void init(final Activity activity){
        if(!isInit ) {
            AdConfigOneway.PUBLISH_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigOneway.CHANNEL_CODE
                    , AdConfigOneway.KEY_ONEWAY_PUBLISH_ID);

            if(TextUtils.isEmpty(AdConfigOneway.PUBLISH_ID)) {
                YLog.e("AdvertAdapterOneway, video PUBLISH_ID is null");
                return;
            }

//            OnewaySdk.setDebugMode(true);
            OnewaySdk.configure(activity, AdConfigOneway.PUBLISH_ID);
            isInit = true;
        }

    }

    private boolean validate = false;
    public  void validateAdsAdapter(Activity activity){
        if(!validate) {
            List<String> onewayActivities = Arrays.asList(new String[] { "mobi.oneway.sdk.AdShowActivity" });
            ValidateUtils.validateActivities(activity,onewayActivities);
            validate = true;
        }

    }
}
