package com.yodo1ads.adapter.video;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.unity3d.ads.IUnityAdsListener;
import com.unity3d.ads.UnityAds;
import com.yodo1ads.plugin.unityads.AdConfigUnityads;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.ValidateUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdapterunityads extends AdVideoAdapterBase {

    private Yodo1VideoCallback videoCallback; //视频回调
    private Yodo1VideoReloadCallback reloadCallback; //视频预加载回调

    private boolean isReaday = false;

    private IUnityAdsListener unityAdsListener = new IUnityAdsListener() {
        @Override
        public void onUnityAdsReady(String s) {
            isReaday = true;

            if(reloadCallback != null){
                reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FINISH,getAdvertCode());
            }
        }

        @Override
        public void onUnityAdsStart(String s) {
            YLog.d("Advert , Unityads  Video Started!");
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onUnityAdsFinish(String s, UnityAds.FinishState finishState) {
            if(finishState == UnityAds.FinishState.COMPLETED) {
                YLog.d("Advert , Unityads  Video Completed!");
                if(videoCallback != null){
                    videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, getAdvertCode());
                }
            }

            YLog.d("Advert , Unityads  Video  onUnityAdsFinish!");

            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onUnityAdsError(UnityAds.UnityAdsError unityAdsError, String s) {
            YLog.i("Advert , Unityads UnityAdsError ：" + unityAdsError + "  " + s);
            if(reloadCallback != null){
                reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FAILED,getAdvertCode());
            }
        }

    };
    @Override
    public void showVideoAdvert(Activity activity, Yodo1VideoCallback callback) {
        this.videoCallback = callback;
        YLog.d("Advert , Unityads  showVideoAdvert");
        if (TextUtils.isEmpty(AdConfigUnityads.APP_ID)){
            YLog.i("Unityads  APPID  is null");
            videoCallback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
            return;
        }



        if(UnityAds.isReady()) {

            UnityAds.show(activity);

        }else {
            videoCallback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

        isReaday = false;
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        YLog.d("Advert , Unityads  reloadVideoAdvert");
        if (TextUtils.isEmpty(AdConfigUnityads.APP_ID)){
            YLog.i("Unityads  APPID  is null");
            return;
        }
        reloadCallback.onReload(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD,getAdvertCode());
        UnityAds.initialize(activity,AdConfigUnityads.APP_ID,unityAdsListener,false);

    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return isReaday;
    }

    @Override
    public String getAdvertCode() {
        return AdConfigUnityads.CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
        List<String> unityAdsActivities = Arrays.asList(new String[] { "com.unity3d.ads.adunit.AdUnitActivity", "com.unity3d.ads.adunit.AdUnitSoftwareActivity" });
        ValidateUtils.validateActivities(activity,unityAdsActivities);
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

        AdConfigUnityads.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigUnityads.CHANNEL_CODE
                , AdConfigUnityads.KEY_UNITYADS_APP_ID);

        if (TextUtils.isEmpty(AdConfigUnityads.APP_ID)){
            YLog.i("Unityads  APPID  is null");
            return;
        }
        YLog.d("Advert , Unityads  onCreate  ： " + AdConfigUnityads.APP_ID);
        UnityAds.setDebugMode(false);
        UnityAds.setListener(unityAdsListener);

    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
