package com.yodo1ads.adapter.interstitial;


import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.content.res.Configuration;
import android.text.TextUtils;

import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdConstant;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTFullScreenVideoAd;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;
import com.yodo1ads.plugin.toutiao.AdConfigToutiao;
import com.yodo1ads.plugin.toutiao.AdvertCoreToutiao;


/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdaptertoutiao extends AdInterstitialAdapterBase {

    private TTAdNative mTTAdNative;
    private Yodo1InterstitialCallback adCallBack;
    private Yodo1InterstitialReloadCallback callback;
    private TTFullScreenVideoAd mttFullVideoAd;
    private int orientation;
    private String interstitial_id;

    private TTAdNative.FullScreenVideoAdListener adLister = new TTAdNative.FullScreenVideoAdListener(){

        @Override
        public void onError(int code, String message) {
            YLog.e("toutiao reloadInterstitialAdvert onError code==" + code + "  message==" + message);
            if(callback != null){
                callback.onResult(Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FAILED, getAdvertCode());
            }
        }

        @Override
        public void onFullScreenVideoAdLoad(TTFullScreenVideoAd ttFullScreenVideoAd) {
            mttFullVideoAd = ttFullScreenVideoAd;
            mttFullVideoAd.setFullScreenVideoAdInteractionListener(new TTFullScreenVideoAd.FullScreenVideoAdInteractionListener() {

                @Override
                public void onAdShow() {
                    YLog.i( "头条插屏广告show");
                    if(adCallBack != null){
                        adCallBack.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
                    }
                }

                @Override
                public void onAdVideoBarClick() {
                    YLog.i( "头条插屏广告被点击");
                    if(adCallBack != null){
                        adCallBack.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLICK, getAdvertCode());
                    }
                }

                @Override
                public void onAdClose() {
                    YLog.i( "头条插屏广告广告关闭");
                    if(adCallBack != null){
                        adCallBack.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
                    }
                }

                @Override
                public void onVideoComplete() {
                    YLog.i( "头条插屏广告广告播放完成");
//                    if(adCallBack != null){
//                        adCallBack.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
//                    }
                }

                @Override
                public void onSkippedVideo() {
                    YLog.i( "头条插屏广告广告跳过");
//                    if(adCallBack != null){
//                        adCallBack.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
//                    }
                }

            });
        }

        @Override
        public void onFullScreenVideoCached() {

        }
    };


    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1InterstitialCallback callback) {
        adCallBack = callback;
        if(TextUtils.isEmpty(interstitial_id)){
            YLog.e("toutiao  interstitial_id is null");
            callback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未获取到在线参数，插屏广告位id", getAdvertCode());
            return;
        }
        if(mttFullVideoAd != null) {
            mttFullVideoAd.showFullScreenVideoAd(activity);
            mttFullVideoAd = null;
        } else {
            callback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1InterstitialReloadCallback callback) {
        this.callback = callback;
        if(TextUtils.isEmpty(interstitial_id)){
            YLog.e("toutiao  interstitial_id is null");
            return;
        }
        AdSlot adSlot = new AdSlot.Builder()
                .setCodeId(interstitial_id)
                .setSupportDeepLink(true)
                .setImageAcceptedSize(1080, 1920)
                .setOrientation(orientation)//必填参数，期望视频的播放方向：TTAdConstant.HORIZONTAL 或 TTAdConstant.VERTICAL
                .build();
        //调用插屏广告异步请求接口
        mTTAdNative.loadFullScreenVideoAd(adSlot, adLister);
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return mttFullVideoAd != null;
    }

    @Override
    public String getAdvertCode() {
        return AdConfigToutiao.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }


    @Override
    public void onCreate(Activity activity) {
        interstitial_id = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigToutiao.CHANNEL_CODE
                , AdConfigToutiao.KEY_INTERSTITIAL_ID);
        if(TextUtils.isEmpty(interstitial_id)){
            YLog.e("toutiao  interstitial_id is null");
            return;
        }

        // 判断Android当前的屏幕是横屏还是竖屏。横竖屏判断
        if (activity.getResources().getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT) {
            //竖屏
            orientation = TTAdConstant.VERTICAL;
        } else {
            //横屏
            orientation = TTAdConstant.HORIZONTAL;
        }

        //创建TTAdNative对象,用于调用广告请求接口
        mTTAdNative = AdvertCoreToutiao.getAdManager(activity).createAdNative(activity);
    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
