package com.yodo1ads.adapter.interstitial;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import com.qq.e.ads.cfg.VideoOption;
import com.qq.e.ads.nativ.ADSize;
import com.qq.e.ads.nativ.NativeExpressAD;
import com.qq.e.ads.nativ.NativeExpressADView;
import com.qq.e.comm.util.AdError;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1ads.plugin.gdt.AdConfigGdt;
import com.yodo1.sdk.kit.YLog;

import java.util.List;

/**
 * Created by yodo1 on 2016/3/23.
 */
public class AdvertAdaptergdt extends AdInterstitialAdapterBase {
    private boolean isLoaded = false; //是否成功加载
    private Yodo1InterstitialCallback intersititalCallback; //插屏回调
    private Yodo1InterstitialReloadCallback callback;
    private NativeExpressAD nativeExpressAD;
    private NativeExpressADView nativeExpressADView;
    private RelativeLayout container;
    private  ADSize adSize;

    private  NativeExpressAD.NativeExpressADListener adListener = new  NativeExpressAD.NativeExpressADListener() {
        @Override
        public void onNoAD(AdError adError) {
            isLoaded = false;
            YLog.e("Advert, Gdt Interstitial onNoAD ... " + adError);
        }

        @Override
        public void onADLoaded(List<NativeExpressADView> list) {
            if(callback != null){
                callback.onResult(Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FINISH, getAdvertCode());
            }
            isLoaded = true;
            YLog.i("Advert, Gdt Interstitial onADReceive ... ");
            if (nativeExpressADView != null) {
                nativeExpressADView.destroy();
            }

            if (container.getVisibility() != View.VISIBLE) {
                container.setVisibility(View.VISIBLE);
            }

            if (container.getChildCount() > 0) {
                container.removeAllViews();
            }

            nativeExpressADView = list.get(0);
            // 广告可见才会产生曝光，否则将无法产生收益。

        }

        @Override
        public void onRenderFail(NativeExpressADView nativeExpressADView) {

        }

        @Override
        public void onRenderSuccess(NativeExpressADView nativeExpressADView) {

        }

        @Override
        public void onADExposure(NativeExpressADView nativeExpressADView) {
            YLog.i("Advert Gdt onADOpened ...");
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onADClicked(NativeExpressADView nativeExpressADView) {
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onADClosed(NativeExpressADView nativeExpressADView) {
            YLog.i("Advert Gdt onAdClose ...");
            if (container != null && container.getChildCount() > 0) {
                container.removeAllViews();
                container.setVisibility(View.GONE);
            }


            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onADLeftApplication(NativeExpressADView nativeExpressADView) {

        }

        @Override
        public void onADOpenOverlay(NativeExpressADView nativeExpressADView) {

        }

        @Override
        public void onADCloseOverlay(NativeExpressADView nativeExpressADView) {

        }


    };

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1InterstitialCallback callback) {
        YLog.i("Advert, showIntersititalAdvert , Gdt");
        this.intersititalCallback = callback;

        if (nativeExpressADView !=null && isLoaded){
            nativeExpressADView.setAdSize(adSize);

            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams
                    (ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            params.addRule(RelativeLayout.CENTER_IN_PARENT, RelativeLayout.TRUE);//水平居中
            nativeExpressADView.setLayoutParams(params);
            container.addView(nativeExpressADView);
            nativeExpressADView.render();
        }else {
            if(intersititalCallback != null){
                intersititalCallback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
            }
        }

        isLoaded = false;
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1InterstitialReloadCallback callback) {
        isLoaded = false;
        this.callback = callback;
        if (TextUtils.isEmpty( AdConfigGdt.INTERSTITIAL_ID) && TextUtils.isEmpty( AdConfigGdt.APP_ID)){
            YLog.i("GDT appid或者插屏ID为空 ");
            return ;
        }
        /**
         *  如果选择支持视频的模版样式，请使用{@link Constants#NativeExpressSupportVideoPosID}
         */
        nativeExpressAD = new NativeExpressAD(activity, adSize, AdConfigGdt.APP_ID, AdConfigGdt.INTERSTITIAL_ID, adListener); // 这里的Context必须为Activity
        nativeExpressAD.setVideoOption(new VideoOption.Builder()
                .setAutoPlayPolicy(VideoOption.AutoPlayPolicy.WIFI) // 设置什么网络环境下可以自动播放视频
                .setAutoPlayMuted(true) // 设置自动播放视频时，是否静音
                .build()); // setVideoOption是可选的，开发者可根据需要选择是否配置
        nativeExpressAD.loadAD(1);
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return isLoaded;
    }

    @Override
    public String getAdvertCode() {
        return AdConfigGdt.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }


    @Override
    public void onCreate(Activity activity) {
        AdConfigGdt.INTERSTITIAL_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigGdt.CHANNEL_CODE
                , AdConfigGdt.KEY_Gdt_INTERSTITIAL_ID);
        AdConfigGdt.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigGdt.CHANNEL_CODE
                , AdConfigGdt.KEY_Gdt_APP_ID);

//        AdConfigGdt.APP_ID = "1101152570";
//        AdConfigGdt.INTERSTITIAL_ID = "2000629911207832";

        FrameLayout frameLayout = (FrameLayout)activity.findViewById(android.R.id.content);
        container = new RelativeLayout(activity);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams
                (ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        params.addRule(RelativeLayout.CENTER_IN_PARENT, RelativeLayout.TRUE);//水平居中
        container.setLayoutParams(params);
        frameLayout.addView(container);

        if (activity.getResources().getConfiguration().orientation == 1) {
            YLog.i("Advert, showIntersititalAdvert , Gdt   竖屏广告");
            adSize = new ADSize(ADSize.FULL_WIDTH,ADSize.AUTO_HEIGHT);
        }else {
            YLog.i("Advert, showIntersititalAdvert , Gdt   横屏广告");
            adSize = new ADSize(340,ADSize.AUTO_HEIGHT);
        }




    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
// 使用完了每一个NativeExpressADView之后都要释放掉资源
        if (nativeExpressADView != null) {
            nativeExpressADView.destroy();
        }
    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
