/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.applovin;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkSettings;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.EBannerSize;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

class AppLovinAdapter
extends AbstractAdapter {
    private static final String VERSION = "4.2.0";
    private static final String ZONE_ID = "zoneId";
    private static final String SDK_KEY = "sdkKey";
    private Activity mActivity;
    private AppLovinSdk mAppLovinSdk;
    private Boolean mDidInitSdk = false;
    private ALBannerListener mBNAdListener;
    private ConcurrentHashMap<String, AppLovinInterstitialAdDialog> mZoneIdToIsAdDialog;
    private ConcurrentHashMap<String, AppLovinAd> mZoneIdToIsAd;
    private ConcurrentHashMap<String, AppLovinIncentivizedInterstitial> mZoneIdToRvAd;
    private ConcurrentHashMap<String, InterstitialSmashListener> mZoneIdToIsListener;
    private ConcurrentHashMap<String, RewardedVideoSmashListener> mZoneIdToRvListener;
    private Boolean mConsentCollectingUserData = null;
    private AppLovinAdView mLastAdView;

    public static AppLovinAdapter startAdapter(String string2) {
        return new AppLovinAdapter(string2);
    }

    private AppLovinAdapter(String string2) {
        super(string2);
        this.mAllBannerSmashes = new CopyOnWriteArrayList();
        this.mBNAdListener = new ALBannerListener();
        this.mZoneIdToIsAd = new ConcurrentHashMap();
        this.mZoneIdToIsAdDialog = new ConcurrentHashMap();
        this.mZoneIdToRvAd = new ConcurrentHashMap();
        this.mZoneIdToIsListener = new ConcurrentHashMap();
        this.mZoneIdToRvListener = new ConcurrentHashMap();
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        IntegrationData integrationData = new IntegrationData("AppLovin", VERSION);
        integrationData.activities = new String[]{"com.applovin.adview.AppLovinInterstitialActivity", "com.applovin.adview.AppLovinConfirmationActivity"};
        return integrationData;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return "8.0.1";
    }

    public void onResume(Activity activity) {
        this.mActivity = activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConsent(boolean bl2) {
        AppLovinAdapter appLovinAdapter = this;
        synchronized (appLovinAdapter) {
            if (this.mDidInitSdk.booleanValue()) {
                AppLovinPrivacySettings.setHasUserConsent((boolean)bl2, (Context)this.mActivity);
            } else {
                this.mConsentCollectingUserData = bl2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSdk(Activity activity, String string2) {
        AppLovinAdapter appLovinAdapter = this;
        synchronized (appLovinAdapter) {
            if (!this.mDidInitSdk.booleanValue()) {
                AppLovinSdkSettings appLovinSdkSettings = new AppLovinSdkSettings();
                boolean bl2 = false;
                try {
                    bl2 = this.isAdaptersDebugEnabled();
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                appLovinSdkSettings.setVerboseLogging(bl2);
                this.mAppLovinSdk = AppLovinSdk.getInstance((String)string2, (AppLovinSdkSettings)appLovinSdkSettings, (Context)activity);
                this.mAppLovinSdk.initializeSdk();
                this.mDidInitSdk = true;
                if (this.mConsentCollectingUserData != null) {
                    this.setConsent(this.mConsentCollectingUserData);
                }
            }
        }
    }

    public void initRewardedVideo(final Activity activity, String string2, final String string3, JSONObject jSONObject, final RewardedVideoSmashListener rewardedVideoSmashListener) {
        final String string4 = jSONObject.optString(SDK_KEY);
        if (TextUtils.isEmpty((CharSequence)string4)) {
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
            return;
        }
        final String string5 = this.getZoneId(jSONObject);
        this.mActivity = activity;
        if (rewardedVideoSmashListener != null) {
            this.mZoneIdToRvListener.put(string5, rewardedVideoSmashListener);
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppLovinAdapter.this.initSdk(activity, string4);
                AppLovinIncentivizedInterstitial appLovinIncentivizedInterstitial = null;
                appLovinIncentivizedInterstitial = !TextUtils.isEmpty((CharSequence)string5) ? AppLovinIncentivizedInterstitial.create((String)string5, (AppLovinSdk)AppLovinAdapter.this.mAppLovinSdk) : AppLovinIncentivizedInterstitial.create((AppLovinSdk)AppLovinAdapter.this.mAppLovinSdk);
                AppLovinAdapter.this.mZoneIdToRvAd.put(string5, appLovinIncentivizedInterstitial);
                appLovinIncentivizedInterstitial.setUserIdentifier(string3);
                appLovinIncentivizedInterstitial.preload(new AppLovinAdLoadListener(){

                    public void adReceived(AppLovinAd appLovinAd) {
                        if (rewardedVideoSmashListener != null) {
                            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(true);
                        }
                    }

                    public void failedToReceiveAd(int n2) {
                        if (rewardedVideoSmashListener != null) {
                            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
                        }
                    }
                });
            }
        });
    }

    public void fetchRewardedVideo(JSONObject jSONObject) {
        final String string2 = this.getZoneId(jSONObject);
        if (this.mZoneIdToRvAd.containsKey(string2)) {
            this.mZoneIdToRvAd.get(string2).preload(new AppLovinAdLoadListener(){

                public void adReceived(AppLovinAd appLovinAd) {
                    if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string2)) {
                        ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string2)).onRewardedVideoAvailabilityChanged(true);
                    }
                }

                public void failedToReceiveAd(int n2) {
                    if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string2)) {
                        ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string2)).onRewardedVideoAvailabilityChanged(false);
                    }
                }
            });
        }
    }

    public void showRewardedVideo(JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        String string2 = this.getZoneId(jSONObject);
        if (!this.mZoneIdToRvAd.containsKey(string2) || !this.mZoneIdToRvAd.get(string2).isAdReadyToDisplay()) {
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
            return;
        }
        this.mZoneIdToRvAd.get(string2).show((Context)this.mActivity, new AppLovinAdRewardListener(){

            public void userRewardVerified(AppLovinAd appLovinAd, Map<String, String> map) {
            }

            public void userOverQuota(AppLovinAd appLovinAd, Map<String, String> map) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "userOverQuota", 1);
            }

            public void userRewardRejected(AppLovinAd appLovinAd, Map<String, String> map) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "userRewardRejected", 1);
            }

            public void validationRequestFailed(AppLovinAd appLovinAd, int n2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "validationRequestFailed " + AppLovinAdapter.this.getErrorString(n2) + "(" + n2 + ")", 1);
            }

            public void userDeclinedToViewAd(AppLovinAd appLovinAd) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "userDeclinedToViewAd", 1);
                String string2 = AppLovinAdapter.this.getZoneId(appLovinAd);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string2)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string2)).onRewardedVideoAdClosed();
                }
            }
        }, new AppLovinAdVideoPlaybackListener(){

            public void videoPlaybackBegan(AppLovinAd appLovinAd) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "videoPlaybackBegan", 1);
                String string2 = AppLovinAdapter.this.getZoneId(appLovinAd);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string2)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string2)).onRewardedVideoAdStarted();
                }
            }

            public void videoPlaybackEnded(AppLovinAd appLovinAd, double d2, boolean bl2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "videoPlaybackEnded ; isFullyWatched: " + bl2, 1);
                String string2 = AppLovinAdapter.this.getZoneId(appLovinAd);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string2)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string2)).onRewardedVideoAdEnded();
                    if (bl2) {
                        ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string2)).onRewardedVideoAdRewarded();
                    }
                }
            }
        }, new AppLovinAdDisplayListener(){

            public void adDisplayed(AppLovinAd appLovinAd) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "adDisplayed", 1);
                String string2 = AppLovinAdapter.this.getZoneId(appLovinAd);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string2)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string2)).onRewardedVideoAdOpened();
                }
            }

            public void adHidden(AppLovinAd appLovinAd) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "adHidden", 1);
                final String string2 = AppLovinAdapter.this.getZoneId(appLovinAd);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string2)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string2)).onRewardedVideoAvailabilityChanged(false);
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string2)).onRewardedVideoAdClosed();
                }
                if (AppLovinAdapter.this.mZoneIdToRvAd.containsKey(string2)) {
                    ((AppLovinIncentivizedInterstitial)AppLovinAdapter.this.mZoneIdToRvAd.get(string2)).preload(new AppLovinAdLoadListener(){

                        public void adReceived(AppLovinAd appLovinAd) {
                            if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string2)) {
                                ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string2)).onRewardedVideoAvailabilityChanged(true);
                            }
                        }

                        public void failedToReceiveAd(int n2) {
                            if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string2)) {
                                ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string2)).onRewardedVideoAvailabilityChanged(false);
                            }
                        }
                    });
                }
            }
        }, new AppLovinAdClickListener(){

            public void adClicked(AppLovinAd appLovinAd) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "adClicked", 1);
                String string2 = AppLovinAdapter.this.getZoneId(appLovinAd);
                if (AppLovinAdapter.this.mZoneIdToRvListener.containsKey(string2)) {
                    ((RewardedVideoSmashListener)AppLovinAdapter.this.mZoneIdToRvListener.get(string2)).onRewardedVideoAdClicked();
                }
            }
        });
    }

    public synchronized boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        String string2 = this.getZoneId(jSONObject);
        return this.mZoneIdToRvAd.containsKey(string2) && this.mZoneIdToRvAd.get(string2).isAdReadyToDisplay();
    }

    private String getZoneId(JSONObject jSONObject) {
        return !TextUtils.isEmpty((CharSequence)jSONObject.optString(ZONE_ID)) ? jSONObject.optString(ZONE_ID) : "";
    }

    private String getZoneId(AppLovinAd appLovinAd) {
        return appLovinAd.getZoneId() != null ? appLovinAd.getZoneId() : "";
    }

    public void initInterstitial(Activity activity, String string2, String string3, JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        String string4 = jSONObject.optString(SDK_KEY);
        if (TextUtils.isEmpty((CharSequence)string4)) {
            this.log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + " initInterstitial empty sdkKey", 3);
            if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"initInterstitial empty sdkKey", (String)"Interstitial"));
            }
            return;
        }
        final String string5 = this.getZoneId(jSONObject);
        this.mActivity = activity;
        this.initSdk(activity, string4);
        AppLovinInterstitialAdDialog appLovinInterstitialAdDialog = AppLovinInterstitialAd.create((AppLovinSdk)this.mAppLovinSdk, (Context)activity);
        this.mZoneIdToIsAdDialog.put(string5, appLovinInterstitialAdDialog);
        if (interstitialSmashListener != null) {
            this.mZoneIdToIsListener.put(string5, interstitialSmashListener);
        }
        appLovinInterstitialAdDialog.setAdClickListener(new AppLovinAdClickListener(){

            public void adClicked(AppLovinAd appLovinAd) {
                if (AppLovinAdapter.this.mZoneIdToIsListener.containsKey(string5)) {
                    ((InterstitialSmashListener)AppLovinAdapter.this.mZoneIdToIsListener.get(string5)).onInterstitialAdClicked();
                }
            }
        });
        appLovinInterstitialAdDialog.setAdDisplayListener(new AppLovinAdDisplayListener(){

            public void adDisplayed(AppLovinAd appLovinAd) {
                if (AppLovinAdapter.this.mZoneIdToIsListener.containsKey(string5)) {
                    ((InterstitialSmashListener)AppLovinAdapter.this.mZoneIdToIsListener.get(string5)).onInterstitialAdOpened();
                    ((InterstitialSmashListener)AppLovinAdapter.this.mZoneIdToIsListener.get(string5)).onInterstitialAdShowSucceeded();
                }
            }

            public void adHidden(AppLovinAd appLovinAd) {
                if (AppLovinAdapter.this.mZoneIdToIsListener.containsKey(string5)) {
                    ((InterstitialSmashListener)AppLovinAdapter.this.mZoneIdToIsListener.get(string5)).onInterstitialAdClosed();
                }
            }
        });
        if (interstitialSmashListener != null) {
            interstitialSmashListener.onInterstitialInitSuccess();
        }
    }

    public void loadInterstitial(JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        final String string2 = this.getZoneId(jSONObject);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.mAppLovinSdk.getAdService().loadNextAdForZoneId(string2, new AppLovinAdLoadListener(){

                public void adReceived(AppLovinAd appLovinAd) {
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Interstitial adReceived zoneId=" + AppLovinAdapter.this.getZoneId(appLovinAd), 1);
                    if (interstitialSmashListener != null) {
                        interstitialSmashListener.onInterstitialAdReady();
                    }
                    AppLovinAdapter.this.mZoneIdToIsAd.put(string2, appLovinAd);
                }

                public void failedToReceiveAd(int n2) {
                    if (interstitialSmashListener != null) {
                        String string22 = AppLovinAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                        interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)string22));
                    }
                }
            });
        } else {
            this.mAppLovinSdk.getAdService().loadNextAd(AppLovinAdSize.INTERSTITIAL, new AppLovinAdLoadListener(){

                public void adReceived(AppLovinAd appLovinAd) {
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Interstitial adReceived", 1);
                    if (interstitialSmashListener != null) {
                        interstitialSmashListener.onInterstitialAdReady();
                    }
                    AppLovinAdapter.this.mZoneIdToIsAd.put(string2, appLovinAd);
                }

                public void failedToReceiveAd(int n2) {
                    if (interstitialSmashListener != null) {
                        String string22 = AppLovinAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                        interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)string22));
                    }
                }
            });
        }
    }

    public void showInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        String string2 = this.getZoneId(jSONObject);
        if (!this.mZoneIdToIsAd.containsKey(string2) || !this.mZoneIdToIsAdDialog.containsKey(string2)) {
            if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
            }
            return;
        }
        this.mZoneIdToIsAdDialog.get(string2).showAndRender(this.mZoneIdToIsAd.get(string2));
    }

    public boolean isInterstitialReady(JSONObject jSONObject) {
        String string2 = this.getZoneId(jSONObject);
        return this.mZoneIdToIsAdDialog.containsKey(string2);
    }

    public void initBanners(final Activity activity, String string2, String string3, JSONObject jSONObject, BannerSmashListener bannerSmashListener) {
        final String string4 = jSONObject.optString(SDK_KEY);
        if (TextUtils.isEmpty((CharSequence)string4)) {
            for (BannerSmashListener bannerSmashListener2 : this.mAllBannerSmashes) {
                if (bannerSmashListener2 == null) continue;
                bannerSmashListener2.onBannerInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Banner"));
            }
            return;
        }
        this.mActivity = activity;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AppLovinAdapter.this.initSdk(activity, string4);
                for (BannerSmashListener bannerSmashListener : AppLovinAdapter.this.mAllBannerSmashes) {
                    if (bannerSmashListener == null) continue;
                    bannerSmashListener.onBannerInitSuccess();
                }
            }
        });
    }

    public void loadBanner(final IronSourceBannerLayout ironSourceBannerLayout, final JSONObject jSONObject, final BannerSmashListener bannerSmashListener) {
        this.mActiveBannerSmash = bannerSmashListener;
        if (ironSourceBannerLayout != null) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            AppLovinAdView appLovinAdView = AppLovinAdapter.this.createBanner(ironSourceBannerLayout.getActivity(), ironSourceBannerLayout.getSize(), jSONObject, bannerSmashListener);
                            AppLovinAdapter.this.mLastAdView = appLovinAdView;
                            appLovinAdView.loadNextAd();
                        }
                        catch (Exception exception) {
                            String string2 = "Banner Load Fail, " + AppLovinAdapter.this.getProviderName() + " - " + "failed to retrieve AppLovin AdView from banner layout";
                            IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)string2);
                            if (AppLovinAdapter.this.mActiveBannerSmash == null) break block2;
                            AppLovinAdapter.this.mActiveBannerSmash.onBannerAdLoadFailed(ironSourceError);
                        }
                    }
                }
            });
        }
    }

    private AppLovinAdView createBanner(Activity activity, EBannerSize eBannerSize, JSONObject jSONObject, BannerSmashListener bannerSmashListener) {
        AppLovinAdSize appLovinAdSize = eBannerSize == EBannerSize.RECTANGLE ? AppLovinAdSize.MREC : AppLovinAdSize.BANNER;
        AppLovinAdView appLovinAdView = new AppLovinAdView(this.mAppLovinSdk, appLovinAdSize, (Context)activity);
        appLovinAdView.setAdLoadListener((AppLovinAdLoadListener)this.mBNAdListener);
        appLovinAdView.setAdClickListener((AppLovinAdClickListener)this.mBNAdListener);
        appLovinAdView.setAdDisplayListener((AppLovinAdDisplayListener)this.mBNAdListener);
        return appLovinAdView;
    }

    public void destroyBanner(JSONObject jSONObject) {
        try {
            if (this.mLastAdView != null) {
                this.mLastAdView.destroy();
            }
        }
        catch (Exception exception) {
            this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + ":destroyBanner() failed with an exception: " + exception, 2);
        }
    }

    public void reloadBanner(JSONObject jSONObject) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (AppLovinAdapter.this.mLastAdView != null) {
                    AppLovinAdapter.this.mLastAdView.loadNextAd();
                }
            }
        });
    }

    protected void addBannerListener(BannerSmashListener bannerSmashListener) {
        this.mAllBannerSmashes.add(bannerSmashListener);
    }

    protected void removeBannerListener(BannerSmashListener bannerSmashListener) {
        this.mAllBannerSmashes.remove(bannerSmashListener);
    }

    private String getErrorString(int n2) {
        switch (n2) {
            case -102: {
                return "Ad fetch timeout";
            }
            case -300: {
                return "No ad pre-loaded";
            }
            case -500: {
                return "Server timeout";
            }
            case -400: {
                return "Unknown server error";
            }
            case -600: {
                return "User closed video before reward";
            }
            case 204: {
                return "No fill";
            }
            case -103: {
                return "No network available";
            }
            case -6: {
                return "Unable to render ad";
            }
            case -1: {
                return "Unspecified error";
            }
        }
        return "Unknown error";
    }

    private class ALBannerListener
    implements AppLovinAdClickListener,
    AppLovinAdDisplayListener,
    AppLovinAdLoadListener {
        private ALBannerListener() {
        }

        public void adClicked(AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Banner adClicked", 1);
            if (AppLovinAdapter.this.mActiveBannerSmash != null) {
                AppLovinAdapter.this.mActiveBannerSmash.onBannerAdClicked();
            }
        }

        public void adDisplayed(AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Banner adDisplayed", 1);
            if (AppLovinAdapter.this.mActiveBannerSmash != null) {
                AppLovinAdapter.this.mActiveBannerSmash.onBannerAdScreenPresented();
            }
        }

        public void adHidden(AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Banner adHidden", 1);
            if (AppLovinAdapter.this.mActiveBannerSmash != null) {
                AppLovinAdapter.this.mActiveBannerSmash.onBannerAdScreenDismissed();
            }
        }

        public void adReceived(AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Banner adReceived", 1);
            if (AppLovinAdapter.this.mLastAdView != null && AppLovinAdapter.this.mActiveBannerSmash != null) {
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
                AppLovinAdapter.this.mActiveBannerSmash.onBannerAdLoaded((View)AppLovinAdapter.this.mLastAdView, layoutParams, null);
            }
        }

        public void failedToReceiveAd(int n2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Banner failedToReceiveAd", 1);
            if (AppLovinAdapter.this.mActiveBannerSmash != null) {
                String string2 = AppLovinAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)string2);
                AppLovinAdapter.this.mActiveBannerSmash.onBannerAdLoadFailed(ironSourceError);
            }
        }
    }
}

