package com.yodo1ads.plugin.mobvista;

import android.app.Activity;
import android.os.Looper;
import android.text.TextUtils;

import com.mintegral.msdk.MIntegralSDK;
import com.mintegral.msdk.out.MIntegralSDKFactory;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.ValidateUtils;
import com.yodo1.sdk.kit.YLog;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Created by yodo1 on 2016/4/21.
 */
public class AdvertCoreMobVista {
    private static AdvertCoreMobVista instance;
    private AdvertCoreMobVista(){}
    public static AdvertCoreMobVista getInstance(){
        if(instance == null){
            instance = new AdvertCoreMobVista();
        }
        return instance;
    }



    private boolean validate = false;
    public  void validateAdsAdapter(Activity activity){
        if(!validate) {
            List<String> mobActivities = Arrays.asList(new String[] { "com.mintegral.msdk.activity.MTGCommonActivity"
                    , "com.mintegral.msdk.reward.player.MTGRewardVideoActivity"
                    , "com.mintegral.msdk.mtgjscommon.authority.activity.MTGAuthorityActivity" });
            ValidateUtils.validateActivities(activity,mobActivities);


            List<String> mobService = Arrays.asList(new String[] { "com.mintegral.msdk.shell.MTGService" });
            ValidateUtils.validateServices(activity,mobService);


            List<String> mobReceiver = Arrays.asList(new String[] { "com.alphab.receiver.AlphabReceiver"
                    ,"com.mintegral.msdk.click.AppReceiver"});
            ValidateUtils.validateBroadcastReceivers(activity,mobReceiver);
            validate = true;
        }

    }

    private boolean isInit = false;

    public  void init(final Activity activity){
        if(!isInit) {
            AdConfigMobvista.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                    AdConfigMobvista.CHANNEL_CODE,AdConfigMobvista.KEY_MOBVISTA_APP_ID);
            AdConfigMobvista.APP_KEY = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                    AdConfigMobvista.CHANNEL_CODE,AdConfigMobvista.KEY_MOBVISTA_APP_KEY);

            if (TextUtils.isEmpty(AdConfigMobvista.APP_ID) && TextUtils.isEmpty(AdConfigMobvista.APP_KEY)){
                AdConfigMobvista.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                        AdConfigMobvista.CHANNEL_CODE,AdConfigMobvista.KEY_MOBVISTA_APP_ID);
                AdConfigMobvista.APP_KEY = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                        AdConfigMobvista.CHANNEL_CODE,AdConfigMobvista.KEY_MOBVISTA_APP_KEY);
            }

            if (TextUtils.isEmpty(AdConfigMobvista.APP_ID) && TextUtils.isEmpty(AdConfigMobvista.APP_KEY)){
                YLog.e("Mobvista  key未获取到");
                return;
            }
            YLog.i("Mobvista  appid:  " + AdConfigMobvista.APP_ID);



            //开启线程初始化SDK
            new Thread(new Runnable() {
                @Override
                public void run() {
                    Looper.prepare();
                    // init sdk
                    MIntegralSDK sdk = MIntegralSDKFactory.getMIntegralSDK();
                    // test appId and appKey

                    Map<String, String> map = sdk.getMTGConfigurationMap(AdConfigMobvista.APP_ID, AdConfigMobvista.APP_KEY );

                    // if you modify applicationId, please add the following attributes,
                    // otherwise it will crash
                    // map.put(MobVistaConstans.PACKAGE_NAME_MANIFEST, "your AndroidManifest
                    // package value");
                    sdk.init(map, activity.getApplication());
                    Looper.loop();
                }
            }).start();
            isInit = true;
        }

    }

}
