package com.yodo1ads.adapter.interstitial;


import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTInteractionAd;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1ads.plugin.toutiao.AdConfigToutiao;
import com.yodo1ads.plugin.toutiao.AdvertCoreToutiao;
import com.yodo1.sdk.kit.YLog;


/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdaptertoutiao extends AdInterstitialAdapterBase {

    private TTAdNative mTTAdNative;
    private Yodo1InterstitialCallback adCallBack;
    private Yodo1InterstitialReloadCallback callback;
    private TTInteractionAd ttInteraction;

    private TTAdNative.InteractionAdListener adLister = new TTAdNative.InteractionAdListener(){

        @Override
        public void onError(int code, String message) {
            YLog.e("toutiao reloadInterstitialAdvert onError code==" + code + "  message==" + message);
            if(callback != null){
                callback.onResult(Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FAILED, getAdvertCode());
            }
        }

        @Override
        public void onInteractionAdLoad(TTInteractionAd ttInteractionAd) {
            if(callback != null){
                callback.onResult(Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FINISH, getAdvertCode());
            }
            ttInteractionAd.setAdInteractionListener(new TTInteractionAd.AdInteractionListener() {
                @Override
                public void onAdClicked() {
                    YLog.i( "头条插屏广告被点击");
                    if(adCallBack != null){
                        adCallBack.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLICK, getAdvertCode());
                    }
                }

                @Override
                public void onAdShow() {
                    YLog.i( "头条插屏广告show");
                    if(adCallBack != null){
                        adCallBack.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
                    }
                }

                @Override
                public void onAdDismiss() {
                    YLog.i( "头条插屏广告关闭");
                    if(adCallBack != null){
                        adCallBack.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
                    }
                }
            });
            ttInteraction = ttInteractionAd;
        }
    };


    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1InterstitialCallback callback) {
        adCallBack = callback;
        if(TextUtils.isEmpty(AdConfigToutiao.interstitial_id)){
            YLog.e("toutiao  interstitial_id is null");
            callback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未获取到在线参数，插屏广告位id", getAdvertCode());
            return;
        }
        if(ttInteraction != null) {
            ttInteraction.showInteractionAd(activity);
            ttInteraction = null;
        } else {
            callback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1InterstitialReloadCallback callback) {
        this.callback = callback;
        if(TextUtils.isEmpty(AdConfigToutiao.interstitial_id)){
            YLog.e("toutiao  interstitial_id is null");
            return;
        }
        AdSlot adSlot = new AdSlot.Builder()
                .setCodeId(AdConfigToutiao.interstitial_id)
                .setSupportDeepLink(true)
                .setImageAcceptedSize(800, 800)
                .build();
        //调用插屏广告异步请求接口
        mTTAdNative.loadInteractionAd(adSlot, adLister);
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return ttInteraction != null;
    }

    @Override
    public String getAdvertCode() {
        return AdConfigToutiao.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }


    @Override
    public void onCreate(Activity activity) {
        AdConfigToutiao.interstitial_id = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigToutiao.CHANNEL_CODE
                , AdConfigToutiao.KEY_INTERSTITIAL_ID);
        if(TextUtils.isEmpty(AdConfigToutiao.interstitial_id)){
            YLog.e("toutiao  interstitial_id is null");
            return;
        }
        //创建TTAdNative对象,用于调用广告请求接口
        mTTAdNative = AdvertCoreToutiao.getAdManager(activity).createAdNative(activity);
    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
