package com.yodo1ads.adapter.interstitial;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.tapjoy.TJActionRequest;
import com.tapjoy.TJEarnedCurrencyListener;
import com.tapjoy.TJError;
import com.tapjoy.TJPlacement;
import com.tapjoy.TJPlacementListener;
import com.tapjoy.Tapjoy;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1ads.plugin.tapjoy.AdConfigTapjoy;
import com.yodo1ads.plugin.tapjoy.AdvertCoreTapjoy;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
/**
 * Created by yodo1 on 17/8/31.
 */
public class AdvertAdaptertapjoy extends AdInterstitialAdapterBase {
    private Yodo1InterstitialReloadCallback callback;
    private Yodo1InterstitialCallback interstitialCallback;
    private TJPlacement directPlayPlacement;
    private boolean isconnect;

    private TJPlacementListener interstitialListener = new TJPlacementListener() {

        @Override
        public void onRequestSuccess(TJPlacement tjPlacement) {
            YLog.d("Tapjoy  onRequestSuccess");
        }

        @Override
        public void onRequestFailure(TJPlacement tjPlacement, TJError tjError) {
            YLog.d("Tapjoy  onRequestFailure");
        }

        @Override
        public void onContentReady(TJPlacement tjPlacement) {
            YLog.d("Tapjoy  onContentReady");
            if(callback != null){
                callback.onResult(Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onContentShow(TJPlacement tjPlacement) {
            YLog.d("Tapjoy  onContentShow");
            if(interstitialCallback != null){
                interstitialCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY, AdConfigTapjoy.CHANNEL_CODE);
            }
        }

        @Override
        public void onContentDismiss(TJPlacement tjPlacement) {
            YLog.d("Tapjoy  onContentDismiss");
            if(interstitialCallback != null){
                interstitialCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, AdConfigTapjoy.CHANNEL_CODE);
            }
        }

        @Override
        public void onPurchaseRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s) {
            YLog.d("Tapjoy  onPurchaseRequest");
        }

        @Override
        public void onRewardRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s, int i) {
            YLog.d("Tapjoy  onRewardRequest");
        }
    };


    @Override
    public void showIntersititalAdvert(Activity activity, final Yodo1InterstitialCallback callback) {
        this.interstitialCallback = callback;
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (directPlayPlacement != null && directPlayPlacement.isContentReady()) {
                    directPlayPlacement.showContent();

                } else {
                    callback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", AdConfigTapjoy.CHANNEL_CODE);
                }

            }
        });
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1InterstitialReloadCallback callback) {
        this.callback = callback;
        if(TextUtils.isEmpty(AdConfigTapjoy.placementInterstitial)){
            YLog.e("AdvertAdapterTapjoy, placementInterstitial is null");
            return;
        }

        if( Tapjoy.isConnected() ) {
            onConnectSuccess();
            directPlayPlacement.requestContent();
        } else {
            YLog.i("Tapjoy SDK must finish connecting before requesting content.");
        }
    }
    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return directPlayPlacement != null && directPlayPlacement.isContentReady();
    }

    private void onConnectSuccess() {
        if(AdvertCoreTapjoy.getInstance().isInit && !isconnect) {
            YLog.d("AdvertAdapterTapjoy, Interstitial onConnectSuccess");
            directPlayPlacement = Tapjoy.getPlacement(AdConfigTapjoy.placementInterstitial, interstitialListener);
            Tapjoy.setEarnedCurrencyListener(new TJEarnedCurrencyListener() {
                @Override
                public void onEarnedCurrency(String currencyName, int amount) {

                }
            });
            isconnect = true;
        }

    }



    @Override
    public String getAdvertCode() {
        return AdConfigTapjoy.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }
    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreTapjoy.getInstance().validateAdsAdapter(activity);
    }
    @Override
    public void onCreate(Activity activity) {
        AdvertCoreTapjoy.getInstance().init(activity);

    }

    @Override
    public void onStart(Activity activity) {
    }

    @Override
    public void onResume(Activity activity) {
        AdvertCoreTapjoy.getInstance().onActivityStart(activity);
    }

    @Override
    public void onPause(Activity activity) {
        AdvertCoreTapjoy.getInstance().onActivityStop(activity);
    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
