package com.yodo1.advert.factory;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;

import com.yodo1.advert.AdapterAdvertBase;
import com.yodo1.advert.banner.AdBannerAdapterBase;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.onlineconfig.AdsConfigEntity;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.utils.YOnlineConfigUtils;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.sdk.kit.YLog;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class Yodo1AdvertAdapterFactory {
    private static final String PACKAGE_NAME_INTERSTITIAL = "com.yodo1ads.adapter.interstitial.AdvertAdapter"; //存放插屏插件的完整包名
    private static final String PACKAGE_NAME_VIDEO = "com.yodo1ads.adapter.video.AdvertAdapter"; //存放视频插件的完整包名
    private static final String PACKAGE_NAME_BANNER = "com.yodo1ads.adapter.banner.AdvertAdapter"; //存放Banner插件的完整包名
    private static Yodo1AdvertAdapterFactory instance;
    private Map<String, AdapterAdvertBase> _InterstitialAdapters = new HashMap<String, AdapterAdvertBase>(); //用于保存实例化好的插屏广告插件，避免重复实例化
    private Map<String, AdapterAdvertBase> _VideoAdapters = new HashMap<String, AdapterAdvertBase>(); //用于保存实例化好的视频广告插件，避免重复实例化
    private Map<String, AdapterAdvertBase> _BannerAdapters = new HashMap<String, AdapterAdvertBase>(); //用于保存实例化好的Banner广告插件，避免重复实例化
    private Yodo1AdvertAdapterFactory() {
    }

    public static Yodo1AdvertAdapterFactory getInstance() {
        if (instance == null) {
            instance = new Yodo1AdvertAdapterFactory();
        }
        return instance;
    }

    /**
     * 获取所有已经实例化的广告Adapter
     *
     * @return
     */
    public Map<String, AdapterAdvertBase> getAdapters(AdvertType advertType) {
        if (advertType == AdvertType.Interstitial) {
            return _InterstitialAdapters;
        } else if (advertType == AdvertType.Video) {
            return _VideoAdapters;
        } else if (advertType == AdvertType.Banner) {
            return _BannerAdapters;
        }
        return null;
    }

    private boolean hasInit = false;
    /**
     * 实例化所有广告
     */
    public void initAdvertAdapters(Context context) {
        if (hasInit){
            Log.i("yodo1-games-sdk","已经初始化广告列表");
            return;
        }
        hasInit = true;


        //读取该包名下所有的类，并通过是否继承与目标父类，来判断是否需要找的Adapter
        AdvertTypeBean[] advertBeans = {
                new AdvertTypeBean(AdvertType.Interstitial, PACKAGE_NAME_INTERSTITIAL, AdInterstitialAdapterBase.class, _InterstitialAdapters),
                new AdvertTypeBean(AdvertType.Video, PACKAGE_NAME_VIDEO, AdVideoAdapterBase.class, _VideoAdapters),
                new AdvertTypeBean(AdvertType.Banner, PACKAGE_NAME_BANNER, AdBannerAdapterBase.class, _BannerAdapters),
        };

        for (int i = 0; i < advertBeans.length; i++) {
            initAdvertAdapter(context, advertBeans[i]);
        }
    }

    private void initAdvertAdapter(Context context, AdvertTypeBean bean) {
        List<String> advertCodes = getAdCodes(bean);
        for (int i = 0; i < advertCodes.size(); i++) {

            try {
                String className = bean.packageName + advertCodes.get(i);
                Class clz = Class.forName(className);
                if (clz != null) {
                    clz.asSubclass(bean.clz); //如果该类不是继承广告类，那么这里会catch出去
                    AdapterAdvertBase adapterBase = (AdapterAdvertBase) clz.newInstance();
                    bean.adapters.put(adapterBase.getAdvertCode().toLowerCase(Locale.getDefault()), adapterBase);
                    YLog.d("AdvertAdapterFactory --- 实例化广告" + className + ", 地址 = " + adapterBase);
                }
            } catch (Exception e) {
            } catch (Error e) {
            }
        }
    }

    /**
     * 获取广告列表
     *
     * @return
     */
    private List<String> getAdCodes(AdvertTypeBean bean) {
        List<AdsConfigEntity> adList = new ArrayList<>();
        String advert = "";
        if (bean.advertType == AdvertType.Interstitial && YOnlineConfigUtils.isTrunOnAdvertInterstitial()){
            adList = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd);
        } else if (bean.advertType == AdvertType.Video && YOnlineConfigUtils.isTrunOnAdvertVideo()){
            adList = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd);
        } else if (bean.advertType == AdvertType.Banner && YOnlineConfigUtils.isTrunOnAdvertBanner()){
            adList = Yodo1OnlineConfigAgent.getAdsControl(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd);
        }

        List<String>  weight = new ArrayList<>();
        for (int i = 0 ;i < adList.size() ;i ++) {
            weight.add(adList.get(i).getAdvertCode());
        }

        return weight;
    }

    private int removeAds = 0;//0 表示都没有引入   1表示移除Ny   2表示移除gdt  3 表示移除baidu   4表示 移除baidu和gdt
    private List getAdsList(String[] array,AdvertType advertType){
        List list = new ArrayList();
        if (array != null && array.length != 0){
            for (int i = 0; i < array.length; i++) {
                list.add(array[i]);
            }

            if (Build.VERSION.SDK_INT < 21){
                //在Android4.+的设备上  宁游与广点通冲突   在插屏中 广点通和宁游广告   谁在前初始化谁  在baner广告中 以插屏为准
                if (advertType == AdvertType.Interstitial){
                    int positon_gdt = list.indexOf("gdt");
                    int positon_ny = list.indexOf("ny");
//                    int positon_tt = list.indexOf("toutiao");
                    int positon_bd = list.indexOf("baidu");

                    List list1 = new ArrayList();
                    if (positon_bd >= 0 ){
                        list1.add(positon_bd);
                    }
                    if (positon_gdt >= 0 ){
                        list1.add(positon_gdt);
                    }
//                    list1.add(positon_tt);

                    if (list1 != null){
                        //如果广告列表中包含百度 广点通 等  获取百度 广点通 头条中最小值   最小表示优先级较高   min值与ny的值比较   ny最小采用宁游的  min值最小 采用广点通 百度 头条的
                        int min = Integer.valueOf(Collections.min(list1).toString());

                        if (positon_ny > 0 ){
                            if (min < positon_ny){
                                list.remove("ny");
                                removeAds = 1;
                            } else {
                                list.remove("gdt");
                                list.remove("baidu");
                                removeAds = 0;
                            }
                        } else if (positon_ny == 0){
                            list.remove("gdt");
                            list.remove("baidu");
                            removeAds = 0;
                        }

                    }

                } else {//其他类型广告 看插屏移除的是宁游的广告还是与宁游冲突的广告  主要有banner native splash
                    switch (removeAds) {
                        case 1:
                            list.remove("ny");
                            break;
                        case 0:
                            list.remove("baidu");
                            list.remove("gdt");
                            break;
                    }
                }
            }
        }

        YLog.d("AdvertAdapterFactory  计划初始化广告列表： " + list.toString());
        return list;
    }
    /**
     * 广告类型
     */
    public enum AdvertType {
        /**
         * 插屏
         */
        Interstitial,
        /**
         * 视频
         */
        Video,
        /*
         * Banner
         */
        Banner,

    }

    private class AdvertTypeBean {
        public AdvertType advertType; //广告类型
        public String packageName; //存放插件的完整包名
        public Class<?> clz; //实现方法的广告插件基类
        public Map<String, AdapterAdvertBase> adapters; //存放实例化好的广告插件的集合

        public AdvertTypeBean(AdvertType type, String fullPackageName, Class<?> clz, Map<String, AdapterAdvertBase> adapters) {
            this.advertType = type;
            this.packageName = fullPackageName;
            this.clz = clz;
            this.adapters = adapters;
        }

    }
}
