package com.yodo1ads.plugin.vungle;


import android.app.Activity;
import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.vungle.publisher.VungleAdEventListener;
import com.vungle.publisher.VungleInitListener;
import com.vungle.publisher.VunglePub;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.ValidateUtils;
import com.yodo1.sdk.kit.YLog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by yodo1 on 2016/4/21.
 */
public class AdvertCoreVungle {
    private static AdvertCoreVungle instance;
    private AdvertCoreVungle(){}
    public static AdvertCoreVungle getInstance(){
        if(instance == null){
            instance = new AdvertCoreVungle();
        }
        return instance;
    }

    private Activity activity = null;
    private Yodo1VideoCallback videoCallback; //视频回调
    private Yodo1VideoReloadCallback reloadCallback; //视频预加载回调
    private Yodo1InterstitialCallback intersititalCallback;//插屏回调
    private Yodo1InterstitialReloadCallback reloadInterstitialCallback; //视频预加载回调


    private ArrayList<String> placementidsList = new ArrayList<String>(); //广告位ID
    private static VunglePub vunglePub = VunglePub.getInstance();
    private  ArrayList<String> loadedvideoList;
    public boolean isInit = false;

    public void init(final Activity activity){
        this.activity = activity;
        if (isInit){
            YLog.d("Vungle has Init");
            return;
        }
        isInit = true;


        AdConfigVungle.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                AdConfigVungle.CHANNEL_CODE, AdConfigVungle.KEY_VUNGLE_APP_ID);

        if (TextUtils.isEmpty(AdConfigVungle.APP_ID)){
            AdConfigVungle.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                    AdConfigVungle.CHANNEL_CODE, AdConfigVungle.KEY_VUNGLE_APP_ID);

        }
        AdConfigVungle.PLACEMENTID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                AdConfigVungle.CHANNEL_CODE, AdConfigVungle.VUNGLE_PLACEMENTID);
        AdConfigVungle.INTERSTITIAL_PLACEMENTID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                AdConfigVungle.CHANNEL_CODE, AdConfigVungle.VUNGLE_INTERSTITIAL_PLACEMENTID);


        if (TextUtils.isEmpty( AdConfigVungle.APP_ID)){
            YLog.i("Vungle  appid  is null");
            return ;
        }

        if (!TextUtils.isEmpty(AdConfigVungle.PLACEMENTID)){
            placementidsList.add(AdConfigVungle.PLACEMENTID);
        }
        if (!TextUtils.isEmpty(AdConfigVungle.INTERSTITIAL_PLACEMENTID) && !AdConfigVungle.PLACEMENTID.equals(AdConfigVungle.INTERSTITIAL_PLACEMENTID)){
            placementidsList.add(AdConfigVungle.INTERSTITIAL_PLACEMENTID);
        }
        final String[] placementid = placementidsList.toArray(new String[placementidsList.size()]);

        if (placementid == null || placementid.length==0){
            YLog.i("Vungle placementid  is null");
            return ;
        }
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                vunglePub.init(activity, AdConfigVungle.APP_ID, placementid, new VungleInitListener() {
                    @Override
                    public void onSuccess() {
                        YLog.d("Vungle init success");
                        vunglePub.clearAndSetEventListeners(vungleDefaultListener);
                    }

                    @Override
                    public void onFailure(Throwable throwable) {
                        YLog.d("Vugle init onFailure");
                    }
                });
            }
        });

    }



    private final VungleAdEventListener vungleDefaultListener = new VungleAdEventListener() {

        @Override
        public void onAdEnd(@NonNull final String placementReferenceId, boolean wasSuccessFulView, boolean wasCallToActionClicked) {
            YLog.d("Vungle,  onAdEnd  wasSuccessfulView : " + wasSuccessFulView  + "   wasCallToActionClicked : " + wasCallToActionClicked);
            if (wasCallToActionClicked){
                if (placementReferenceId .equals(AdConfigVungle.PLACEMENTID) && videoCallback != null){
                    videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLICK, AdConfigVungle.CHANNEL_CODE);
                }

                if (placementReferenceId .equals(AdConfigVungle.INTERSTITIAL_PLACEMENTID) && intersititalCallback != null){
                    intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLICK, AdConfigVungle.CHANNEL_CODE);
                }
            }
            final boolean videoSuccessshow = wasSuccessFulView;
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {

                    if (placementReferenceId .equals(AdConfigVungle.PLACEMENTID)){
                        if (videoSuccessshow){
                            YLog.d("Vungle,  onAdEnd  关闭" );
                            if (videoCallback != null){
                                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, AdConfigVungle.CHANNEL_CODE);
                            }
                        }
                        if (videoCallback != null){
                            videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, AdConfigVungle.CHANNEL_CODE);
                        }
                    }

                    if (placementReferenceId .equals(AdConfigVungle.INTERSTITIAL_PLACEMENTID)){
                        if(intersititalCallback != null){
                            intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, AdConfigVungle.CHANNEL_CODE);
                        }
                    }

                }
            });

        }

        @Override
        public void onAdStart(@NonNull String placementReferenceId) {
            YLog.d("Vungle,  onAdStart " );
            if (placementReferenceId .equals(AdConfigVungle.PLACEMENTID)){
                if (videoCallback != null){
                    videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, AdConfigVungle.CHANNEL_CODE);
                }
            }
            if (placementReferenceId .equals(AdConfigVungle.INTERSTITIAL_PLACEMENTID)){
                if(intersititalCallback != null){
                    intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY, AdConfigVungle.CHANNEL_CODE);
                }
            }

        }

        @Override
        public void onUnableToPlayAd(@NonNull String placementReferenceId, String reason) {
            YLog.d("Vungle,  onUnableToPlayAd: " + placementReferenceId + " ,reason: " + reason);
        }

        @Override
        public void onAdAvailabilityUpdate(@NonNull String placementReferenceId, boolean isAdAvailable) {
            YLog.d("Vungle,  onAdAvailabilityUpdate: " + placementReferenceId + " isAdAvailable: " + isAdAvailable);
            loadedvideoList = new ArrayList();
            final String placementIdUpdated = placementReferenceId;

            if (placementidsList != null || placementidsList.size()!=0){
                for (String adId: placementidsList) {
                    if(placementIdUpdated.equals(adId)) {
                        if(isAdAvailable) {
                            YLog.d("Vungle,  onAdAvailabilityUpdate: " + placementReferenceId);
                            loadedvideoList.add(placementIdUpdated);
                            if (placementReferenceId .equals(AdConfigVungle.PLACEMENTID) && reloadCallback != null) {
                                reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FINISH, AdConfigVungle.CHANNEL_CODE);
                            }
                        } else {
                            if (placementReferenceId .equals(AdConfigVungle.PLACEMENTID) && reloadCallback != null) {
                                reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FAILED, AdConfigVungle.CHANNEL_CODE);
                            }

                        }
                    }
                }
            }
        }
    };

    public boolean validateAdsAdapter = false;
    public void validateAdsAdapter(Activity activity) {
        if (validateAdsAdapter){
            return;
        }
        validateAdsAdapter = true;
        List<String> vungleActivities = Arrays.asList(new String[] { "com.vungle.publisher.VideoFullScreenAdActivity", "com.vungle.publisher.MraidFullScreenAdActivity", "com.vungle.publisher.FlexViewAdActivity" });
        ValidateUtils.validateActivities(activity,vungleActivities);
    }

    public boolean isOnResume = false;
    public void onResume(Activity activity) {
        if (isOnResume){
            return;
        }
        isOnResume = true;

        if (TextUtils.isEmpty( AdConfigVungle.APP_ID)){
            YLog.i("Vungle  appid  is null");
            return ;
        }
        vunglePub.onResume();
    }


    public boolean isOnPause = false;
    public void onPause(Activity activity) {
        if (isOnPause){
            return;
        }
        isOnPause = true;

        if (TextUtils.isEmpty( AdConfigVungle.APP_ID)){
            return ;
        }
        vunglePub.onPause();
    }

    public boolean isOnDestroy = false;
    public void onDestroy(Activity activity) {
        if (isOnDestroy){
            return;
        }
        isOnDestroy = true;
        if (TextUtils.isEmpty( AdConfigVungle.APP_ID)){
            return ;
        }

        vunglePub.clearEventListeners();
    }


    public boolean AdvertIsLoaded(Activity activity,String placementId) {
        if (loadedvideoList == null || loadedvideoList.size()==0){
            YLog.i("Vungle,  暂无可用广告");
            return false;
        }

        if (vunglePub != null && vunglePub.isInitialized()) {
            return vunglePub.isAdPlayable(placementId);//目前只有一个广告位，只判断一个广告位播放情况
        }
       return false;
    }


    public void reloadVideoAdvert(String placementId, Yodo1VideoReloadCallback callback) {
        this.reloadCallback = callback;
        YLog.e("Vungle init : " + vunglePub.isInitialized());
        if (vunglePub != null && vunglePub.isInitialized()) {
            vunglePub.loadAd(placementId);
        }
    }

    public void playVideoAdvert(String placementId, Yodo1VideoCallback callback) {
        this.videoCallback = callback;
        vunglePub.playAd(placementId, null);
    }

    public void reloadIntersititalAdvert(String placementId, Yodo1InterstitialReloadCallback callback) {
        this.reloadInterstitialCallback = callback;
        if (vunglePub != null && vunglePub.isInitialized()) {
            vunglePub.loadAd(placementId);
        }
    }

    public void playIntersititalAdvert(String placementId, Yodo1InterstitialCallback callback) {
        this.intersititalCallback = callback;
        vunglePub.playAd(placementId, null);
    }
}
