package com.yodo1ads.plugin.tapjoy;

import android.app.Activity;
import android.text.TextUtils;

import com.tapjoy.TJConnectListener;
import com.tapjoy.Tapjoy;
import com.tapjoy.TapjoyLog;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.ValidateUtils;
import com.yodo1.sdk.kit.YLog;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

/**
 * Created by liumeili on 17/9/1.
 */

/**
 * tapjoy通过placement来控制是播放什么广告,tapjoy有视频,插屏和积分墙等
 *
 * 典型的 Placements 包括 AppOpen, WatchVideoForReward,
 * 以及 MainMenu. 所有Tapjoy 内容都会通过应用中设定的 Placements 来展示。
 * 这些内容包括广告内容 (积分墙, 在用户观看后会奖励虚拟币的视频广告, 或者是全屏的互动广告) 或者是一条来您发送给您的用户的自定义信息
 * (一条您的应用内可购买商品的促销信息, 或者是发布一项新的功能)。
 * 所有如果您要再您的应用中展示积分墙，您并不需要直接调用一条展示积分墙的API。取而代之的是，您可以创建一个Placement,并且在Tapjoy控制面板中将积分墙内容加入到这个Placement中。
 */
public class AdvertCoreTapjoy {

    private static AdvertCoreTapjoy instance;

    public static AdvertCoreTapjoy getInstance(){
        if(instance == null){
            instance = new AdvertCoreTapjoy();
        }
        return instance;
    }

    public boolean isInit = false;

    public void init(Activity activity){
//        AdConfigTapjoy.appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigTapjoy.CHANNEL_CODE
//                , AdConfigTapjoy.KEY_APPID);
        AdConfigTapjoy.appkey = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigTapjoy.CHANNEL_CODE
                , AdConfigTapjoy.KEY_APPKEY);
        AdConfigTapjoy.placementVideo = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigTapjoy.CHANNEL_CODE
                , AdConfigTapjoy.KEY_PLACEMENT_VIDEO);
        if (TextUtils.isEmpty(AdConfigTapjoy.appkey)){
            AdConfigTapjoy.appkey = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigTapjoy.CHANNEL_CODE
                    , AdConfigTapjoy.KEY_APPKEY);
        }
        AdConfigTapjoy.placementInterstitial = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigTapjoy.CHANNEL_CODE
                , AdConfigTapjoy.KEY_PLACEMENT_INTERSTITIAL);

//        AdConfigTapjoy.appkey = "bjrU_2L-SlSQ8c-BCXDUMQECwJNBcGAcY366isZzYCGQBMatmmL7mXklhSaB";
//        AdConfigTapjoy.appId = "6e3ad4ff-62fe-4a54-90f1-cf810970d431";
//        AdConfigTapjoy.placementVideo = "Video";
//        AdConfigTapjoy.placementInterstitial = "INTERSTITIAL";


        if ( TextUtils.isEmpty(AdConfigTapjoy.appkey )&&
                TextUtils.isEmpty(AdConfigTapjoy.placementVideo ) && TextUtils.isEmpty(AdConfigTapjoy.placementInterstitial )){

            YLog.i("Tapjoy,  请检查在线参数");
            return;
        }
        if(!isInit) {
            if(TextUtils.isEmpty(AdConfigTapjoy.appkey)){
                return;
            }
            isInit = true;
            Hashtable<String, Object> connectFlags = new Hashtable<String, Object>();
            boolean isDebugEnabled = false;
            if(isDebugEnabled) {
                connectFlags.put("TJC_OPTION_ENABLE_LOGGING", "true");
                Tapjoy.setDebugEnabled(true);
                TapjoyLog.setDebugEnabled(true);
            } else {
                connectFlags.put("TJC_OPTION_ENABLE_LOGGING", "false");
                Tapjoy.setDebugEnabled(false);
                TapjoyLog.setDebugEnabled(false);
            }
            YLog.d("AdvertCoreTapjoy, init ...");
            Tapjoy.setActivity(activity);
            Tapjoy.connect(activity.getApplicationContext(), AdConfigTapjoy.appkey, connectFlags,  new TJConnectListener() {
                @Override
                public void onConnectSuccess() {
                    YLog.d("Tapjoy  connectSuccess");

                }

                @Override
                public void onConnectFailure() {
                    YLog.i("Tapjoy  onConnectFail");
                    isInit = false;
                }
            });

        }
    }


    public boolean isStart = false;

    public void onActivityStart(Activity activity){
        if (!isStart){
            isStart = true;
            Tapjoy.onActivityStart(activity);
        }
    }

    public void onActivityStop(Activity activity){
        if (isStart){
            isStart = false;
            Tapjoy.onActivityStart(activity);
        }
    }

    private boolean validate = false;
    public  void validateAdsAdapter(Activity activity){
        if(!validate) {
            List<String> tapjoyActivities = Arrays.asList(new String[] { "com.tapjoy.TJAdUnitActivity" ,
                    "com.tapjoy.TJContentActivity" ,"com.tapjoy.mraid.view.ActionHandler","com.tapjoy.mraid.view.Browser" });
            ValidateUtils.validateActivities(activity,tapjoyActivities);


            validate = true;
        }

    }
}
