package com.yodo1.advert.utils;

import android.text.TextUtils;

import com.yodo1.advert.factory.Yodo1AdvertAdapterFactory;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;

import java.util.Locale;

/**
 * 在线参数获取工具
 * <p>
 * Created by yodo1 on 2016/3/18.
 */
public class YOnlineConfigUtils {

    /**
     * 获取插屏广告的播放开关是否打开
     *
     * @return
     */
    public static boolean isTrunOnAdvertInterstitial() {
        String value = Yodo1OnlineConfigAgent.getActiveConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd);

        if (!TextUtils.isEmpty(value) && "on".equals((value.trim()).toLowerCase(Locale.getDefault()))) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * 获取游戏视频广告的播放开关是否打开
     *
     * @return
     */
    public static boolean isTrunOnAdvertVideo() {
        String value = Yodo1OnlineConfigAgent.getActiveConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd);
        if (!TextUtils.isEmpty(value) && "on".equals((value.trim()).toLowerCase(Locale.getDefault()))) {
            return true;
        } else {
            return false;
        }
    }


    /**
     * 获取Baner的播放开关是否打开
     *
     * @return
     */
    public static boolean isTrunOnAdvertBanner() {
        String value = Yodo1OnlineConfigAgent.getActiveConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd);
        if (!TextUtils.isEmpty(value) && "on".equals((value.trim()).toLowerCase(Locale.getDefault()))) {
            return true;
        } else {
            return false;
        }
    }



    /**
     * 获取插屏广告显示间隔
     * <p>
     * 在线参数单位为秒，但该方法会转为毫秒
     *
     * @return 返回毫秒
     */
    public static long getIntervalAdvertInterstitial() {
        String value = Yodo1OnlineConfigAgent.getIntervalConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd);

        if (!TextUtils.isEmpty(value)) {
            try {
                long time = Long.parseLong(value);
                return time * 1000;
            } catch (NumberFormatException e) {
                YLog.e("YOnlineConfigUtils, 获取插屏间隔失败 >>> 类型转换失败，请检查后台填写是否有错");
                e.printStackTrace();
            }
        }
        return 0;
    }


    /**
     * 获取插屏广告显示间隔
     * <p>
     * 在线参数单位为秒，但该方法会转为毫秒
     *
     * @return 返回毫秒
     */
    public static long getSwitchingCycle() {
        String value = Yodo1OnlineConfigAgent.getSwitchingCycleConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd);

        if (!TextUtils.isEmpty(value)) {
            try {
                long time = Long.parseLong(value);
                return time * 1000;
            } catch (NumberFormatException e) {
                YLog.e("YOnlineConfigUtils, 获取插屏间隔失败 >>> 类型转换失败，请检查后台填写是否有错");
                e.printStackTrace();
            }
        }
        return 30 * 1000;
    }


}
