/*
 * Decompiled with CFR 0.152.
 */
package com.mobvista.msdk.base.entity;

import com.mobvista.msdk.base.entity.CampaignEx;
import com.mobvista.msdk.base.utils.h;
import com.mobvista.msdk.out.Frame;
import com.mobvista.msdk.system.NoProGuard;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class CampaignUnit
implements NoProGuard,
Serializable {
    private static final String TAG = CampaignUnit.class.getSimpleName();
    private static final long serialVersionUID = 1L;
    public static final String JSON_KEY_SESSION_ID = "session_id";
    public static final String JSON_KEY_PARENT_SESSION_ID = "parent_session_id";
    public static final String JSON_KEY_AD_TYPE = "ad_type";
    public static final String JSON_KEY_UNIT_SIZE = "unit_size";
    public static final String JSON_KEY_HTML_URL = "html_url";
    public static final String JSON_KEY_ONLY_IMPRESSION_URL = "only_impression_url";
    public static final String JSON_KEY_ADS = "ads";
    public static final String JSON_KEY_TEMPLATE = "template";
    public static final String JSON_KEY_FRAME_ADS = "frames";
    public static final String JSON_KEY_END_SCREEN_URL = "end_screen_url";
    private String sessionId;
    private String parentSessionId;
    private int adType;
    private String unitSize;
    private String htmlUrl;
    private String onlyImpressionUrl;
    public ArrayList<CampaignEx> ads;
    private int template;
    private List<Frame> listFrames;

    public List<Frame> getListFrames() {
        return this.listFrames;
    }

    public void setListFrames(List<Frame> list) {
        this.listFrames = list;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String string2) {
        this.sessionId = string2;
    }

    public String getParentSessionId() {
        return this.parentSessionId;
    }

    public void setParentSessionId(String string2) {
        this.parentSessionId = string2;
    }

    public int getAdType() {
        return this.adType;
    }

    public void setAdType(int n2) {
        this.adType = n2;
    }

    public String getUnitSize() {
        return this.unitSize;
    }

    public void setUnitSize(String string2) {
        this.unitSize = string2;
    }

    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    public void setHtmlUrl(String string2) {
        this.htmlUrl = string2;
    }

    public String getOnlyImpressionUrl() {
        return this.onlyImpressionUrl;
    }

    public void setOnlyImpressionUrl(String string2) {
        this.onlyImpressionUrl = string2;
    }

    public ArrayList<CampaignEx> getAds() {
        return this.ads;
    }

    public void setAds(ArrayList<CampaignEx> arrayList) {
        this.ads = arrayList;
    }

    public int getTemplate() {
        return this.template;
    }

    public void setTemplate(int n2) {
        this.template = n2;
    }

    public static CampaignUnit parseCampaignUnit(JSONObject jSONObject) {
        CampaignUnit campaignUnit = null;
        try {
            if (jSONObject != null) {
                campaignUnit = new CampaignUnit();
                campaignUnit.setSessionId(jSONObject.optString(JSON_KEY_SESSION_ID));
                campaignUnit.setParentSessionId(jSONObject.optString(JSON_KEY_PARENT_SESSION_ID));
                campaignUnit.setAdType(jSONObject.optInt(JSON_KEY_AD_TYPE));
                campaignUnit.setUnitSize(jSONObject.optString(JSON_KEY_UNIT_SIZE));
                campaignUnit.setHtmlUrl(jSONObject.optString(JSON_KEY_HTML_URL));
                campaignUnit.setOnlyImpressionUrl(jSONObject.optString(JSON_KEY_ONLY_IMPRESSION_URL));
                campaignUnit.setTemplate(jSONObject.optInt(JSON_KEY_TEMPLATE));
                JSONArray jSONArray = jSONObject.optJSONArray(JSON_KEY_ADS);
                JSONArray jSONArray2 = jSONObject.optJSONArray(JSON_KEY_FRAME_ADS);
                if (jSONArray2 != null && jSONArray2.length() > 0) {
                    ArrayList<Frame> arrayList = new ArrayList<Frame>();
                    for (int i2 = 0; i2 < jSONArray2.length(); ++i2) {
                        jSONArray = jSONArray2.optJSONObject(i2);
                        JSONArray jSONArray3 = jSONArray.getJSONArray(JSON_KEY_ADS);
                        ArrayList<CampaignEx> arrayList2 = new ArrayList<CampaignEx>();
                        for (int i3 = 0; i3 < jSONArray3.length(); ++i3) {
                            CampaignEx campaignEx = CampaignEx.parseCampaign(jSONArray3.optJSONObject(i3), jSONObject.optString(JSON_KEY_ONLY_IMPRESSION_URL), jSONObject.optString(JSON_KEY_HTML_URL), jSONObject.optString(JSON_KEY_END_SCREEN_URL), false);
                            arrayList2.add(campaignEx);
                        }
                        Frame frame = new Frame();
                        frame.setParentSessionId(jSONObject.optString(JSON_KEY_PARENT_SESSION_ID));
                        frame.setSessionId(jSONObject.optString(JSON_KEY_SESSION_ID));
                        frame.setCampaigns(arrayList2);
                        frame.setTemplate(jSONArray.optInt(JSON_KEY_TEMPLATE));
                        arrayList.add(frame);
                    }
                    campaignUnit.setListFrames(arrayList);
                } else if (jSONArray != null && jSONArray.length() > 0) {
                    ArrayList<CampaignEx> arrayList = new ArrayList<CampaignEx>();
                    for (int i4 = 0; i4 < jSONArray.length(); ++i4) {
                        CampaignEx campaignEx = CampaignEx.parseCampaign(jSONArray.optJSONObject(i4), jSONObject.optString(JSON_KEY_ONLY_IMPRESSION_URL), jSONObject.optString(JSON_KEY_HTML_URL), jSONObject.optString(JSON_KEY_END_SCREEN_URL), false);
                        arrayList.add(campaignEx);
                    }
                    campaignUnit.setAds(arrayList);
                }
            }
        }
        catch (Exception exception) {
            h.d(TAG, "parse campaign unit exception");
        }
        return campaignUnit;
    }
}

