/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.applovin;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdSize;
import com.applovin.sdk.AppLovinAdType;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkSettings;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.EBannerSize;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

class AppLovinAdapter
extends AbstractAdapter
implements AppLovinAdClickListener,
AppLovinAdDisplayListener,
AppLovinAdRewardListener,
AppLovinAdVideoPlaybackListener {
    private static final String VERSION = "4.0.2";
    private static final String CORE_SDK_VERSION = "7.4.1";
    private Activity mActivity;
    private AppLovinSdk mAppLovinSdk;
    private AppLovinIncentivizedInterstitial mAppLovinRV;
    private AppLovinInterstitialAdDialog mAppLovinIS;
    private Boolean mDidInitSdk = false;
    private boolean mShouldNotifyLoadResult = false;
    private ALRewardedLoadListener mRVAdLoadListener;
    private ALInterLoadListener mISAdLoadListener;
    private ALBannerListener mBNAdListener;
    private AppLovinAd mCurrentISAd;
    private final int TYPE_RV = 0;
    private final int TYPE_IS = 1;
    private final int TYPE_BN = 2;
    private final String SDK_KEY = "sdkKey";

    public static AppLovinAdapter startAdapter(String string2) {
        return new AppLovinAdapter(string2);
    }

    private AppLovinAdapter(String string2) {
        super(string2);
        this.mAllBannerSmashes = new CopyOnWriteArrayList();
        this.mRVAdLoadListener = new ALRewardedLoadListener();
        this.mISAdLoadListener = new ALInterLoadListener();
        this.mBNAdListener = new ALBannerListener();
    }

    public void initBanners(Activity activity, String string2, String string3, JSONObject jSONObject) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("sdkKey"))) {
            for (BannerSmashListener bannerSmashListener : this.mAllBannerSmashes) {
                if (bannerSmashListener == null) continue;
                bannerSmashListener.onBannerInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Banner"));
            }
            return;
        }
        this.mActivity = activity;
        this.init(activity, jSONObject.optString("sdkKey"), string3, 2);
    }

    public void loadBanner(IronSourceBannerLayout ironSourceBannerLayout, final JSONObject jSONObject, BannerSmashListener bannerSmashListener) {
        this.mActiveBannerSmash = bannerSmashListener;
        if (ironSourceBannerLayout != null) {
            this.mIronSourceBanner = ironSourceBannerLayout;
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    block5: {
                        try {
                            if (AppLovinAdapter.this.mIronSourceBanner.getSize() != EBannerSize.BANNER && AppLovinAdapter.this.mIronSourceBanner.getSize() != EBannerSize.RECTANGLE) {
                                if (AppLovinAdapter.this.mActiveBannerSmash != null) {
                                    IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)("Banner Load Fail, " + AppLovinAdapter.this.getProviderName() + " does not support EBannerSize.LARGE"));
                                    AppLovinAdapter.this.mActiveBannerSmash.attachSmashToBanner(null);
                                    AppLovinAdapter.this.mActiveBannerSmash.onBannerAdLoadFailed(ironSourceError);
                                }
                                return;
                            }
                            AppLovinAdView appLovinAdView = AppLovinAdapter.this.createBanner(AppLovinAdapter.this.mIronSourceBanner.getActivity(), AppLovinAdapter.this.mIronSourceBanner.getSize(), jSONObject);
                            AppLovinAdapter.this.mCurrentAdNetworkBanner = (View)appLovinAdView;
                            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
                            AppLovinAdapter.this.mIronSourceBanner.addView((View)appLovinAdView, 0, (ViewGroup.LayoutParams)layoutParams);
                            if (AppLovinAdapter.this.mActiveBannerSmash != null) {
                                AppLovinAdapter.this.mActiveBannerSmash.attachSmashToBanner((View)appLovinAdView);
                            }
                            appLovinAdView.loadNextAd();
                        }
                        catch (Exception exception) {
                            String string2 = "Banner Load Fail, " + AppLovinAdapter.this.getProviderName() + " - " + "failed to retrieve AppLovin AdView from banner layout";
                            IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)string2);
                            if (AppLovinAdapter.this.mActiveBannerSmash == null) break block5;
                            AppLovinAdapter.this.mActiveBannerSmash.attachSmashToBanner(null);
                            AppLovinAdapter.this.mActiveBannerSmash.onBannerAdLoadFailed(ironSourceError);
                        }
                    }
                }
            });
        }
    }

    private AppLovinAdView createBanner(Activity activity, EBannerSize eBannerSize, JSONObject jSONObject) {
        AppLovinAdSize appLovinAdSize = eBannerSize == EBannerSize.RECTANGLE ? AppLovinAdSize.MREC : AppLovinAdSize.BANNER;
        AppLovinAdView appLovinAdView = new AppLovinAdView(this.mAppLovinSdk, appLovinAdSize, (Context)activity);
        appLovinAdView.setAdLoadListener((AppLovinAdLoadListener)this.mBNAdListener);
        appLovinAdView.setAdClickListener((AppLovinAdClickListener)this.mBNAdListener);
        appLovinAdView.setAdDisplayListener((AppLovinAdDisplayListener)this.mBNAdListener);
        return appLovinAdView;
    }

    public void destroyBanner(IronSourceBannerLayout ironSourceBannerLayout) {
    }

    protected void addBannerListener(BannerSmashListener bannerSmashListener) {
        this.mAllBannerSmashes.add(bannerSmashListener);
    }

    protected void removeBannerListener(BannerSmashListener bannerSmashListener) {
        this.mAllBannerSmashes.remove(bannerSmashListener);
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return CORE_SDK_VERSION;
    }

    public void onResume(Activity activity) {
        this.mActivity = activity;
    }

    private void init(final Activity activity, final String string2, final String string3, final int n2) {
        activity.runOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Boolean bl = AppLovinAdapter.this.mDidInitSdk;
                synchronized (bl) {
                    if (!AppLovinAdapter.this.mDidInitSdk.booleanValue()) {
                        AppLovinSdkSettings appLovinSdkSettings = new AppLovinSdkSettings();
                        boolean bl2 = false;
                        try {
                            bl2 = AppLovinAdapter.this.isAdaptersDebugEnabled();
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            // empty catch block
                        }
                        appLovinSdkSettings.setVerboseLogging(bl2);
                        AppLovinAdapter.this.mAppLovinSdk = AppLovinSdk.getInstance((String)string2, (AppLovinSdkSettings)appLovinSdkSettings, (Context)activity);
                        AppLovinAdapter.this.mAppLovinSdk.initializeSdk();
                        AppLovinAdapter.this.mDidInitSdk = true;
                    }
                    if (n2 == 1) {
                        AppLovinAdapter.this.mAppLovinIS = AppLovinInterstitialAd.create((AppLovinSdk)AppLovinAdapter.this.mAppLovinSdk, (Context)activity);
                        AppLovinAdapter.this.mAppLovinIS.setAdLoadListener((AppLovinAdLoadListener)AppLovinAdapter.this.mISAdLoadListener);
                        AppLovinAdapter.this.mAppLovinIS.setAdClickListener((AppLovinAdClickListener)AppLovinAdapter.this);
                        AppLovinAdapter.this.mAppLovinIS.setAdDisplayListener((AppLovinAdDisplayListener)AppLovinAdapter.this);
                        for (InterstitialSmashListener interstitialSmashListener : AppLovinAdapter.this.mAllInterstitialSmashes) {
                            if (interstitialSmashListener == null) continue;
                            interstitialSmashListener.onInterstitialInitSuccess();
                        }
                    } else if (n2 == 0) {
                        AppLovinAdapter.this.mAppLovinRV = AppLovinIncentivizedInterstitial.create((AppLovinSdk)AppLovinAdapter.this.mAppLovinSdk);
                        AppLovinAdapter.this.mAppLovinRV.setUserIdentifier(string3);
                        AppLovinAdapter.this.mAppLovinRV.preload((AppLovinAdLoadListener)AppLovinAdapter.this.mRVAdLoadListener);
                    } else if (n2 == 2) {
                        for (BannerSmashListener bannerSmashListener : AppLovinAdapter.this.mAllBannerSmashes) {
                            if (bannerSmashListener == null) continue;
                            bannerSmashListener.onBannerInitSuccess();
                        }
                    }
                }
            }
        });
    }

    public void initRewardedVideo(Activity activity, String string2, String string3, JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("sdkKey"))) {
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
            return;
        }
        this.mActivity = activity;
        this.init(activity, jSONObject.optString("sdkKey"), string3, 0);
    }

    public void fetchRewardedVideo(JSONObject jSONObject) {
        if (this.mAppLovinRV != null) {
            this.mAppLovinRV.preload((AppLovinAdLoadListener)this.mRVAdLoadListener);
        }
    }

    public void showRewardedVideo(JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        this.mActiveRewardedVideoSmash = rewardedVideoSmashListener;
        if (!TextUtils.isEmpty((CharSequence)this.getDynamicUserId())) {
            this.mAppLovinRV.setUserIdentifier(this.getDynamicUserId());
        }
        if (this.mAppLovinRV.isAdReadyToDisplay()) {
            this.mAppLovinRV.show((Context)this.mActivity, (AppLovinAdRewardListener)this, (AppLovinAdVideoPlaybackListener)this, (AppLovinAdDisplayListener)this, (AppLovinAdClickListener)this);
        } else {
            if (this.mActiveRewardedVideoSmash != null) {
                this.mActiveRewardedVideoSmash.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
            }
            for (RewardedVideoSmashListener rewardedVideoSmashListener2 : this.mAllRewardedVideoSmashes) {
                if (rewardedVideoSmashListener2 == null) continue;
                rewardedVideoSmashListener2.onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    public synchronized boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        return this.mAppLovinRV.isAdReadyToDisplay();
    }

    public void initInterstitial(Activity activity, String string2, String string3, JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("sdkKey"))) {
            if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Interstitial"));
            }
            return;
        }
        this.init(activity, jSONObject.optString("sdkKey"), string3, 1);
    }

    public void loadInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        this.mShouldNotifyLoadResult = true;
        this.mAppLovinSdk.getAdService().loadNextAd(AppLovinAdSize.INTERSTITIAL, (AppLovinAdLoadListener)this.mISAdLoadListener);
    }

    public void showInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        this.mActiveInterstitialSmash = interstitialSmashListener;
        if (this.mCurrentISAd != null) {
            this.mAppLovinIS.showAndRender(this.mCurrentISAd);
            this.mCurrentISAd = null;
        } else if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
        }
    }

    public boolean isInterstitialReady(JSONObject jSONObject) {
        return this.mCurrentISAd != null;
    }

    public void videoPlaybackBegan(AppLovinAd appLovinAd) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "videoPlaybackBegan", 1);
        if (this.mActiveRewardedVideoSmash != null) {
            this.mActiveRewardedVideoSmash.onRewardedVideoAdStarted();
        }
    }

    public void videoPlaybackEnded(AppLovinAd appLovinAd, double d2, boolean bl) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "videoPlaybackEnded ; isFullyWatched: " + bl, 1);
        if (this.mActiveRewardedVideoSmash != null) {
            this.mActiveRewardedVideoSmash.onRewardedVideoAdEnded();
            if (bl) {
                this.mActiveRewardedVideoSmash.onRewardedVideoAdRewarded();
            }
        }
    }

    public void userDeclinedToViewAd(AppLovinAd appLovinAd) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "userDeclinedToViewAd", 1);
        if (this.mActiveRewardedVideoSmash != null) {
            this.mActiveRewardedVideoSmash.onRewardedVideoAdClosed();
        }
    }

    public void userOverQuota(AppLovinAd appLovinAd, Map map) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "userOverQuota", 1);
    }

    public void userRewardRejected(AppLovinAd appLovinAd, Map map) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "userRewardRejected", 1);
    }

    public void userRewardVerified(AppLovinAd appLovinAd, Map map) {
    }

    public void validationRequestFailed(AppLovinAd appLovinAd, int n2) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "validationRequestFailed " + this.getErrorString(n2) + "(" + n2 + ")", 1);
    }

    public void adDisplayed(AppLovinAd appLovinAd) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "adDisplayed", 1);
        if (AppLovinAdType.INCENTIVIZED.equals((Object)appLovinAd.getType())) {
            if (this.mActiveRewardedVideoSmash != null) {
                this.mActiveRewardedVideoSmash.onRewardedVideoAdOpened();
            }
        } else if (AppLovinAdType.REGULAR.equals((Object)appLovinAd.getType()) && this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdOpened();
            this.mActiveInterstitialSmash.onInterstitialAdShowSucceeded();
        }
    }

    public void adHidden(AppLovinAd appLovinAd) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "adHidden", 1);
        if (AppLovinAdType.INCENTIVIZED.equals((Object)appLovinAd.getType())) {
            for (RewardedVideoSmashListener rewardedVideoSmashListener : this.mAllRewardedVideoSmashes) {
                if (rewardedVideoSmashListener == null) continue;
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
            this.mAppLovinRV.preload((AppLovinAdLoadListener)this.mRVAdLoadListener);
            if (this.mActiveRewardedVideoSmash != null) {
                this.mActiveRewardedVideoSmash.onRewardedVideoAdClosed();
            }
        } else if (AppLovinAdType.REGULAR.equals((Object)appLovinAd.getType()) && this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdClosed();
        }
    }

    public void adClicked(AppLovinAd appLovinAd) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "adClicked", 1);
        if (AppLovinAdType.REGULAR.equals((Object)appLovinAd.getType())) {
            if (this.mActiveInterstitialSmash != null) {
                this.mActiveInterstitialSmash.onInterstitialAdClicked();
            }
        } else if (AppLovinAdType.INCENTIVIZED.equals((Object)appLovinAd.getType()) && this.mActiveRewardedVideoSmash != null) {
            this.mActiveRewardedVideoSmash.onRewardedVideoAdClicked();
        }
    }

    private String getErrorString(int n2) {
        switch (n2) {
            case -102: {
                return "Ad fetch timeout";
            }
            case -300: {
                return "No ad pre-loaded";
            }
            case -500: {
                return "Server timeout";
            }
            case -400: {
                return "Unknown server error";
            }
            case -600: {
                return "User closed video before reward";
            }
            case 204: {
                return "No fill";
            }
            case -103: {
                return "No network available";
            }
            case -6: {
                return "Unable to render ad";
            }
            case -1: {
                return "Unspecified error";
            }
        }
        return "Unknown error";
    }

    private class ALBannerListener
    implements AppLovinAdClickListener,
    AppLovinAdDisplayListener,
    AppLovinAdLoadListener {
        private ALBannerListener() {
        }

        public void adClicked(AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Banner adClicked", 1);
            if (AppLovinAdapter.this.mActiveBannerSmash != null) {
                AppLovinAdapter.this.mActiveBannerSmash.onBannerAdClicked();
            }
        }

        public void adDisplayed(AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Banner adDisplayed", 1);
            if (AppLovinAdapter.this.mActiveBannerSmash != null) {
                AppLovinAdapter.this.mActiveBannerSmash.onBannerAdScreenPresented();
            }
        }

        public void adHidden(AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Banner adHidden", 1);
            if (AppLovinAdapter.this.mActiveBannerSmash != null) {
                AppLovinAdapter.this.mActiveBannerSmash.onBannerAdScreenDismissed();
            }
        }

        public void adReceived(AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Banner adReceived", 1);
            if (AppLovinAdapter.this.mActiveBannerSmash != null) {
                AppLovinAdapter.this.mActiveBannerSmash.onBannerAdLoaded();
            }
        }

        public void failedToReceiveAd(int n2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Banner failedToReceiveAd", 1);
            if (AppLovinAdapter.this.mActiveBannerSmash != null) {
                String string2 = AppLovinAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)string2);
                AppLovinAdapter.this.removeBannerViews();
                AppLovinAdapter.this.mActiveBannerSmash.onBannerAdLoadFailed(ironSourceError);
            }
        }
    }

    private class ALRewardedLoadListener
    implements AppLovinAdLoadListener {
        private ALRewardedLoadListener() {
        }

        public void adReceived(AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Rewarded Video adReceived", 1);
            for (RewardedVideoSmashListener rewardedVideoSmashListener : AppLovinAdapter.this.mAllRewardedVideoSmashes) {
                if (rewardedVideoSmashListener == null) continue;
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(true);
            }
        }

        public void failedToReceiveAd(int n2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Rewarded Video failedToReceiveAd", 1);
            for (RewardedVideoSmashListener rewardedVideoSmashListener : AppLovinAdapter.this.mAllRewardedVideoSmashes) {
                if (rewardedVideoSmashListener == null) continue;
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    private class ALInterLoadListener
    implements AppLovinAdLoadListener {
        private ALInterLoadListener() {
        }

        public void adReceived(AppLovinAd appLovinAd) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Interstitial adReceived", 1);
            AppLovinAdapter.this.mCurrentISAd = appLovinAd;
            if (AppLovinAdapter.this.mShouldNotifyLoadResult) {
                AppLovinAdapter.this.mShouldNotifyLoadResult = false;
                for (InterstitialSmashListener interstitialSmashListener : AppLovinAdapter.this.mAllInterstitialSmashes) {
                    if (interstitialSmashListener == null) continue;
                    interstitialSmashListener.onInterstitialAdReady();
                }
            }
        }

        public void failedToReceiveAd(int n2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Interstitial failedToReceiveAd", 1);
            String string2 = AppLovinAdapter.this.getErrorString(n2) + "( " + n2 + " )";
            if (AppLovinAdapter.this.mShouldNotifyLoadResult) {
                AppLovinAdapter.this.mShouldNotifyLoadResult = false;
                for (InterstitialSmashListener interstitialSmashListener : AppLovinAdapter.this.mAllInterstitialSmashes) {
                    if (interstitialSmashListener == null) continue;
                    interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)string2));
                }
            }
        }
    }
}

