package com.yodo1.plugin.dmp.yodo1.helper;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import android.text.TextUtils;

import com.yodo1.android.ops.net.HttpListener;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.android.ops.net.Yodo1RequestListener;
import com.yodo1.android.ops.net.Yodo1SDKResponse;
import com.yodo1.nohttp.Headers;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.plugin.dmp.yodo1.constants.AnalyticsConstant;
import com.yodo1.plugin.dmp.yodo1.constants.AnalyticsInfo;
import com.yodo1.plugin.dmp.yodo1.db.Yodo1UtilDao;
import com.yodo1.sdk.kit.MD5EncodeUtil;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1CommonUtils;
import com.yodo1.sdk.kit.Yodo1DeviceUtils;
import com.yodo1.sdk.kit.Yodo1OperatorUtils;
import com.yodo1.sdk.kit.Yodo1SdkUtils;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class Yodo1AnalyticsForYodo1 implements Yodo1RequestListener {
    private static final String TAG = "[Yodo1AnalyticsForYodo1] ";

    private static final String URL_LOG_EVENT = "https://da.yodo1api.com/log/event";

    private static Yodo1AnalyticsForYodo1 instance;
    private Yodo1UtilDao dao;
    private Activity activity;

    /**
     * 数据上报时间戳
     */
    private static long uptime;

    /**
     * 设备唯一识别码
     */
    private String deviceId;

    /**
     * google advertising identifier
     */
    private String gaid = "";

    private String appKey = "";
    private String channelCode = "";

    public Yodo1AnalyticsForYodo1() {
    }

    public void initSDK(final Activity activity, String appKey) {
        this.activity = activity;
        this.appKey = appKey;

        //设备ID
        deviceId = Yodo1DeviceUtils.getDeviceId(activity);
        channelCode = Yodo1SharedPreferences.getString(activity, "ChannelCode");
        if (TextUtils.isEmpty(channelCode)) {
            channelCode = Yodo1OnlineConfig.ChannelCode;
        }

        if (dao == null) {
            dao = new Yodo1UtilDao(activity);
        }
        //当表中已经保存有1w条数据时  删除表中所有数据
        if (dao.getLines() > 10000) {
            dao.deleteALL();
        }
    }

    public void onDestroy(final Activity activity) {
        try {
            dao.getClose();
        } catch (Exception ignored) {
        }
    }

    /**
     * 保存事件信息
     *
     * @param eventId
     * @param map
     */
    public void onEvent(String sessionId, String eventId, HashMap<String, Object> map) {
        JSONObject eventDataJson = new JSONObject();
        try {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() != null) {
                    eventDataJson.put(entry.getKey(), entry.getValue());
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }

        AnalyticsInfo info = new AnalyticsInfo();
        info.setChannel(channelCode);
        info.setSessionId(sessionId);
        info.setTimestamp(Yodo1CommonUtils.getUTCTime() + "");
        info.setDeviceId(deviceId);
        info.setEventId(eventId);
        info.setEventData(eventDataJson.toString());
        info.setClientVersion(SysUtils.getVersionName(activity));
        info.setEventType("event");
        YLog.d(TAG + "event: " + info.toString());
        dao.add(info);
    }

    /**
     * 保存启动信息
     *
     * @param context           Context
     * @param launchTime        应用启动的时间戳
     * @param sessionId         由客户端通过设备唯一识别码和当前时间生成以保证全局唯一
     * @param lastTimeSessionId
     * @param duration          应用持续时间，单位：秒
     */
    public void saveLaunchEvent(final Context context, final String launchTime, final String sessionId, final String lastTimeSessionId, final String duration) {
        new Thread(new Runnable() {
            @Override
            public void run() {
                Looper.prepare();
                try {
                    gaid = Yodo1DeviceUtils.getGoogleAdId(context);
                } catch (Exception e) {
                    e.printStackTrace();
                }

                saveLaunchData(context, launchTime, sessionId, lastTimeSessionId, duration);
                Looper.loop();
            }
        }).start();
    }

    private void saveLaunchData(Context context, String launchTime, String sessionId, String lastTimeSessionId, String duration) {
        try {
            JSONObject terminalJson = new JSONObject();
            terminalJson.put(AnalyticsConstant.KEY_SESSION_ID, lastTimeSessionId);
            //一个session内app运行时间
            terminalJson.put(AnalyticsConstant.KEY_DURATION, TextUtils.isEmpty(duration) ? "0" : duration);

            AnalyticsInfo info = new AnalyticsInfo();
            info.setChannel(channelCode);
            info.setSessionId(sessionId);
            info.setTimestamp(launchTime);
            info.setOs("android");
            info.setNetwork(Yodo1OperatorUtils.getNetWorkType(context));
            info.setDeviceId(deviceId);
            info.setOsVersion(Yodo1DeviceUtils.getOsVersion());
            info.setPhoneVersion(Yodo1DeviceUtils.getPhoneVersion());
            info.setDeviceName(Yodo1DeviceUtils.getPhoneBrand());
            info.setBundleId(SysUtils.getPackageName(context));
            info.setClientVersion(SysUtils.getVersionName(context));
            info.setGaid(gaid);
            info.setAndroidId(Yodo1DeviceUtils.getAndroidID(context));
            info.setImei(Yodo1DeviceUtils.getIMEI(context));
            info.setTerminal(terminalJson.toString());
            info.setEventType("launch");

            YLog.d(TAG + "launch: " + info.toString());
            //数据保存至数据库
            dao.add(info);
            //启动时事件上报
            Update(Yodo1AnalyticsForYodo1.this);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void Update(final Yodo1RequestListener listener) {
        if (TextUtils.isEmpty(appKey)) {
            YLog.d(TAG + "appKey为空, 中止上报");
            return;
        }

        YLog.d(TAG + "当前时间: " + Yodo1CommonUtils.getUTCTime());
        YLog.d(TAG + "上一次上传时间: " + uptime);
        // 5min上报一次  减3s，忽略数据缓存时时差
        if (Yodo1CommonUtils.getUTCTime() - uptime < AnalyticsConstant.REPORT_DATA_INTERVAL - 3000) {
            YLog.d(TAG + "5min上报一次数据, 未满足上报时间, 中止上报");
            return;
        }

        //上报时间
        uptime = Yodo1CommonUtils.getUTCTime();
        //请求时的时间戳
        String timestamp = Yodo1CommonUtils.getUTCTime() + "";
        String sign = MD5EncodeUtil.MD5Encode(appKey + timestamp + "logupload");

        List<AnalyticsInfo> infos = dao.queryAllAnalyticsInfo();

        if (infos == null || infos.size() == 0) {
            YLog.d(TAG + "上报数据为空, 中止上报");
            return;
        }

        JSONObject updataJson = new JSONObject();
        try {
            JSONArray array = new JSONArray();
            for (int j = 0; j < infos.size(); j++) {
                JSONObject object = new JSONObject();
                JSONObject objectDetail = new JSONObject();
                AnalyticsInfo info = infos.get(j);
                if (info.getEventType().equals(AnalyticsConstant.KEY_TYPE_EVENT)) {
                    objectDetail.put(AnalyticsConstant.KEY_SESSION_ID, info.getSessionId());
                    objectDetail.put(AnalyticsConstant.KEY_TIMESTAMP, info.getTimestamp());
                    objectDetail.put(AnalyticsConstant.KEY_DEVICE_ID, info.getDeviceId());
                    objectDetail.put(AnalyticsConstant.KEY_EVENT_ID, info.getEventId());
                    objectDetail.put(AnalyticsConstant.KEY_EVENT_DATA, new JSONObject(info.getEventData()));
                    objectDetail.put(AnalyticsConstant.KEY_GAME_PUBLISH_CHANNEL, info.getChannel());
                    objectDetail.put(AnalyticsConstant.KEY_GAME_VERSION, info.getClientVersion());

                    object.put(AnalyticsConstant.KEY_TYPE_EVENT, objectDetail);
                } else {
                    objectDetail.put(AnalyticsConstant.KEY_SESSION_ID, info.getSessionId());
                    objectDetail.put(AnalyticsConstant.KEY_TIMESTAMP, info.getTimestamp());
                    objectDetail.put(AnalyticsConstant.KEY_DEVICE_ID, info.getDeviceId());
                    objectDetail.put(AnalyticsConstant.KEY_DEVICE_OS, info.getOs());
                    objectDetail.put(AnalyticsConstant.KEY_DEVICE_OS_VERSION, info.getOsVersion());
                    objectDetail.put(AnalyticsConstant.KEY_DEVICE_PHONE_VERSION, info.getPhoneVersion());
                    objectDetail.put(AnalyticsConstant.KEY_DEVICE_NAME, info.getDeviceName());
                    objectDetail.put(AnalyticsConstant.KEY_GAME_VERSION, info.getClientVersion());
                    objectDetail.put(AnalyticsConstant.KEY_GAME_PACKAGE_NAME, info.getBundleId());
                    objectDetail.put(AnalyticsConstant.KEY_GAME_PUBLISH_CHANNEL, info.getChannel());
                    objectDetail.put(AnalyticsConstant.KEY_GOOGLE_AD_ID, info.getGaid());
                    objectDetail.put(AnalyticsConstant.KEY_IMEI, info.getImei());
                    objectDetail.put(AnalyticsConstant.KEY_ANDROID_ID, info.getAndroidId());
                    objectDetail.put(AnalyticsConstant.KEY_TERMINAL, new JSONObject(info.getTerminal()));

                    object.put(AnalyticsConstant.KEY_TYPE_LAUNCH, objectDetail);
                }

                array.put(object);
            }
            updataJson.put(AnalyticsConstant.KEY_GAME_APP_KEY, appKey);
            updataJson.put(AnalyticsConstant.KEY_TIMESTAMP, timestamp);
            updataJson.put(AnalyticsConstant.KEY_DATA, array);
            updataJson.put(AnalyticsConstant.KEY_SDK_VERSION, Yodo1SdkUtils.getSdkVersion(activity));
            updataJson.put(AnalyticsConstant.KEY_SDK_TYPE, Yodo1SdkUtils.getSdkType(activity));
            updataJson.put(AnalyticsConstant.KEY_SIGN, sign);

        } catch (JSONException e) {
            e.printStackTrace();
        }

        String submitStr = updataJson.toString();
        YLog.d(TAG + "Request body: " + submitStr);
        Request<String> request = NoHttp.createStringRequest(URL_LOG_EVENT, RequestMethod.POST);
        byte[] payloadData = null;
        try {
            payloadData = Yodo1CommonUtils.gzipCompress(submitStr);
            request.addHeader("Content-Length", String.valueOf(payloadData.length));
            request.addHeader(Headers.HEAD_KEY_CONTENT_ENCODING, "gzip");
        } catch (IOException e) {
            e.printStackTrace();
        }
        InputStream input = new ByteArrayInputStream(payloadData);
        request.setDefineRequestBody(input, Headers.HEAD_VALUE_CONTENT_TYPE_JSON);
        YLog.d(TAG + "Sending POST request to " + request.url());
        Yodo1HttpManage.getInstance().connect(101, request, new HttpListener<String>() {
            @Override
            public void onSucceed(int what, Response<String> response) {
                YLog.d(TAG + "Connect onSucceed, what: " + what + ", the response: " + (response == null ? "null" : response.get()));
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
                listener.onYodo1RequestComplete(resp);
            }

            @Override
            public void onFailed(int what, Response<String> response) {
                YLog.d(TAG + "Connect onFailed, what: " + what + ", the response: " + (response == null ? "null" : response.get()));
                Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
                listener.onYodo1RequestComplete(resp);
            }
        }, false);
    }

    @Override
    public void onYodo1RequestComplete(Yodo1SDKResponse responseObject) {
        String resMsg = responseObject.getResponseString();
        YLog.d(TAG + "yodo1游戏事件 上报结果： " + resMsg);

        if (!TextUtils.isEmpty(resMsg)) {
            try {
                JSONObject jsonObj = new JSONObject(resMsg);
                int errorCode = jsonObj.optInt("error_code");
                if (errorCode == 0) {
                    YLog.d(TAG + "yodo1游戏事件 上报成功 ");
                    //上传成功后清除指定数据
                    dao.deleteALL();
                }
            } catch (Exception e) {
                YLog.d(TAG + "onYodo1RequestComplete exception resMsg:" + resMsg);
            }
        } else {
            YLog.d(TAG + "yodo1游戏事件 上报失败  返回数据为空 ");
        }
    }
}

