package com.yodo1.advert.onlineconfig;


import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.YLog;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Created by zhuxiaochen on 2017/8/30.
 */

public class Yodo1OnlineConfigAgent {
    private static final String TAG = "[Yodo1OnlineConfigAgent] ";

    private static String VideoAdControl = "Platform_VideoAdControl";//视频广告比例及播放次数控制
    private static String VideoAdConfig = "Platform_VideoAdConfig";//视频广告key
    private static String VideoAdMasterSwitch = "Platform_VideoAdMasterSwitch";//视频广告开关

    private static String InterstitialAdMasterSwitch = "Platform_InterstitialAdMasterSwitch";//插屏广告开关
    private static String InterstitialAdControl = "Platform_InterstitialAdControl";//插屏广告比例及播放次数控制
    private static String InterstitialAdConfig = "Platform_InterstitialAdConfig";//插屏广告key
    private static String InterstitialAdInterval = "Platform_InterstitialAdInterval";//插屏广告时间间隔


    private static String BannerAdMasterSwitch = "Platform_BannerAdMasterSwitch";//banner广告开关
    private static String BannerAdControl = "Platform_BannerAdControl";//banner广告比例及播放次数控制
    private static String BannerAdConfig = "Platform_BannerAdConfig";//banner广告key
    private static String BannerAdSwitchingCycle = "Platform_BannerAdSwitchingCycle";//banner广告切换时间

    private static String NatoveAdMasterSwitch = "Platform_NativeAdMasterSwitch";//原生广告开关
    private static String NativeAdControl = "Platform_NativeAdControl";//原生广告播放列表
    private static String NativeAdConfig = "Platform_NativeAdConfig";//原生广告key或者广告位

    private static String SplashAdMasterSwitch = "Platform_SplashAdMasterSwitch";//splash广告开关
    private static String SplashAdControl = "Platform_SplashAdControl";//闪屏广告播放列表
    private static String SplashAdConfig = "Platform_SplashAdConfig";//闪屏广告key或者广告位


    private static String maxShowTimes = "maxShowTimes";//最大展示次数
    private static String ratio = "ratio";//播放比例

    private static String InterstitialAdTest = "interstitialAdConfig";//插屏广告测试信息
    private static String VideoAdTest = "videoAdConfig";//视频广告测试信息
    private static String BannerAdTest = "bannerAdConfig";//banner广告测试信息
    private static String NativeAdTest = "nativeAdConfig";//原生广告测试信息
    private static String SplashAdTest = "splashAdConfig";//开屏广告测试信息

    /**
     * 获取在线参数 时间间隔
     *
     * @return
     */
    public static String getIntervalConfigParam(AdvertType advertType) {

        String result = "0";//默认时间间隔为0s
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();//获取data数据
            if (advertType == AdvertType.Platform_InterstitialAd && obj != null && !obj.isNull(InterstitialAdInterval)) {
                result = obj.optString(InterstitialAdInterval);
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
        YLog.d(TAG + "[" + advertType.name() + "]  时间间隔: " + result);
        return result;
    }

    /**
     * 获取在线参数 轮询时间
     *
     * @return
     */
    public static String getSwitchingCycleConfigParam(AdvertType advertType) {

        String result = "30";//默认的时间间隔
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();//获取data数据
            if (advertType == AdvertType.Platform_BannerAd && obj != null && !obj.isNull(BannerAdSwitchingCycle)) {
                result = obj.optString(BannerAdSwitchingCycle);
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }
        YLog.d(TAG + "[" + advertType.name() + "]  循环时间: " + result);
        return result;
    }

    /**
     * 获取在线参数 开关
     *
     * @return
     */
    public static String getActiveConfigParam(AdvertType advertType) {

        String result = "off";
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();//获取data数据
            if (advertType == AdvertType.Platform_InterstitialAd) {
                if (obj != null && !obj.isNull(InterstitialAdMasterSwitch)) {
                    result = obj.optString(InterstitialAdMasterSwitch);
                }
            } else if (advertType == AdvertType.Platform_BannerAd) {
                if (obj != null && !obj.isNull(BannerAdMasterSwitch)) {
                    result = obj.optString(BannerAdMasterSwitch);
                }
            } else if (advertType == AdvertType.Platform_VideoAd) {
                if (obj != null && !obj.isNull(VideoAdMasterSwitch)) {
                    result = obj.optString(VideoAdMasterSwitch);
                }
            } else if (advertType == AdvertType.Platform_SplashAd) {
                if (obj != null && !obj.isNull(SplashAdMasterSwitch)) {
                    result = obj.optString(SplashAdMasterSwitch);
                }
            } else if (advertType == AdvertType.Platform_NativeAd) {
                if (obj != null && !obj.isNull(NatoveAdMasterSwitch)) {
                    result = obj.optString(NatoveAdMasterSwitch);
                }
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }

        YLog.d(TAG + "[" + advertType.name() + "]  开关: " + result);
        return result;
    }

    /**
     * 获取在线参数  广告key
     *
     * @return
     */
    public static String getKeyConfigParam(AdvertType advertType, String advertCode, String key) {
        String result = "";
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();//获取data数据
            JSONObject adconfig = null;
            if (obj != null) {
                if (advertType == AdvertType.Platform_InterstitialAd) {
                    if (!obj.isNull(InterstitialAdConfig)) {
                        adconfig = new JSONObject(obj.optString(InterstitialAdConfig));
                    }
                } else if (advertType == AdvertType.Platform_BannerAd) {
                    if (!obj.isNull(BannerAdConfig)) {
                        adconfig = new JSONObject(obj.optString(BannerAdConfig));
                    }
                } else if (advertType == AdvertType.Platform_VideoAd) {
                    if (!obj.isNull(VideoAdConfig)) {
                        adconfig = new JSONObject(obj.optString(VideoAdConfig));
                    }
                } else if (advertType == AdvertType.Platform_SplashAd) {
                    if (!obj.isNull(SplashAdConfig)) {
                        adconfig = new JSONObject(obj.optString(SplashAdConfig));
                    }
                } else if (advertType == AdvertType.Platform_NativeAd) {
                    if (!obj.isNull(NativeAdConfig)) {
                        adconfig = new JSONObject(obj.optString(NativeAdConfig));
                    }
                }

                if (adconfig != null) {
                    JSONObject adcode = null;
                    if (!adconfig.isNull(advertCode)) {
                        adcode = adconfig.optJSONObject(advertCode);
                    } else if (!adconfig.isNull(advertCode.toLowerCase())) {
                        adcode = adconfig.optJSONObject(advertCode.toLowerCase());
                    }

                    if (adcode != null && !adcode.isNull(key)) {
                        result = adcode.optString(key);
                    }
                }

            }
            YLog.d(TAG + "[" + advertType.name() + "]  key: " + key + ", value: " + result);

        } catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 获取在线参数 控制对象  包括比例或者权重，最大展示次数
     *
     * @return
     */
    public static List<AdsConfigEntity> getAdsControl(AdvertType advertType) {
        List<AdsConfigEntity> adsConfigEntities = new ArrayList<>();
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonData();//获取data数据
            JSONArray adControl = null;
            if (obj != null) {
                if (advertType == AdvertType.Platform_InterstitialAd) {
                    if (!obj.isNull(InterstitialAdControl)) {
                        adControl = new JSONArray(obj.optString(InterstitialAdControl));
                    }
                } else if (advertType == AdvertType.Platform_BannerAd) {
                    if (!obj.isNull(BannerAdControl)) {
                        adControl = new JSONArray(obj.optString(BannerAdControl));
                    }
                } else if (advertType == AdvertType.Platform_VideoAd) {
                    if (!obj.isNull(VideoAdControl)) {
                        adControl = new JSONArray(obj.optString(VideoAdControl));
                    }
                } else if (advertType == AdvertType.Platform_SplashAd) {
                    if (!obj.isNull(SplashAdControl)) {
                        adControl = new JSONArray(obj.optString(SplashAdControl));
                    }
                } else if (advertType == AdvertType.Platform_NativeAd) {
                    if (!obj.isNull(NativeAdControl)) {
                        adControl = new JSONArray(obj.optString(NativeAdControl));
                    }
                }

                if (adControl != null) {
                    YLog.d(TAG + "[" + advertType.name() + "]  adControl = " + adControl.toString());

                }


                if (adControl != null) {

                    for (int i = 0; i < adControl.length(); i++) {
                        JSONObject obj_adControl = new JSONObject(adControl.get(i).toString());

                        Iterator<String> advertCodes = obj_adControl.keys();  // 应用迭代器Iterator 获取所有的key值

                        while (advertCodes.hasNext()) {   // 遍历每个key
                            AdsConfigEntity adsConfigEntity = new AdsConfigEntity();

                            String advertCode = advertCodes.next().toString();
                            JSONObject obj_advertCode = new JSONObject(obj_adControl.optString(advertCode));
                            if (!obj_advertCode.isNull(ratio)) {
                                String adRatio = obj_advertCode.optString(ratio);
                                adsConfigEntity.setRatio(adRatio);
                            }

                            if (!obj_advertCode.isNull(maxShowTimes)) {
                                String adMaxShowTimes = obj_advertCode.optString(maxShowTimes);
                                adsConfigEntity.setMaxShowTimes(adMaxShowTimes);
                            }

                            adsConfigEntity.setAdvertCode(advertCode.toLowerCase());
                            adsConfigEntities.add(adsConfigEntity);
                        }
                    }

                }
            }

        } catch (JSONException e) {
            e.printStackTrace();
        }

        if (adsConfigEntities != null) {
            YLog.d(TAG + "[" + advertType.name() + "]  Control: " + adsConfigEntities.toString());
        }

        return adsConfigEntities;
    }

    /**
     * 判断高级测试模式
     *
     * @return
     */
    public static JSONObject getYodo1AdTestInfo(AdvertType advertType) {

        JSONObject adControl = null;
        try {
            JSONObject obj = Yodo1OnlineConfig.getInstance().getJsonTestData();//获取data数据
            if (obj != null) {
                JSONObject adObj = obj.optJSONObject("ad_list");

                if (adObj != null) {
                    if (advertType == AdvertType.Platform_InterstitialAd) {
                        if (!adObj.isNull(InterstitialAdTest)) {
                            adControl = new JSONObject(adObj.optString(InterstitialAdTest));
                        }
                    } else if (advertType == AdvertType.Platform_BannerAd) {
                        if (!adObj.isNull(BannerAdTest)) {
                            adControl = new JSONObject(adObj.optString(BannerAdTest));
                        }
                    } else if (advertType == AdvertType.Platform_VideoAd) {
                        if (!adObj.isNull(VideoAdTest)) {
                            adControl = new JSONObject(adObj.optString(VideoAdTest));
                        }
                    } else if (advertType == AdvertType.Platform_SplashAd) {
                        if (!adObj.isNull(SplashAdTest)) {
                            adControl = new JSONObject(adObj.optString(SplashAdTest));
                        }
                    } else if (advertType == AdvertType.Platform_NativeAd) {
                        if (!adObj.isNull(NativeAdTest)) {
                            adControl = new JSONObject(adObj.optString(NativeAdTest));
                        }
                    }

                    if (adControl != null) {
                        YLog.d(TAG + "[" + advertType.name() + "]  测试广告信息: " + adControl.toString());
                    }
                    return adControl;
                }

            }

        } catch (JSONException e) {
            e.printStackTrace();
        }

        return null;
    }

    /**
     * 广告类型
     */
    public enum AdvertType {
        /**
         * 插屏
         */
        Platform_InterstitialAd,
        /**
         * 视频
         */
        Platform_VideoAd,
        /*
         * Banner
         */
        Platform_BannerAd,
        /**
         * 原生
         */
        Platform_NativeAd,
        /*
         * 闪屏
         */
        Platform_SplashAd,
    }


}
