package com.sensorsdata.analytics.android.minisdk;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

/**
 * @author :huangguofeng
 * date :2020-03-24
 * package :com.sensorsdata.analytics.android.minisdk
 * desc    : Sensors 线程池
 */

 class SensorsDataThreadPool {
    private static SensorsDataThreadPool singleton;
    private static Executor mExecutor;

    public static SensorsDataThreadPool getInstance() {
        if (singleton == null) {
            synchronized (SensorsDataThreadPool.class) {
                if (singleton == null) {
                    singleton = new SensorsDataThreadPool();
                    mExecutor = Executors.newFixedThreadPool(1);
                }
            }
        }
        return singleton;
    }

    public void execute(Runnable runnable) {
        try {
            if (runnable != null) {
                mExecutor.execute(runnable);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
