package com.yodo1.sensor;

import android.content.Context;
import android.text.TextUtils;

import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.sdk.kit.YLog;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;


/**
 * @author :huangguofeng
 * date :2020-03-24
 * package :com.yodo1.sensor
 * desc    : 神策埋点入口类
 */
public class Yodo1Sensor {
    private static final String TAG = "[Yodo1Sensor] ";
    /**
     * 数据上传地址 正式url。默认数据接收地址
     */
    private static final String DEFAULT_RELEASE_URL = "https://youdaoyi.datasink.sensorsdata.cn/sa?project=production&token=7d89c1c8b84d30c8";

    private static final String KEY_SENSORS_SWITCH = "Sensors_Switch";
    private static final String KEY_SENSORS_SWITCH_DEBUG_MODE = "Sensors_Switch_DebugMode";
    private static final String KEY_SENSORS_SERVER_URL = "Sensors_ServerUrl";

    private static Yodo1SensorHelper helper = Yodo1SensorHelper.getInstance();
    private static boolean enabled = false;

    /**
     * 检查总开关，默认关闭
     */
    private static boolean isEnabled() {
        String enabled = Yodo1OnlineConfig.getInstance().getConfigParam(KEY_SENSORS_SWITCH, "off");
        return enabled.equals("on");
    }

    private static boolean isDebugMode() {
        String enabled = Yodo1OnlineConfig.getInstance().getConfigParam(KEY_SENSORS_SWITCH_DEBUG_MODE, "off");
        return enabled.equals("on");
    }

    private static String getServerUrl() {
        return Yodo1OnlineConfig.getInstance().getConfigParam(KEY_SENSORS_SERVER_URL, DEFAULT_RELEASE_URL);
    }

    public static void init(Context context) {
        YLog.d(TAG + "The Yodo1Sensor init  method is called...");
        if (helper.isInitialized()) {
            return;
        }
        if (isEnabled()) {
            enabled = true;
            YLog.d(TAG + "The sensor is turn on....");
            helper.init(context, getServerUrl(), isDebugMode());
        } else {
            enabled = false;
            YLog.d(TAG + "The sensor is turn off....");
        }
    }

    public static void destroy() {
        if (!enabled) {
            return;
        }
        YLog.d(TAG + "The onDestroy of activity life cycle method is called...");
        helper.onDestroy();
    }

    /**
     * desc：事件埋点
     *
     * @param eventId    事件名
     * @param properties 事件属性
     */
    public static void track(String eventId, JSONObject properties) {
        if (!enabled) {
            return;
        }
        YLog.d(TAG + "The track method is called...");
        appendReportFields(properties);
        helper.track(eventId, properties);
    }

    /**
     * desc：用户属性设置
     *
     * @param properties 事件属性
     */
    public static void profileSet(JSONObject properties) {
        if (!enabled) {
            return;
        }
        YLog.d(TAG + "The profileSet method is called...");
        helper.profileSet(properties);
    }

    /**
     * 获取神策绑定后的登录ID
     */
    public static String getLoginId() {
        if (!enabled) {
            return "";
        }
        YLog.d(TAG + "The getLoginId method is called...");
        return helper.getLoginId();
    }

    /**
     * 获取神策绑定之前自动生成的匿名ID
     */
    public static String getAnonymousId() {
        if (!enabled) {
            return "";
        }
        YLog.d(TAG + "The getAnonymousId method is called...");
        return helper.getAnonymousId();
    }

    /**
     * 绑定登录ID
     *
     * @param loginId 自己的用户系统标识用户的ID
     */
    public static void login(String loginId) {
        if (!enabled) {
            return;
        }
        YLog.d(TAG + "The login method is called...");
        helper.login(loginId);
    }

    /**
     * 解绑登录ID
     */
    public static void loginOut() {
        if (!enabled) {
            return;
        }
        YLog.d(TAG + "The loginOut method is called...");
        helper.loginOut();
    }

    /**
     * 应用启动事件埋点
     */
    public static void trackAppStartup() {
        if (!enabled) {
            return;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("startTime", System.currentTimeMillis() + "");
            track("startup", jsonObject);
            YLog.d(TAG + " track event : startup");
        } catch (JSONException e) {
            YLog.d(TAG + " track startup error to sensor : " + e.getMessage());
        }
    }

    /**
     * 应用退出事件埋点
     */
    public static void trackAppQuit() {
        if (!enabled) {
            return;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("endTime", System.currentTimeMillis() + "");
            track("end", jsonObject);
            YLog.d(TAG + " track event : end");
        } catch (JSONException e) {
            YLog.d(TAG + " track end error to sensor : " + e.getMessage());
        }
    }

    private static void appendReportFields(JSONObject properties) {
        JSONArray array = Yodo1OnlineConfig.getInstance().getReportFields();
        if(array == null){
            return;
        }
        for (int i = 0; i < array.length(); i++) {
            try {
                JSONObject object = array.getJSONObject(i);
                String key = null;
                if (object.has("key")) {
                    key = object.getString("key");
                }
                String value = null;
                if (object.has("value")) {
                    value = object.getString("value");
                }
                if (!TextUtils.isEmpty(key)) {
                    properties.put(key, value);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}
