package com.yodo1.sdk.kit;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author sunmeng
 */
public class Yodo1Privacy {

    private JSONObject jsonObject = new JSONObject();
    private boolean hasUserConsent;
    private boolean isAgeRestrictedUser;
    private boolean isDoNotSell;

    public Yodo1Privacy() {
        hasUserConsent = true;
        isAgeRestrictedUser = false;
        isDoNotSell = false;
    }

    public boolean isHasUserConsent() {
        return hasUserConsent;
    }

    public void setHasUserConsent(boolean hasUserConsent) {
        this.hasUserConsent = hasUserConsent;
    }

    public boolean isAgeRestrictedUser() {
        return isAgeRestrictedUser;
    }

    public void setAgeRestrictedUser(boolean ageRestrictedUser) {
        isAgeRestrictedUser = ageRestrictedUser;
    }

    public boolean isDoNotSell() {
        return isDoNotSell;
    }

    public void setDoNotSell(boolean doNotSell) {
        isDoNotSell = doNotSell;
    }

    public boolean isReportData() {
        if (!hasUserConsent) {
            return false;
        }
        if (isAgeRestrictedUser) {
            return false;
        }
        return !isDoNotSell;
    }

    public JSONObject toJson() {
        try {
            jsonObject.put("hasUserConsent", hasUserConsent);
            jsonObject.put("isAgeRestrictedUser", isAgeRestrictedUser);
            jsonObject.put("isDoNotSell", isDoNotSell);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }
}
