package com.yodo1.sdk.kit;


import android.content.Context;
import android.net.Uri;
import android.os.Environment;

import com.yodo1.sdk.base.android.Yodo1BaseUtils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;


/**
 * 读写sd卡
 *
 * @author yodo1
 */
public class YFileUtils {

    public static final String YODO1FILE = ".yodo1";
    public static final String YODO1_DEBUG_FILE = ".yodo1ads";

    /**
     * 写入并保存文件内容到SD卡
     *
     * @param content  Content
     * @param fileName fileName
     */
    public static void writeFilesToSDCard(String content, String fileName) {

        // 判断SD卡是否存在，并且本程序是否拥有SD卡的权限
        if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {

            // 获得SD卡的根目录
            File sdCardPath = Environment.getExternalStorageDirectory();
            /*
             * 文件输出操作
             * */
            File testFile = new File(sdCardPath, fileName);
            // 初始化文件输出流
            FileOutputStream fileOutputStream;
            // 以追加模式打开文件输出流
            try {
                fileOutputStream = new FileOutputStream(testFile, true);
                fileOutputStream.write(content.getBytes());
                // 关闭文件输出流
                fileOutputStream.close();
            } catch (FileNotFoundException e) {
                YLog.d("yodo1 缺少SD卡权限  写入文件失败");
            } catch (IOException e) {
                YLog.d("yodo1 缺少SD卡权限  写入文件失败");
            }

        }
    }

    /**
     * 从SD卡上读取文件内容
     *
     * @param fileName fileName
     * @return content
     */
    public static String readFilesFromSDCard(String fileName) {

        // 定义文件内容字符串
        String content = null;
        // 文件输入流
        FileInputStream fileInputStream;

        // 判断SD卡是否存在，并且本程序是否拥有SD卡的权限
        if (Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {

            // 获得SD卡的根目录
            File sdCardPath = Environment.getExternalStorageDirectory();
            /*
             * 文件输出操作
             * */
            try {
                File testFile = new File(sdCardPath, fileName);
                // 打开文件输入流
                fileInputStream = new FileInputStream(testFile);
                // 将文件输入流存放在ByteArrayOutputStream
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                // 定义每次读取一个字节
                byte[] buffer = new byte[1024];
                // 定义每次读取的字节长度
                int len;
                // 读取文件输入流的内容，并存入ByteArrayOutputStream中
                while ((len = fileInputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, len);
                }
                // 将文件输入流数据以字符串的形式存放
                content = outputStream.toString();
                // 关闭文件输入流
                fileInputStream.close();
                // 关闭ByteArrayOutputStream
                outputStream.close();
            } catch (FileNotFoundException e) {
                YLog.d("yodo1 缺少SD卡权限  读取文件失败");
            } catch (IOException e) {
                YLog.d("yodo1 缺少SD卡权限  读取文件失败");
            }
        }

        // 返回文件内容
        return content;
    }


    /**
     * 获取文件夹大小
     *
     * @param file File实例
     * @return long 单位为M
     */
    public static long getFolderSize(java.io.File file) {
        long size = 0;
        try {
            java.io.File[] fileList = file.listFiles();
            for (File value : fileList) {
                if (value.isDirectory()) {
                    size = size + getFolderSize(value);
                } else {
                    size = size + value.length();
                }
            }

            YLog.d("yodo1 获取文件大小 ： " + size);
            return size / 1048576;
        } catch (Exception e) {
            return 0;
        }
    }

    public static Uri getUriForFile(Context context, String providerName, File file) {
        return Yodo1BaseUtils.getUriForFile(context, providerName, file);
    }
}
