package com.yodo1.sdk.kit;

import android.content.Context;
import android.os.Looper;
import android.view.Gravity;

import com.yodo1.sdk.kit.toast.ToastCompat;


/**
 * 修复7.0出现的问题。对toast统一处理。
 *
 * @author yodo1
 */
public class ToastUtils {

    public static void showToast(final Context context, final CharSequence msg) {
        Runnable runnable = new Runnable() {
            @Override
            public void run() {
                ToastCompat.makeText(context, msg, ToastCompat.LENGTH_SHORT).show();
            }
        };
        show(runnable);
    }

    public static void showCenterToast(final Context context, final CharSequence msg) {
        Runnable runnable = new Runnable() {
            @Override
            public void run() {
                ToastCompat toastCompat = ToastCompat.makeText(context, msg, ToastCompat.LENGTH_SHORT);
                toastCompat.setGravity(Gravity.CENTER, 0, 0);
                toastCompat.show();
            }
        };
        show(runnable);
    }

    public static void showToast(final Context context, final CharSequence msg, final int duration) {
        Runnable runnable = new Runnable() {
            @Override
            public void run() {
                ToastCompat.makeText(context, msg, duration).show();
            }
        };
        show(runnable);
    }

    private static void show(Runnable toast) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            try {
                Looper.prepare();
                toast.run();
                Looper.loop();
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            toast.run();
        }
    }
}
