package com.yodo1.sdk.kit;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * 2020年06月12日19:16:27..
 * 没有key,或者value为null,则当做null。
 * ！！！注意，使用get***()要保证有key,有value且value类型正确。
 * ！！！使用opt***(),key,value异常则会走fallback默认值。
 *
 * @author yodo1
 */
public class JsonUtils {

    public static WrapJSONObject toJSONObject(String jsonString) throws JSONException {
        return new WrapJSONObject(jsonString);
    }

    public static class WrapJSONObject extends JSONObject {

        public WrapJSONObject(String jsonString) throws JSONException {
            super(jsonString);
        }

        @Override
        public Object get(String name) throws JSONException {
            return opt(name);
        }

        @Override
        public Object opt(String name) {
            Object opt = super.opt(name);
            if (opt == null) {
                return null;
            } else if (opt == JSONObject.NULL) {
                return null;
            } else {
                return opt;
            }
        }
    }
}
