package com.yodo1.sdk.base.android;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;

import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationCompat;
import androidx.core.content.FileProvider;

import java.io.File;

public class Yodo1BaseUtils {
    private static Yodo1BaseUtils baseUtils = new Yodo1BaseUtils();

    private Yodo1BaseUtils() {

    }

    public static Yodo1BaseUtils getInstance() {
        return baseUtils;
    }

    // 请求权限
    public static void requestPermission(Activity activity, String[] permission, int code) {
        ActivityCompat.requestPermissions(activity, permission, code);
    }

    // 检查权限
    public static boolean checkSelfPermission(Context context, String permission) {
        int result = ActivityCompat.checkSelfPermission(context, permission);
        if (result == PackageManager.PERMISSION_GRANTED) {
            return true;
        }
        return false;
    }

    //shouldShowRequestPermissionRationale是Google提供的是否要显示提示界面的方法。
    //如果用户曾经拒绝过权限，或者在设置界面里关掉过权限，那么会返回true
    //如果用户从来没有拒绝过权限，或者点了'不再提示'并拒绝，又或者系统本身不允许这种权限的出现。则会返回false
    public static boolean shouldShowRequestPermissionRationale(Activity activity, String permission) {
        return ActivityCompat.shouldShowRequestPermissionRationale(activity, permission);
    }

    @SuppressLint("MissingPermission")
    public static String getIMEI(Context context) {
        String imei = "";
        try {
            if (checkSelfPermission(context, Manifest.permission.READ_PHONE_STATE)) {
                TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
                if (Build.VERSION.SDK_INT > Build.VERSION_CODES.P) {
                    // targetVersion=29时 getImei会失败 这时候需要获取安卓ID
                    imei = Settings.System.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
                } else {
                    if (telephonyManager != null) {
                        imei = telephonyManager.getDeviceId();
                        if (TextUtils.isEmpty(imei) || "0".equals(imei) || "000000000000000".equals(imei)) {
                            imei = "";
                        }
                    }
                }

            } else {
                Log.e("Yodo1BaseUtils", "Android Support ：没READ_PHONE_STATE权限,无法读取IMEI");
            }

        } catch (Exception e) {

        }

        return imei;
    }

    public static Uri getUriForFile(Context context, String providerName, File file) {
        return FileProvider.getUriForFile(context, providerName, file);
    }

    public static Notification getNotification(Context context, Intent intent, PendingIntent pendingIntent, String channelId) {
        NotificationCompat.Builder builder = null;
        //android 8.0 以上
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            builder = new NotificationCompat.Builder(context, channelId);
        } else {
            builder = new NotificationCompat.Builder(context);
        }
        builder.setSmallIcon(intent.getIntExtra("smallicon", 0));
        builder.setContentTitle(intent.getStringExtra("title"));
        builder.setContentText(intent.getStringExtra("msg"));
        builder.setTicker(intent.getStringExtra("title"));
        builder.setAutoCancel(true);
        builder.setContentIntent(pendingIntent);
        builder.setDefaults(Notification.DEFAULT_SOUND);
        builder.setWhen(System.currentTimeMillis());
        builder.setNumber(1);
        builder.setLargeIcon(BitmapFactory.decodeResource(context.getResources(), intent.getIntExtra("icon", 0)));
        return builder.build();
    }

    public static Notification getNotification(Context context, String channelId) {
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(context, channelId);
        Notification notification = notificationBuilder.setOngoing(true)
//				.setSmallIcon(R.drawable.icon_1)
//				.setContentTitle("App is running in background")
                .setPriority(NotificationManager.IMPORTANCE_MIN)
                .setCategory(Notification.CATEGORY_SERVICE)
                .build();
        return notification;
    }
}
