package com.yodo1.android.ops.utils;

/**
 * Created by yodo1 on 2016/3/11.
 * @author huangguofeng更新
 * @date  2020/8/12
 * desc Ops网络请求回调
 */
public interface Yodo1OpsCallback {
    /**
     * 网络请求结果回调
     *
     * @param resultCode 网络请求结果
     * @param msg 网络请求结果附加信息
     */
    void onResult(ResultCode resultCode, String msg);

    /**
     * 网络请求结果类型
     */
    enum ResultCode {
        /**
         * 成功
         */
        Success("成功", 1),
        /**
         * 失败
         */
        Failed("失败", 0),
        /**
         * 取消
         */
        Cancel("取消", 2),
        /**
         * 漏单
         */
        Payment_Omissive("漏单", 4);

        /**
         * 结果
         */
        private String name;
        /**
         * 结果对应的code
         */
        private int value;

        ResultCode(String name, int value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String toString() {
            return name;
        }

        public int value() {
            return value;
        }
    }
}
