package com.yodo1.android.ops.net;

import com.yodo1.nohttp.Headers;
import com.yodo1.nohttp.rest.OnResponseListener;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.sdk.kit.YLog;

import org.json.JSONObject;

/**
 * 2020年06月04日21:36:09。zjq
 *
 * @author yodo1
 */
public abstract class HttpStringListener implements OnResponseListener<String> {

    protected String requestUrl;
    private static final String TAG = "HttpResponse";

    public HttpStringListener(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public HttpStringListener() {
    }

    /**
     * 开始请求, 这里显示一个dialog.
     */
    @Override
    public void onStart(int what) {
    }

    /**
     * 结束请求, 这里关闭dialog.
     */
    @Override
    public void onFinish(int what) {
    }

    /**
     * 成功回调.
     */
    @Override
    public void onSucceed(int what, Response<String> response) {
        print("onSucceed", what, response);
        Yodo1SDKResponse responseObject = Yodo1HttpManage.getInstance().getResponseObject(what, response);
        if (responseObject.isSuccess()) {
            onSuccess(responseObject.getErrorCode(), responseObject.getMessage(), responseObject.getResponse());
        } else {
            onFailure(responseObject.getErrorCode(), responseObject.getMessage());
        }
    }

    /**
     * 失败回调.
     */
    @Override
    public void onFailed(int what, Response<String> response) {
        print("onFailed", what, response);
        Yodo1SDKResponse responseObject = Yodo1HttpManage.getInstance().getResponseObject(what, response);
        onFailure(responseObject.getErrorCode(), responseObject.getMessage());
    }

    private void print(String msg, int what, Response<String> response) {
        YLog.i(TAG, "resultMsg" + msg + " what:" + what);
        if (response != null) {
            Request<String> request = response.request();
            if (request != null) {
                YLog.i(TAG, "responseUrl:" + request.url());
            }
            YLog.i(TAG, "responseCode:" + response.responseCode());
            YLog.i(TAG, "Exception:", response.getException());
            Headers headers = response.getHeaders();
            if (headers != null) {
                YLog.i(TAG, "Headers:" + headers.toJSONString());
            }
        } else {
            YLog.i(TAG, "response is null.");
        }
    }

    public abstract void onSuccess(int code, String msg, JSONObject responseString);

    public abstract void onFailure(int errorCode, String msg);
}
